/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.common;

import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.MathFun;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BaseOptAccumStats {
    protected int nEstParams = 0;
    protected double[] estParams = null;
    protected double objFun = 0.0;
    protected double[] gradient = null;
    protected DenseSymMatrix hessian = null;
    protected int accumStatsIndicator = 0;
    protected double accumWeight = 0.0;
    protected boolean minimizeObjFun = true;
    protected boolean checkSeparation = false;
    protected double obsRespProbMin = 0.0;
    protected double obsRespProbMax = 1.0;
    protected double compProbMin = 0.0;
    protected int nStepHalvings = 0;
    protected double[] objFunSHValues = null;
    protected int nEstParamSets = 0;
    private ArrayList<double[]> estParamSets = new ArrayList();
    protected double[] objFunAllValues = null;
    protected double[] estParamsCur = null;
    protected double[] estParamsChg = null;
    protected double initStep = 1.0;

    public BaseOptAccumStats() {
    }

    public BaseOptAccumStats(int nEstParams) {
        this.nEstParams = nEstParams;
        this.estParams = new double[nEstParams];
        this.gradient = new double[nEstParams];
    }

    public BaseOptAccumStats(int nEstParams, int accumStatsIndicator) {
        this(nEstParams);
        if (accumStatsIndicator == 1 || accumStatsIndicator == 2) {
            this.hessian = new DenseSymMatrix(nEstParams);
        }
        this.accumStatsIndicator = accumStatsIndicator;
    }

    public boolean setEstParams(double[] estParams) {
        return MathFun.dCopy((double[])estParams, (double[])this.estParams);
    }

    public double[] getEstParams() {
        return this.estParams;
    }

    public boolean getEstParams(double[] estParams) {
        return MathFun.dCopy((double[])this.estParams, (double[])estParams);
    }

    public void setMinimizeObjFun(boolean minimizeObjFun) {
        this.minimizeObjFun = minimizeObjFun;
    }

    public boolean getMinimizeObjFun() {
        return this.minimizeObjFun;
    }

    public void setNStepHalvings(int nStepHalvings) {
        this.nStepHalvings = nStepHalvings;
        this.objFunSHValues = new double[nStepHalvings];
        this.estParamsCur = new double[this.nEstParams];
        this.estParamsChg = new double[this.nEstParams];
    }

    public int getNStepHalvings() {
        return this.nStepHalvings;
    }

    public boolean setEstParamsCur(double[] estParamsCur) {
        return MathFun.dCopy((double[])estParamsCur, (double[])this.estParamsCur);
    }

    public boolean setEstParamsChg(double[] estParamsChg) {
        return MathFun.dCopy((double[])estParamsChg, (double[])this.estParamsChg);
    }

    public void setInitStep(double initStep) {
        this.initStep = initStep;
    }

    public void setNEstParamSets(int nEstParamSets) {
        this.nEstParamSets = nEstParamSets;
        this.objFunAllValues = new double[nEstParamSets];
    }

    public void reset(int accumStatsIndicator) {
        this.accumStatsIndicator = accumStatsIndicator;
        this.objFun = 0.0;
        if (this.accumStatsIndicator == 1 || this.accumStatsIndicator == 2 || this.accumStatsIndicator == 4) {
            if (this.gradient != null) {
                Arrays.fill(this.gradient, 0.0);
            }
            if (this.accumStatsIndicator == 1 || this.accumStatsIndicator == 2) {
                if (this.hessian == null) {
                    this.hessian = new DenseSymMatrix(this.nEstParams);
                } else {
                    this.hessian.clear();
                }
            }
        }
        if (accumStatsIndicator == 3 && this.objFunSHValues != null) {
            Arrays.fill(this.objFunSHValues, 0.0);
        }
        if (accumStatsIndicator == 5 && this.objFunAllValues != null) {
            Arrays.fill(this.objFunAllValues, 0.0);
        }
        this.accumWeight = 0.0;
    }

    public void reset(int accumStatsIndicator, boolean checkSeparation) {
        this.reset(accumStatsIndicator);
        this.checkSeparation = checkSeparation;
        this.obsRespProbMin = 0.0;
        this.obsRespProbMax = 1.0;
        this.compProbMin = 0.0;
    }

    public abstract boolean update(double[] var1, double var2);

    public abstract boolean update(double[] var1);

    public boolean merge(BaseOptAccumStats other) {
        boolean result;
        boolean bl = result = this.nEstParams == other.nEstParams;
        if (this.nEstParams == 0 && other.nEstParams != 0) {
            this.objFun = 0.0;
            this.accumWeight = 0.0;
            this.nEstParams = other.nEstParams;
            this.estParams = new double[this.nEstParams];
            this.gradient = new double[this.nEstParams];
            this.hessian = new DenseSymMatrix(this.nEstParams);
            this.accumStatsIndicator = other.accumStatsIndicator;
            this.checkSeparation = other.checkSeparation;
            this.obsRespProbMin = other.obsRespProbMin;
            this.obsRespProbMax = other.obsRespProbMax;
            this.compProbMin = other.compProbMin;
            this.nStepHalvings = other.nStepHalvings;
            this.objFunSHValues = (double[])(this.nStepHalvings == 0 ? null : new double[this.nStepHalvings]);
            this.nEstParamSets = other.nEstParamSets;
            this.objFunAllValues = (double[])(this.nEstParamSets == 0 ? null : new double[this.nEstParamSets]);
            result = true;
        }
        if (result && this.nEstParams > 0) {
            int i;
            this.objFun += other.objFun;
            this.accumWeight += other.accumWeight;
            for (i = 0; i < this.nEstParams; ++i) {
                int n = i;
                this.gradient[n] = this.gradient[n] + other.gradient[i];
            }
            if (this.hessian != null) {
                double[] arrayHessian = this.hessian.getMatrix();
                double[] arrayOtherHessian = other.hessian.getMatrix();
                for (int i2 = 0; i2 < arrayHessian.length; ++i2) {
                    int n = i2;
                    arrayHessian[n] = arrayHessian[n] + arrayOtherHessian[i2];
                }
            }
            if (this.nStepHalvings > 0 && other.nStepHalvings > 0) {
                for (i = 0; i < this.nStepHalvings; ++i) {
                    int n = i;
                    this.objFunSHValues[n] = this.objFunSHValues[n] + other.objFunSHValues[i];
                }
            }
            if (this.nEstParamSets > 0 && other.nEstParamSets > 0) {
                for (i = 0; i < this.nEstParamSets; ++i) {
                    int n = i;
                    this.objFunAllValues[n] = this.objFunAllValues[n] + other.objFunAllValues[i];
                }
            }
        }
        if (result && this.checkSeparation) {
            this.obsRespProbMin = Math.min(this.obsRespProbMin, other.obsRespProbMin);
            this.obsRespProbMax = Math.max(this.obsRespProbMax, other.obsRespProbMax);
            this.compProbMin = Math.min(this.compProbMin, other.compProbMin);
        }
        return result;
    }

    public boolean merge(List<? extends BaseOptAccumStats> others) {
        boolean result = true;
        for (int i = 0; result && i < others.size(); ++i) {
            BaseOptAccumStats other = others.get(i);
            if (other == null) continue;
            result = this.merge(other);
        }
        return result;
    }

    public double getObjFun() {
        return this.objFun;
    }

    public double[] getGradient() {
        return this.gradient;
    }

    public DenseSymMatrix getHessian() {
        return this.hessian;
    }

    public double getAccumWeight() {
        return this.accumWeight;
    }

    public boolean getProbs(double[] probs) {
        boolean result;
        boolean bl = result = probs.length >= 3;
        if (result) {
            probs[0] = this.obsRespProbMin;
            probs[1] = this.obsRespProbMax;
            probs[2] = this.compProbMin;
        }
        return result;
    }

    public double[] getObjFunSHValues() {
        return this.objFunSHValues;
    }

    public boolean getObjFunSHValues(double[] objFunSHValues) {
        boolean result = false;
        if (this.objFunSHValues != null) {
            return MathFun.dCopy((double[])this.objFunSHValues, (double[])objFunSHValues);
        }
        return result;
    }

    public double[] getObjFunAllValues() {
        return this.objFunAllValues;
    }

    public boolean getObjFunAllValues(double[] objFunAllValues) {
        boolean result = false;
        if (this.objFunAllValues != null) {
            return MathFun.dCopy((double[])this.objFunAllValues, (double[])objFunAllValues);
        }
        return result;
    }

    public ArrayList<double[]> getEstParamSets() {
        return this.estParamSets;
    }

    public void finishComputations() {
    }

    public void changeSign() {
        int i;
        this.objFun = -this.objFun;
        if (this.objFunSHValues != null) {
            for (i = 0; i < this.objFunSHValues.length; ++i) {
                this.objFunSHValues[i] = -this.objFunSHValues[i];
            }
        }
        if (this.objFunAllValues != null) {
            for (i = 0; i < this.objFunAllValues.length; ++i) {
                this.objFunAllValues[i] = -this.objFunAllValues[i];
            }
        }
        if (this.gradient != null) {
            for (i = 0; i < this.gradient.length; ++i) {
                this.gradient[i] = -this.gradient[i];
            }
        }
        if (this.hessian != null) {
            this.hessian.changeSign();
        }
    }
}

