/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.optimizer.neldermead;

import com.spss.ac.acmath.optimizer.common.BaseOptAccumStats;
import com.spss.ac.acmath.optimizer.common.ConverCrit;
import com.spss.ac.acmath.optimizer.common.OptimSettings;
import com.spss.ac.acmath.optimizer.common.PassiveOptimizer;
import com.spss.ac.acmath.optimizer.neldermead.NMSimplex;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.MathFun;
import java.util.ArrayList;

public class NelderMeadOptimizer
implements PassiveOptimizer {
    private PassiveOptimizer.OptimState optimState = PassiveOptimizer.OptimState.Uninitialized;
    private OptimSettings optimSettings = null;
    private int nEstParams = 0;
    private double[] estParams = null;
    private ConverCrit converCritCode = ConverCrit.NOT_ALL;
    private int lastIter = 0;
    private int accumStatsIndicator = 5;
    private double objFunCur = 0.0;
    private double objFunPrevIter = 0.0;
    private double objFunInit = 0.0;
    private double objFunFinal = 0.0;
    private double accumWeight = 0.0;
    private NMSimplex localSimplex = null;

    public NelderMeadOptimizer(int nEstParams) {
        this.nEstParams = nEstParams;
        this.optimSettings = new OptimSettings();
        this.estParams = new double[nEstParams];
    }

    public NelderMeadOptimizer(int nEstParams, OptimSettings optimSettings) {
        this(nEstParams);
        this.setOptimSettings(optimSettings);
    }

    private void setOptimSettings(OptimSettings optimSettings) {
        this.optimSettings = optimSettings;
    }

    @Override
    public boolean initialize(double[] estParams) {
        return false;
    }

    public boolean initialize(NMSimplex simplex) {
        boolean result;
        boolean bl = result = this.nEstParams == simplex.getNDimensions();
        if (result) {
            this.localSimplex = new NMSimplex(this.nEstParams);
            ArrayList<double[]> vertices = this.localSimplex.getVertices();
            simplex.copyVertices(vertices);
            this.optimState = PassiveOptimizer.OptimState.Initialized;
            this.accumStatsIndicator = 5;
            this.lastIter = 0;
        } else {
            this.optimState = PassiveOptimizer.OptimState.Invalid;
        }
        return result;
    }

    public void setNDCoefficients(double reflect, double expand, double contract, double reduce) {
        this.localSimplex.setCoefficients(reflect, expand, contract, reduce);
    }

    @Override
    public int getAccumStatsIndicator() {
        return this.accumStatsIndicator;
    }

    @Override
    public boolean processAccumStats(BaseOptAccumStats accumStats) {
        if (this.optimState != PassiveOptimizer.OptimState.Invalid) {
            if (this.optimState == PassiveOptimizer.OptimState.Uninitialized) {
                this.optimState = PassiveOptimizer.OptimState.Invalid;
            } else if (this.optimState == PassiveOptimizer.OptimState.Initialized) {
                this.processInitialized(accumStats);
            } else if (this.optimState == PassiveOptimizer.OptimState.Reflected) {
                this.processReflected(accumStats);
            } else if (this.optimState == PassiveOptimizer.OptimState.Expanded) {
                this.processExpanded(accumStats);
            } else if (this.optimState == PassiveOptimizer.OptimState.Contracted) {
                this.processContracted(accumStats);
            } else if (this.optimState == PassiveOptimizer.OptimState.Reduced) {
                this.processReduced(accumStats);
            }
        }
        return this.optimState == PassiveOptimizer.OptimState.Stopped;
    }

    @Override
    public boolean finished() {
        return this.optimState == PassiveOptimizer.OptimState.Stopped;
    }

    @Override
    public int getNIterations() {
        return this.lastIter;
    }

    @Override
    public ConverCrit getStopReason() {
        return this.converCritCode;
    }

    @Override
    public DenseSymMatrix getHessianGI() {
        return null;
    }

    @Override
    public double[] getEstParams() {
        return this.estParams;
    }

    public boolean getEstParams(double[] estParams) {
        return MathFun.dCopy((double[])this.estParams, (double[])estParams);
    }

    public PassiveOptimizer.OptimState getState() {
        return this.optimState;
    }

    public double getAccumWeight() {
        return this.accumWeight;
    }

    private void processInitialized(BaseOptAccumStats accumStats) {
        ++this.lastIter;
        this.localSimplex.setObjFunValues(accumStats.getObjFunAllValues());
        this.localSimplex.sortObjFunValues();
        this.localSimplex.computeCenterN();
        this.localSimplex.computeReflection();
        double[] reflectVec = this.localSimplex.getReflection();
        MathFun.dCopy((double[])reflectVec, (double[])this.estParams);
        this.optimState = PassiveOptimizer.OptimState.Reflected;
        this.accumStatsIndicator = 0;
        this.objFunCur = this.objFunInit = this.localSimplex.getBestObjFun();
        this.objFunPrevIter = this.objFunInit;
    }

    private void processReflected(BaseOptAccumStats accumStats) {
        ++this.lastIter;
        double reflectOF = accumStats.getObjFun();
        this.localSimplex.setObjFunReflect(reflectOF);
        double bestOF = this.localSimplex.getBestObjFun();
        double secWorstOF = this.localSimplex.getSecondWorstObjFun();
        if (reflectOF >= bestOF && reflectOF < secWorstOF) {
            this.localSimplex.replaceWorstWithReflection(reflectOF);
            this.localSimplex.sortObjFunValues();
            this.localSimplex.computeCenterN();
            this.localSimplex.computeReflection();
            double[] reflectVec = this.localSimplex.getReflection();
            MathFun.dCopy((double[])reflectVec, (double[])this.estParams);
            this.optimState = PassiveOptimizer.OptimState.Reflected;
            this.accumStatsIndicator = 0;
        } else if (reflectOF < bestOF) {
            this.localSimplex.computeExpansion();
            double[] expandVec = this.localSimplex.getExpansion();
            MathFun.dCopy((double[])expandVec, (double[])this.estParams);
            this.optimState = PassiveOptimizer.OptimState.Expanded;
            this.accumStatsIndicator = 0;
        } else {
            this.localSimplex.computeContraction();
            double[] contractVec = this.localSimplex.getContraction();
            MathFun.dCopy((double[])contractVec, (double[])this.estParams);
            this.optimState = PassiveOptimizer.OptimState.Contracted;
            this.accumStatsIndicator = 0;
        }
        this.converCritCode = this.checkForConvergence();
        if (this.converCritCode != ConverCrit.NOT_ALL) {
            this.optimState = PassiveOptimizer.OptimState.Stopped;
        }
    }

    private void processExpanded(BaseOptAccumStats accumStats) {
        double reflectOF;
        ++this.lastIter;
        double expandOF = accumStats.getObjFun();
        if (expandOF < (reflectOF = this.localSimplex.getObjFunReflect())) {
            this.localSimplex.replaceWorstWithExpansion(expandOF);
        } else {
            this.localSimplex.replaceWorstWithReflection(reflectOF);
        }
        this.localSimplex.computeCenterN();
        this.localSimplex.computeReflection();
        double[] reflectVec = this.localSimplex.getReflection();
        MathFun.dCopy((double[])reflectVec, (double[])this.estParams);
        this.optimState = PassiveOptimizer.OptimState.Reflected;
        this.accumStatsIndicator = 0;
        this.converCritCode = this.checkForConvergence();
        if (this.converCritCode != ConverCrit.NOT_ALL) {
            this.optimState = PassiveOptimizer.OptimState.Stopped;
        }
    }

    private void processContracted(BaseOptAccumStats accumStats) {
        double worstOF;
        ++this.lastIter;
        double contractOF = accumStats.getObjFun();
        if (contractOF < (worstOF = this.localSimplex.getWorstObjFun())) {
            this.localSimplex.replaceWorstWithContraction(contractOF);
            this.localSimplex.computeCenterN();
            this.localSimplex.computeReflection();
            double[] reflectVec = this.localSimplex.getReflection();
            MathFun.dCopy((double[])reflectVec, (double[])this.estParams);
            this.optimState = PassiveOptimizer.OptimState.Reflected;
            this.accumStatsIndicator = 0;
        } else {
            this.localSimplex.performReduction();
            this.optimState = PassiveOptimizer.OptimState.Reduced;
            this.accumStatsIndicator = 5;
        }
        this.converCritCode = this.checkForConvergence();
        if (this.converCritCode != ConverCrit.NOT_ALL) {
            this.optimState = PassiveOptimizer.OptimState.Stopped;
        }
    }

    private void processReduced(BaseOptAccumStats accumStats) {
        ++this.lastIter;
        this.localSimplex.setObjFunValues(accumStats.getObjFunAllValues());
        this.localSimplex.sortObjFunValues();
        this.localSimplex.computeCenterN();
        this.localSimplex.computeReflection();
        double[] reflectVec = this.localSimplex.getReflection();
        MathFun.dCopy((double[])reflectVec, (double[])this.estParams);
        this.optimState = PassiveOptimizer.OptimState.Reflected;
        this.accumStatsIndicator = 0;
        this.converCritCode = this.checkForConvergence();
        if (this.converCritCode != ConverCrit.NOT_ALL) {
            this.optimState = PassiveOptimizer.OptimState.Stopped;
        }
    }

    private ConverCrit checkForConvergence() {
        ConverCrit result = ConverCrit.NOT_ALL;
        double denomIncr = this.optimSettings.getDenomIncr();
        boolean objFunAbsChange = this.optimSettings.getObjFunAbsChange();
        double objFunConverCrit = this.optimSettings.getObjFunConver4NelderMead();
        double conver = 0.0;
        conver = objFunAbsChange ? this.localSimplex.getAbsConver() : this.localSimplex.getRelConver(denomIncr);
        int maxIter = this.optimSettings.getMaxIter4NelderMead();
        if (conver <= objFunConverCrit) {
            result = ConverCrit.ALL_CONVERGED;
        } else if (this.lastIter >= maxIter) {
            result = ConverCrit.MAX_ITERATIONS;
        }
        this.objFunPrevIter = this.objFunCur;
        this.objFunFinal = this.objFunCur = this.localSimplex.getBestObjFun();
        return result;
    }

    public double getObjFunInit() {
        return this.objFunInit;
    }

    @Override
    public double getObjFunFinal() {
        return this.objFunFinal;
    }

    public double getObjFunChangeLastIter() {
        return this.objFunCur - this.objFunPrevIter;
    }

    public double getInitCoefForLineSearch() {
        return MissingValue.getMissing();
    }

    @Override
    public double getInitCoefForStepHalving() {
        return MissingValue.getMissing();
    }

    @Override
    public double[] getEstParamsChgForStepHalving() {
        return null;
    }

    @Override
    public double[] getEstParamsForStepHalving() {
        return null;
    }

    public NMSimplex getLocalSimplex() {
        return this.localSimplex;
    }
}

