/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.math.MissingValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class GainsChart {
    public static List<LiftInfo> getRegressionGains(RegDataInfo[] regDataInfoArr, int numberOfSegments) {
        ArrayList<LiftInfo> gainList = new ArrayList<LiftInfo>();
        if (regDataInfoArr.length == 0) {
            return gainList;
        }
        Arrays.sort(regDataInfoArr, new Comparator<RegDataInfo>(){

            @Override
            public int compare(RegDataInfo object1, RegDataInfo object2) {
                return Double.compare(object2.predictedValue, object1.predictedValue);
            }
        });
        int segSize = regDataInfoArr.length / numberOfSegments;
        int sizeOfFirstSegment = 0;
        double firstSegment = 0.01 * (double)regDataInfoArr.length;
        sizeOfFirstSegment = firstSegment > 0.5 ? (int)firstSegment + 1 : 0;
        int actualNumOfSegs = 0;
        if (0 == segSize) {
            actualNumOfSegs = regDataInfoArr.length;
            segSize = 1;
        } else {
            actualNumOfSegs = sizeOfFirstSegment >= 1 ? numberOfSegments + 1 : numberOfSegments;
        }
        if (sizeOfFirstSegment == 0) {
            sizeOfFirstSegment = segSize;
        }
        int totalNum = 0;
        RegGainChartHelper regGainHelper = new RegGainChartHelper();
        for (int i = 0; i < actualNumOfSegs; ++i) {
            regGainHelper.reset();
            if (0 == i) {
                for (int k = 0; k < sizeOfFirstSegment; ++k) {
                    regGainHelper.update(regDataInfoArr[k]);
                }
            } else {
                int baseIndex = sizeOfFirstSegment + (i - 1) * segSize;
                if (baseIndex >= regDataInfoArr.length) break;
                for (int k = baseIndex; k < baseIndex + segSize && k < regDataInfoArr.length; ++k) {
                    regGainHelper.update(regDataInfoArr[k]);
                }
            }
            LiftInfo liftInfo = new LiftInfo();
            liftInfo.numOfRecords = (totalNum += regGainHelper.totalNumOfCases);
            liftInfo.numOfOKs = regGainHelper.sumActualValues;
            liftInfo.limitValue = regGainHelper.minPredValue;
            liftInfo.meanValue = regGainHelper.sumPredictedValues / (double)regGainHelper.totalNumOfCases;
            gainList.add(liftInfo);
        }
        return gainList;
    }

    public static List<List<LiftInfo>> getClassGains(ClassDataInfo[][] classDataInfo2dArr, int numberOfSegments) {
        ArrayList<List<LiftInfo>> fGains = new ArrayList<List<LiftInfo>>();
        for (int catIndex = 0; catIndex < classDataInfo2dArr.length; ++catIndex) {
            Arrays.sort(classDataInfo2dArr[catIndex], new Comparator<ClassDataInfo>(){

                @Override
                public int compare(ClassDataInfo object1, ClassDataInfo object2) {
                    return Double.compare(object2.targetConfidence, object1.targetConfidence);
                }
            });
        }
        ClassGainChartHelper classGainHelper = new ClassGainChartHelper();
        for (int catIndex = 0; catIndex < classDataInfo2dArr.length; ++catIndex) {
            ArrayList<LiftInfo> liftInfos = new ArrayList<LiftInfo>();
            int segSize = classDataInfo2dArr[catIndex].length / numberOfSegments;
            int sizeOfFirstSegment = 0;
            double firstSegment = 0.01 * (double)classDataInfo2dArr[catIndex].length;
            sizeOfFirstSegment = firstSegment > 0.5 ? (int)firstSegment + 1 : 0;
            int actualNumOfSegs = 0;
            if (0 == segSize) {
                actualNumOfSegs = classDataInfo2dArr[catIndex].length;
                segSize = 1;
            } else {
                actualNumOfSegs = sizeOfFirstSegment >= 1 ? numberOfSegments + 1 : numberOfSegments;
            }
            if (sizeOfFirstSegment == 0) {
                sizeOfFirstSegment = segSize;
            }
            int totalNum = 0;
            for (int i = 0; i < actualNumOfSegs; ++i) {
                classGainHelper.reset();
                if (0 == i) {
                    for (int k = 0; k < sizeOfFirstSegment; ++k) {
                        classGainHelper.update(classDataInfo2dArr[catIndex][k]);
                    }
                } else {
                    int baseIndex = sizeOfFirstSegment + (i - 1) * segSize;
                    if (baseIndex >= classDataInfo2dArr[catIndex].length) break;
                    for (int k = baseIndex; k < baseIndex + segSize && k < classDataInfo2dArr[catIndex].length; ++k) {
                        classGainHelper.update(classDataInfo2dArr[catIndex][k]);
                    }
                }
                LiftInfo liftInfo = new LiftInfo();
                liftInfo.numOfRecords = (totalNum += classGainHelper.totalNumOfCases);
                liftInfo.numOfOKs = classGainHelper.totalNumOfOKs;
                liftInfo.limitValue = classGainHelper.minConfidence;
                liftInfo.meanValue = classGainHelper.sumConfidences / (double)classGainHelper.totalNumOfCases;
                liftInfos.add(liftInfo);
            }
            fGains.add(liftInfos);
        }
        return fGains;
    }

    private static class ClassGainChartHelper {
        private double sumConfidences;
        private int totalNumOfCases;
        private int totalNumOfOKs;
        private double minConfidence;

        public ClassGainChartHelper() {
            this.reset();
        }

        public void reset() {
            this.sumConfidences = 0.0;
            this.totalNumOfCases = 0;
            this.totalNumOfOKs = 0;
            this.minConfidence = Double.MAX_VALUE;
        }

        public void update(ClassDataInfo dataInfo) {
            this.sumConfidences += dataInfo.targetConfidence * dataInfo.weight;
            this.totalNumOfCases += (int)dataInfo.weight;
            if (dataInfo.isOK) {
                this.totalNumOfOKs += (int)dataInfo.weight;
            }
            if (this.minConfidence > dataInfo.targetConfidence) {
                this.minConfidence = dataInfo.targetConfidence;
            }
        }
    }

    private static class RegGainChartHelper {
        private double sumPredictedValues;
        private double sumActualValues;
        private int totalNumOfCases;
        private double minPredValue;

        public RegGainChartHelper() {
            this.reset();
        }

        public void reset() {
            this.sumPredictedValues = 0.0;
            this.sumActualValues = 0.0;
            this.totalNumOfCases = 0;
            this.minPredValue = Double.MAX_VALUE;
        }

        public void update(RegDataInfo dataInfo) {
            this.sumPredictedValues += dataInfo.predictedValue * dataInfo.weight;
            this.sumActualValues += dataInfo.actualValue * dataInfo.weight;
            this.totalNumOfCases += (int)dataInfo.weight;
            if (dataInfo.predictedValue < this.minPredValue) {
                this.minPredValue = dataInfo.predictedValue;
            }
        }
    }

    public static class LiftInfo {
        private int numOfRecords;
        private double numOfOKs;
        private double limitValue;
        private double meanValue;

        public LiftInfo() {
            this(0, 0.0, MissingValue.getMissing(), MissingValue.getMissing());
        }

        public LiftInfo(int numOfRecords, double numOfOKs, double limitValue, double meanValue) {
            this.numOfRecords = numOfRecords;
            this.numOfOKs = numOfOKs;
            this.limitValue = limitValue;
            this.meanValue = meanValue;
        }

        public int getNumOfRecords() {
            return this.numOfRecords;
        }

        public double getNumOfOKs() {
            return this.numOfOKs;
        }

        public double getLimitValue() {
            return this.limitValue;
        }

        public double getMeanValue() {
            return this.meanValue;
        }
    }

    public static class ClassDataInfo {
        private double targetConfidence;
        private boolean isOK;
        private double weight;

        public ClassDataInfo(double confidence, boolean isOK, double weight) {
            this.targetConfidence = confidence;
            this.isOK = isOK;
            this.weight = weight;
        }

        public double getTargetConfidence() {
            return this.targetConfidence;
        }

        public boolean isOK() {
            return this.isOK;
        }

        public double getWeight() {
            return this.weight;
        }
    }

    public static class RegDataInfo {
        private double predictedValue;
        private double actualValue;
        private double weight;

        public RegDataInfo(double predictedvalue, double actualvalue, double weight) {
            this.predictedValue = predictedvalue;
            this.actualValue = actualvalue;
            this.weight = weight;
        }

        public double getPredictedValue() {
            return this.predictedValue;
        }

        public double getActualValue() {
            return this.actualValue;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

