/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.ac.acmapreduce.Mergeable;
import com.spss.ac.acxml.variatedata.VariateData;
import com.spss.ac.acxml.variatedata.XMLCoordinates;
import com.spss.math.MissingValue;
import com.spss.utilities.i18n.LocMsgId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HistogramData
implements ACSerializable,
Cloneable,
Mergeable<HistogramData> {
    private static final long serialVersionUID = 1L;
    protected int nBins = 1;
    protected double binLength = 0.0;
    protected double[] meansArray = null;
    protected double[] nCasesArray = null;
    protected double[] weightArray = null;
    protected double minValue = -1.0;
    protected double maxValue = 1.0;
    protected double realMin = Double.MAX_VALUE;
    protected double realMax = -1.7976931348623157E308;
    protected boolean isNeedStdDev = false;
    protected boolean bConst = false;
    protected double weightNCases = 0.0;
    protected double fTotalFreqWeightNCases = 0.0;
    protected double unweightedNCases = 0.0;
    protected double overallMean = 0.0;
    protected double secMoment = 0.0;
    protected VariateData variateData = null;
    protected int nMerged;

    public HistogramData() {
    }

    public HistogramData(int nBins, double minVal, double maxVal, boolean bNeedStdDev) {
        this.nBins = nBins;
        this.isNeedStdDev = bNeedStdDev;
        this.maxValue = maxVal;
        this.minValue = minVal;
        boolean bl = this.bConst = maxVal == minVal;
        if (nBins < 1 || minVal >= maxVal) {
            nBins = 1;
            this.nBins = 1;
        }
        if (maxVal > minVal && nBins > 1) {
            this.binLength = (maxVal - minVal) / (double)nBins;
        }
        this.meansArray = new double[nBins];
        this.nCasesArray = new double[nBins];
        this.weightArray = new double[nBins];
        for (int i = 0; i < nBins; ++i) {
            this.meansArray[i] = 0.0;
            this.nCasesArray[i] = 0.0;
            this.weightArray[i] = 0.0;
        }
    }

    public boolean updateData(double freqWeight, double regrWeight, double varValue) {
        boolean result = true;
        int binIndex = 0;
        if (this.nBins > 1) {
            binIndex = (int)((varValue - this.minValue) / this.binLength);
            if (binIndex < 0) {
                binIndex = 0;
            } else if (binIndex >= this.nBins) {
                binIndex = this.nBins - 1;
            }
        }
        double recWeight = freqWeight * regrWeight;
        double oldSumOfW = this.weightNCases;
        this.weightNCases += recWeight;
        double oldMean = this.overallMean;
        double nu = recWeight / this.weightNCases * (varValue - this.overallMean);
        double newMean = oldMean + nu;
        if (Math.abs(newMean) < 2.0 * Math.abs(oldMean) * 2.220446049250313E-16) {
            newMean = 0.0;
        }
        this.overallMean = newMean;
        this.unweightedNCases += 1.0;
        this.fTotalFreqWeightNCases += freqWeight;
        if (this.isNeedStdDev) {
            this.secMoment = oldSumOfW / this.weightNCases * this.secMoment + oldSumOfW / recWeight * nu * nu;
        }
        if (MissingValue.isMissing((double)this.meansArray[binIndex])) {
            this.meansArray[binIndex] = 0.0;
        }
        int n = binIndex;
        this.weightArray[n] = this.weightArray[n] + recWeight;
        int n2 = binIndex;
        this.nCasesArray[n2] = this.nCasesArray[n2] + freqWeight;
        double binRatio = recWeight / this.weightArray[binIndex];
        double incr = (varValue - this.meansArray[binIndex]) * binRatio;
        int n3 = binIndex;
        this.meansArray[n3] = this.meansArray[n3] + incr;
        if (this.realMin > varValue) {
            this.realMin = varValue;
        }
        if (this.realMax < varValue) {
            this.realMax = varValue;
        }
        return result;
    }

    public VariateData generateVariateData(String varName) {
        this.variateData = new VariateData();
        this.variateData.setStrDescr("Histogram");
        ArrayList<XMLCoordinates> coordinates = new ArrayList<XMLCoordinates>();
        coordinates.add(new XMLCoordinates());
        coordinates.add(new XMLCoordinates());
        this.variateData.setCoordinates(coordinates);
        if (varName.length() > 0) {
            ((XMLCoordinates)coordinates.get(0)).setFeature("observed");
            ((XMLCoordinates)coordinates.get(0)).setField(varName);
        }
        ((XMLCoordinates)coordinates.get(1)).setFeature("frequency");
        ((XMLCoordinates)coordinates.get(0)).setType(1);
        ((XMLCoordinates)coordinates.get(1)).setType(1);
        ArrayList<Double> means = new ArrayList<Double>();
        ((XMLCoordinates)coordinates.get(0)).setDoubleVals(means);
        ArrayList<Double> nCases = new ArrayList<Double>();
        ((XMLCoordinates)coordinates.get(1)).setDoubleVals(nCases);
        if (this.nCasesArray != null && this.meansArray != null) {
            for (int i = 0; i < this.nCasesArray.length; ++i) {
                if (!(this.nCasesArray[i] > 0.0)) continue;
                means.add(this.meansArray[i]);
                nCases.add(this.nCasesArray[i]);
            }
        }
        this.variateData.addNumStat("min", this.realMin);
        this.variateData.addNumStat("max", this.realMax);
        this.variateData.addNumStat("mean", this.overallMean);
        if (this.isNeedStdDev) {
            double stddev = 0.0;
            if (this.weightNCases > 1.0) {
                double variance = this.secMoment * this.weightNCases / (this.weightNCases - 1.0);
                stddev = Math.sqrt(variance);
            }
            this.variateData.addNumStat("stdDeviation", stddev);
        }
        return this.variateData;
    }

    public double getTotalWeight() {
        return this.fTotalFreqWeightNCases;
    }

    public double getRealMin() {
        return this.realMin;
    }

    public double getRealMax() {
        return this.realMax;
    }

    public double getMean() {
        return this.overallMean;
    }

    public double getStdDev() {
        double result = 0.0;
        if (this.isNeedStdDev && this.weightNCases > 1.0) {
            double variance = this.secMoment * this.weightNCases / (this.weightNCases - 1.0);
            result = Math.sqrt(variance);
        }
        return result;
    }

    public void addObjects(List<HistogramData> others) {
        int j;
        int i;
        int nAdded = others.size();
        int first = 0;
        if (this.unweightedNCases == 0.0) {
            int i2;
            HistogramData firstHist = others.get(0);
            this.nBins = firstHist.nBins;
            this.binLength = firstHist.binLength;
            this.meansArray = firstHist.meansArray;
            this.nCasesArray = new double[firstHist.nCasesArray.length];
            for (i2 = 0; i2 < firstHist.nCasesArray.length; ++i2) {
                this.nCasesArray[i2] = firstHist.nCasesArray[i2];
            }
            this.weightArray = new double[firstHist.weightArray.length];
            for (i2 = 0; i2 < firstHist.weightArray.length; ++i2) {
                this.weightArray[i2] = firstHist.weightArray[i2];
            }
            this.minValue = firstHist.minValue;
            this.maxValue = firstHist.maxValue;
            this.realMin = firstHist.realMin;
            this.realMax = firstHist.realMax;
            this.isNeedStdDev = firstHist.isNeedStdDev;
            this.bConst = firstHist.bConst;
            this.weightNCases = firstHist.weightNCases;
            this.fTotalFreqWeightNCases = firstHist.fTotalFreqWeightNCases;
            this.unweightedNCases = firstHist.unweightedNCases;
            this.overallMean = firstHist.overallMean;
            this.secMoment = firstHist.secMoment;
            first = 1;
        }
        boolean bMergeError = false;
        double totalNCases = this.unweightedNCases;
        double totalFreqWeight = this.fTotalFreqWeightNCases;
        double[] vWeight = Arrays.copyOf(this.weightArray, this.weightArray.length);
        double sum1 = 0.0;
        double sum2 = 0.0;
        if (this.isNeedStdDev) {
            sum1 += this.weightNCases * this.secMoment;
            sum2 += this.weightNCases * this.overallMean * this.overallMean;
        }
        for (i = first; i < nAdded && !bMergeError; ++i) {
            if (!(others.get((int)i).unweightedNCases > 0.0)) continue;
            if (others.get((int)i).nBins == this.nBins && Double.compare(others.get((int)i).minValue, this.minValue) == 0 && Double.compare(others.get((int)i).binLength, this.binLength) == 0 && others.get((int)i).isNeedStdDev == this.isNeedStdDev) {
                totalNCases += others.get((int)i).unweightedNCases;
                totalFreqWeight += others.get((int)i).fTotalFreqWeightNCases;
                for (j = 0; j < this.nCasesArray.length; ++j) {
                    int n = j;
                    this.nCasesArray[n] = this.nCasesArray[n] + others.get((int)i).nCasesArray[j];
                    int n2 = j;
                    this.weightArray[n2] = this.weightArray[n2] + others.get((int)i).weightArray[j];
                }
                continue;
            }
            bMergeError = true;
        }
        if (bMergeError) {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        if (totalNCases > 0.0) {
            double coeff;
            this.unweightedNCases = totalNCases;
            this.fTotalFreqWeightNCases = totalFreqWeight;
            for (j = 0; j < this.weightArray.length; ++j) {
                if (!(this.weightArray[j] > 0.0)) continue;
                coeff = vWeight[j] / this.weightArray[j];
                int n = j;
                this.meansArray[n] = this.meansArray[n] * coeff;
            }
            for (i = first; i < nAdded && !bMergeError; ++i) {
                if (!(others.get((int)i).unweightedNCases > 0.0)) continue;
                for (j = 0; j < this.weightArray.length; ++j) {
                    if (!(others.get((int)i).weightArray[j] > 0.0)) continue;
                    coeff = others.get((int)i).weightArray[j] / this.weightArray[j];
                    int n = j;
                    this.meansArray[n] = this.meansArray[n] + coeff * others.get((int)i).meansArray[j];
                }
            }
            for (i = first; i < nAdded && !bMergeError; ++i) {
                this.weightNCases += others.get((int)i).weightNCases;
                double oldMean = this.overallMean;
                double varValue = others.get((int)i).overallMean;
                double nu = others.get((int)i).weightNCases / this.weightNCases * (varValue - this.overallMean);
                double newMean = oldMean + nu;
                if (Math.abs(newMean) < 2.0 * Math.abs(oldMean) * 2.220446049250313E-16) {
                    newMean = 0.0;
                }
                this.overallMean = newMean;
                if (this.isNeedStdDev) {
                    sum1 += others.get((int)i).weightNCases * others.get((int)i).secMoment;
                    sum2 += others.get((int)i).weightNCases * others.get((int)i).overallMean * others.get((int)i).overallMean;
                }
                if (this.realMin > others.get((int)i).realMin) {
                    this.realMin = others.get((int)i).realMin;
                }
                if (!(this.realMax < others.get((int)i).realMax)) continue;
                this.realMax = others.get((int)i).realMax;
            }
            if (this.isNeedStdDev) {
                this.secMoment = sum1 / this.weightNCases + sum2 / this.weightNCases - this.overallMean * this.overallMean;
            }
        }
        this.nMerged += nAdded;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nBins);
        dataOutput.writeDouble(this.binLength);
        ACSerializationUtils.writeDoubleArray((double[])this.meansArray, (DataOutput)dataOutput);
        ACSerializationUtils.writeDoubleArray((double[])this.nCasesArray, (DataOutput)dataOutput);
        ACSerializationUtils.writeDoubleArray((double[])this.weightArray, (DataOutput)dataOutput);
        dataOutput.writeDouble(this.minValue);
        dataOutput.writeDouble(this.maxValue);
        dataOutput.writeDouble(this.realMin);
        dataOutput.writeDouble(this.realMax);
        dataOutput.writeBoolean(this.isNeedStdDev);
        dataOutput.writeBoolean(this.bConst);
        dataOutput.writeDouble(this.weightNCases);
        dataOutput.writeDouble(this.fTotalFreqWeightNCases);
        dataOutput.writeDouble(this.unweightedNCases);
        dataOutput.writeDouble(this.overallMean);
        dataOutput.writeDouble(this.secMoment);
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nBins = dataInput.readInt();
        this.binLength = dataInput.readDouble();
        this.meansArray = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.nCasesArray = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.weightArray = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.minValue = dataInput.readDouble();
        this.maxValue = dataInput.readDouble();
        this.realMin = dataInput.readDouble();
        this.realMax = dataInput.readDouble();
        this.isNeedStdDev = dataInput.readBoolean();
        this.bConst = dataInput.readBoolean();
        this.weightNCases = dataInput.readDouble();
        this.fTotalFreqWeightNCases = dataInput.readDouble();
        this.unweightedNCases = dataInput.readDouble();
        this.overallMean = dataInput.readDouble();
        this.secMoment = dataInput.readDouble();
        return this;
    }

    public HistogramData clone() {
        try {
            HistogramData result = (HistogramData)super.clone();
            result.meansArray = this.meansArray != null ? (double[])this.meansArray.clone() : null;
            result.nCasesArray = this.nCasesArray != null ? (double[])this.nCasesArray.clone() : null;
            result.weightArray = this.weightArray != null ? (double[])this.weightArray.clone() : null;
            result.variateData = this.variateData != null ? this.variateData.clone() : null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }

    public int getNMerged() {
        return this.nMerged;
    }

    public void merge(HistogramData result) {
        if (this.unweightedNCases == 0.0) {
            HistogramData firstHist = result;
            this.nBins = firstHist.nBins;
            this.binLength = firstHist.binLength;
            this.meansArray = firstHist.meansArray;
            this.nCasesArray = (double[])firstHist.nCasesArray.clone();
            this.weightArray = (double[])firstHist.weightArray.clone();
            this.minValue = firstHist.minValue;
            this.maxValue = firstHist.maxValue;
            this.realMin = firstHist.realMin;
            this.realMax = firstHist.realMax;
            this.isNeedStdDev = firstHist.isNeedStdDev;
            this.bConst = firstHist.bConst;
            this.weightNCases = firstHist.weightNCases;
            this.fTotalFreqWeightNCases = firstHist.fTotalFreqWeightNCases;
            this.unweightedNCases = firstHist.unweightedNCases;
            this.overallMean = firstHist.overallMean;
            this.secMoment = firstHist.secMoment;
        } else {
            int j;
            double totalNCases = this.unweightedNCases;
            double totalFreqWeight = this.fTotalFreqWeightNCases;
            double[] vWeight = (double[])this.weightArray.clone();
            double sum1 = 0.0;
            double sum2 = 0.0;
            if (this.isNeedStdDev) {
                sum1 += this.weightNCases * this.secMoment;
                sum2 += this.weightNCases * this.overallMean * this.overallMean;
            }
            if (result.unweightedNCases > 0.0) {
                if (result.nBins == this.nBins && Double.compare(result.minValue, this.minValue) == 0 && Double.compare(result.binLength, this.binLength) == 0 && result.isNeedStdDev == this.isNeedStdDev) {
                    totalNCases += result.unweightedNCases;
                    totalFreqWeight += result.fTotalFreqWeightNCases;
                    for (j = 0; j < this.nCasesArray.length; ++j) {
                        int n = j;
                        this.nCasesArray[n] = this.nCasesArray[n] + result.nCasesArray[j];
                        int n2 = j;
                        this.weightArray[n2] = this.weightArray[n2] + result.weightArray[j];
                    }
                } else {
                    throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
                }
            }
            if (totalNCases > 0.0) {
                double coeff;
                this.unweightedNCases = totalNCases;
                this.fTotalFreqWeightNCases = totalFreqWeight;
                for (j = 0; j < this.weightArray.length; ++j) {
                    if (!(this.weightArray[j] > 0.0)) continue;
                    coeff = vWeight[j] / this.weightArray[j];
                    int n = j;
                    this.meansArray[n] = this.meansArray[n] * coeff;
                }
                if (result.unweightedNCases > 0.0) {
                    for (j = 0; j < this.weightArray.length; ++j) {
                        if (!(result.weightArray[j] > 0.0)) continue;
                        coeff = result.weightArray[j] / this.weightArray[j];
                        int n = j;
                        this.meansArray[n] = this.meansArray[n] + coeff * result.meansArray[j];
                    }
                }
                this.weightNCases += result.weightNCases;
                double oldMean = this.overallMean;
                double varValue = result.overallMean;
                double nu = result.weightNCases / this.weightNCases * (varValue - this.overallMean);
                double newMean = oldMean + nu;
                if (Math.abs(newMean) < 2.0 * Math.abs(oldMean) * 2.220446049250313E-16) {
                    newMean = 0.0;
                }
                this.overallMean = newMean;
                if (this.isNeedStdDev) {
                    sum1 += result.weightNCases * result.secMoment;
                    sum2 += result.weightNCases * result.overallMean * result.overallMean;
                }
                if (this.realMin > result.realMin) {
                    this.realMin = result.realMin;
                }
                if (this.realMax < result.realMax) {
                    this.realMax = result.realMax;
                }
                if (this.isNeedStdDev) {
                    this.secMoment = sum1 / this.weightNCases + sum2 / this.weightNCases - this.overallMean * this.overallMean;
                }
            }
        }
        ++this.nMerged;
    }

    public String toString() {
        return "HistogramData [bConst=" + this.bConst + ", binLength=" + this.binLength + ", fTotalFreqWeightNCases=" + this.fTotalFreqWeightNCases + ", isNeedStdDev=" + this.isNeedStdDev + ", maxValue=" + this.maxValue + ", meansArray=" + Arrays.toString(this.meansArray) + ", minValue=" + this.minValue + ", nBins=" + this.nBins + ", nCasesArray=" + Arrays.toString(this.nCasesArray) + ", nMerged=" + this.nMerged + ", overallMean=" + this.overallMean + ", realMax=" + this.realMax + ", realMin=" + this.realMin + ", secMoment=" + this.secMoment + ", unweightedNCases=" + this.unweightedNCases + ", variateData=" + this.variateData + ", weightArray=" + Arrays.toString(this.weightArray) + ", weightNCases=" + this.weightNCases + "]";
    }
}

