/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.acmath.output.HistogramData;
import com.spss.ac.acxml.variatedata.VariateData;
import com.spss.ac.acxml.variatedata.XMLCoordinates;
import com.spss.ac.acxml.variatedata.XMLCounts;
import com.spss.math.MissingValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HistogramData4Outliers
extends HistogramData {
    private static final long serialVersionUID = -1928007090080497766L;
    protected double[] binsCutPoints = null;
    protected HashMap<Double, Double> leftOutlierMeansCounts = new HashMap();
    protected HashMap<Double, Double> rightOutlierMeansCounts = new HashMap();

    public HistogramData4Outliers() {
        this.binsCutPoints = new double[1];
    }

    public HistogramData4Outliers(int nBins, double minVal, double maxVal, boolean bNeedStdDev) {
        super(nBins, minVal, maxVal, bNeedStdDev);
        this.binsCutPoints = new double[nBins];
        for (int i = 0; i < nBins; ++i) {
            this.binsCutPoints[i] = minVal + (double)(i + 1) * this.binLength;
        }
    }

    public double[] getBinsCutPoints() {
        return this.binsCutPoints;
    }

    public double[] getNCasesArray() {
        return this.nCasesArray;
    }

    public double[] getMeansArray() {
        return this.meansArray;
    }

    public HashMap<Double, Double> getLeftOutlierMeansCounts() {
        return this.leftOutlierMeansCounts;
    }

    public HashMap<Double, Double> getRightOutlierMeansCounts() {
        return this.rightOutlierMeansCounts;
    }

    @Override
    public boolean updateData(double freqWeight, double regrWeight, double varValue) {
        int binIndex = 0;
        boolean leftOutlier = false;
        boolean rightOutlier = false;
        if (this.nBins > 1) {
            binIndex = (int)((varValue - this.minValue) / this.binLength);
            if (binIndex < 0) {
                leftOutlier = true;
            } else if (binIndex >= this.nBins) {
                rightOutlier = true;
            }
        }
        double recWeight = freqWeight * regrWeight;
        double oldSumOfW = this.weightNCases;
        this.weightNCases += recWeight;
        double oldMean = this.overallMean;
        double nu = recWeight / this.weightNCases * (varValue - this.overallMean);
        double newMean = oldMean + nu;
        if (Math.abs(newMean) < 2.0 * Math.abs(oldMean) * 2.220446049250313E-16) {
            newMean = 0.0;
        }
        this.overallMean = newMean;
        this.unweightedNCases += 1.0;
        this.fTotalFreqWeightNCases += freqWeight;
        if (this.isNeedStdDev) {
            this.secMoment = oldSumOfW / this.weightNCases * this.secMoment + oldSumOfW / recWeight * nu * nu;
        }
        if (!leftOutlier && !rightOutlier) {
            if (MissingValue.isMissing((double)this.meansArray[binIndex])) {
                this.meansArray[binIndex] = 0.0;
            }
            int n = binIndex;
            this.weightArray[n] = this.weightArray[n] + recWeight;
            int n2 = binIndex;
            this.nCasesArray[n2] = this.nCasesArray[n2] + freqWeight;
            double binRatio = recWeight / this.weightArray[binIndex];
            double incr = (varValue - this.meansArray[binIndex]) * binRatio;
            int n3 = binIndex;
            this.meansArray[n3] = this.meansArray[n3] + incr;
        } else if (leftOutlier) {
            this.updateHashMap(varValue, freqWeight, this.leftOutlierMeansCounts);
        } else {
            this.updateHashMap(varValue, freqWeight, this.rightOutlierMeansCounts);
        }
        if (this.realMin > varValue) {
            this.realMin = varValue;
        }
        if (this.realMax < varValue) {
            this.realMax = varValue;
        }
        return leftOutlier || rightOutlier;
    }

    protected void updateHashMap(double key, double value, Map<Double, Double> targetMap) {
        if (targetMap.containsKey(key)) {
            value += targetMap.get(key).doubleValue();
        }
        targetMap.put(key, value);
    }

    protected HashMap<Double, Double> cloneHashMap(Map<Double, Double> sourceMap) {
        HashMap<Double, Double> targetMap = new HashMap<Double, Double>();
        for (Map.Entry<Double, Double> entry : sourceMap.entrySet()) {
            targetMap.put(entry.getKey(), entry.getValue());
        }
        return targetMap;
    }

    protected void mergeHashMap(HashMap<Double, Double> sourceMap, HashMap<Double, Double> targetMap) {
        for (Map.Entry<Double, Double> entry : sourceMap.entrySet()) {
            this.updateHashMap(entry.getKey(), entry.getValue(), targetMap);
        }
    }

    @Override
    public void merge(HistogramData result) {
        super.merge(result);
        HistogramData4Outliers other = (HistogramData4Outliers)result;
        if (this.unweightedNCases == 0.0) {
            this.leftOutlierMeansCounts = this.cloneHashMap(other.leftOutlierMeansCounts);
            this.rightOutlierMeansCounts = this.cloneHashMap(other.rightOutlierMeansCounts);
        } else {
            this.mergeHashMap(other.leftOutlierMeansCounts, this.leftOutlierMeansCounts);
            this.mergeHashMap(other.rightOutlierMeansCounts, this.rightOutlierMeansCounts);
        }
    }

    protected void appendOutlierMeansCounts(HashMap<Double, Double> outlierMeansCounts, ArrayList<Double> means, ArrayList<Double> counts) {
        if (outlierMeansCounts.size() > 0) {
            for (Map.Entry<Double, Double> entry : outlierMeansCounts.entrySet()) {
                Double mean = entry.getKey();
                Double count = entry.getValue();
                if (!(count > 0.0)) continue;
                means.add(mean);
                counts.add(count);
            }
        }
    }

    @Override
    public VariateData generateVariateData(String varName) {
        this.variateData = new VariateData();
        this.variateData.setStrDescr("Histogram");
        XMLCounts counts = new XMLCounts();
        counts.setTotalFreq(this.fTotalFreqWeightNCases);
        this.variateData.setCounts(counts);
        ArrayList<XMLCoordinates> coordinates = new ArrayList<XMLCoordinates>();
        coordinates.add(new XMLCoordinates());
        coordinates.add(new XMLCoordinates());
        this.variateData.setCoordinates(coordinates);
        if (varName.length() > 0) {
            ((XMLCoordinates)coordinates.get(0)).setFeature("observed");
            ((XMLCoordinates)coordinates.get(0)).setField(varName);
        }
        ((XMLCoordinates)coordinates.get(1)).setFeature("frequency");
        ((XMLCoordinates)coordinates.get(0)).setType(1);
        ((XMLCoordinates)coordinates.get(1)).setType(1);
        ArrayList<Double> means = new ArrayList<Double>();
        ((XMLCoordinates)coordinates.get(0)).setDoubleVals(means);
        ArrayList<Double> nCases = new ArrayList<Double>();
        ((XMLCoordinates)coordinates.get(1)).setDoubleVals(nCases);
        this.appendOutlierMeansCounts(this.leftOutlierMeansCounts, means, nCases);
        if (this.nCasesArray != null && this.meansArray != null) {
            for (int i = 0; i < this.nCasesArray.length; ++i) {
                if (!(this.nCasesArray[i] > 0.0)) continue;
                means.add(this.meansArray[i]);
                nCases.add(this.nCasesArray[i]);
            }
        }
        this.appendOutlierMeansCounts(this.rightOutlierMeansCounts, means, nCases);
        this.variateData.addNumStat("min", this.realMin);
        this.variateData.addNumStat("max", this.realMax);
        this.variateData.addNumStat("mean", this.overallMean);
        if (this.isNeedStdDev) {
            double stddev = 0.0;
            if (this.weightNCases > 1.0) {
                double variance = this.secMoment * this.weightNCases / (this.weightNCases - 1.0);
                stddev = Math.sqrt(variance);
            }
            this.variateData.addNumStat("stdDeviation", stddev);
        }
        return this.variateData;
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.binsCutPoints = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.leftOutlierMeansCounts = ACSerializationUtils.readHashMapByDouble2Double((DataInput)dataInput);
        this.rightOutlierMeansCounts = ACSerializationUtils.readHashMapByDouble2Double((DataInput)dataInput);
        return this;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        ACSerializationUtils.writeDoubleArray((double[])this.binsCutPoints, (DataOutput)dataOutput);
        ACSerializationUtils.writeHashMapByDouble2Double(this.leftOutlierMeansCounts, (DataOutput)dataOutput);
        ACSerializationUtils.writeHashMapByDouble2Double(this.rightOutlierMeansCounts, (DataOutput)dataOutput);
    }

    @Override
    public HistogramData4Outliers clone() {
        HistogramData4Outliers result = (HistogramData4Outliers)super.clone();
        result.binsCutPoints = this.binsCutPoints != null ? (double[])this.binsCutPoints.clone() : null;
        result.leftOutlierMeansCounts = this.cloneHashMap(this.leftOutlierMeansCounts);
        result.rightOutlierMeansCounts = this.cloneHashMap(this.rightOutlierMeansCounts);
        return result;
    }

    @Override
    public String toString() {
        return "HistogramData4Outliers [binsCutPoints=" + Arrays.toString(this.binsCutPoints) + ", leftOutlierMeansCounts=" + this.leftOutlierMeansCounts + ", rightOutlierMeansCounts=" + this.rightOutlierMeansCounts + "]";
    }
}

