/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.ac.acxml.variatedata.VariateData;
import com.spss.ac.acxml.variatedata.XMLCoordinates;
import com.spss.ac.acxml.variatedata.XMLCounts;
import com.spss.math.MissingValue;
import com.spss.math.statistics.DistributionFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PPPlotData {
    private List<Double> noZeroBinMeans = new ArrayList<Double>();
    private List<Double> noZeroBinCounts = new ArrayList<Double>();
    private List<Double> noZeroBinCutPoints = new ArrayList<Double>();
    private double freqWNCases = MissingValue.getMissing();
    private VariateData bivariateDataOfXML = null;
    private double rmse;

    public PPPlotData(double[] meansArray, double[] nCasesArray, double[] binCutPoints, double totalFreqWeightNCases, HashMap<Double, Double> leftOutlierMeansCounts, HashMap<Double, Double> rightOutlierMeansCounts, double rmse) {
        this.freqWNCases = totalFreqWeightNCases;
        this.rmse = rmse;
        this.fillNoZeroInfo(leftOutlierMeansCounts);
        if (meansArray.length == nCasesArray.length && meansArray.length == binCutPoints.length) {
            for (int i = 0; i < binCutPoints.length; ++i) {
                if (!(nCasesArray[i] > 0.0)) continue;
                this.noZeroBinMeans.add(meansArray[i]);
                this.noZeroBinCounts.add(nCasesArray[i]);
                this.noZeroBinCutPoints.add(binCutPoints[i]);
            }
        }
        this.fillNoZeroInfo(rightOutlierMeansCounts);
    }

    protected void fillNoZeroInfo(HashMap<Double, Double> outlierMeansCounts) {
        if (!outlierMeansCounts.isEmpty()) {
            for (Map.Entry<Double, Double> entry : outlierMeansCounts.entrySet()) {
                Double key = entry.getKey();
                Double value = entry.getValue();
                this.noZeroBinMeans.add(key);
                this.noZeroBinCounts.add(value);
                this.noZeroBinCutPoints.add(key);
            }
        }
    }

    public List<Double> getQuantiles() {
        return this.noZeroBinCutPoints;
    }

    public ArrayList<Double> computeCumPers() {
        int noZeroCount = this.noZeroBinCounts.size();
        ArrayList<Double> cumPers = new ArrayList<Double>(noZeroCount);
        double tempCounts = 0.0;
        for (int i = 0; i < noZeroCount; ++i) {
            cumPers.add((tempCounts += this.noZeroBinCounts.get(i).doubleValue()) / this.freqWNCases);
        }
        return cumPers;
    }

    public ArrayList<Double> computeCumProbs() {
        int noZeroCount = this.noZeroBinCutPoints.size();
        ArrayList<Double> cumProbs = new ArrayList<Double>(noZeroCount);
        for (int i = 0; i < noZeroCount; ++i) {
            cumProbs.add(DistributionFunctions.cdfStdNorm((double)(this.noZeroBinCutPoints.get(i) / this.rmse)));
        }
        return cumProbs;
    }

    protected VariateData constructVarData(double totalFreqWNCases) {
        VariateData varData = new VariateData();
        varData.setCounts(new XMLCounts());
        varData.getCounts().setTotalFreq(totalFreqWNCases);
        ArrayList<XMLCoordinates> coordinates = new ArrayList<XMLCoordinates>(2);
        coordinates.add(new XMLCoordinates());
        coordinates.add(new XMLCoordinates());
        varData.setCoordinates(coordinates);
        ((XMLCoordinates)varData.getCoordinates().get(0)).setFeature("statistic");
        ((XMLCoordinates)varData.getCoordinates().get(1)).setFeature("statistic");
        return varData;
    }

    public VariateData getVariateData(String description, String statsCutPoints, String statsIDFNormals) {
        if (this.bivariateDataOfXML == null) {
            this.bivariateDataOfXML = this.constructVarData(this.freqWNCases);
        }
        this.bivariateDataOfXML.setStrDescr(description);
        ((XMLCoordinates)this.bivariateDataOfXML.getCoordinates().get(0)).setStatistic(statsCutPoints);
        ((XMLCoordinates)this.bivariateDataOfXML.getCoordinates().get(0)).setType(1);
        ((XMLCoordinates)this.bivariateDataOfXML.getCoordinates().get(0)).setDoubleVals(this.computeCumPers());
        ((XMLCoordinates)this.bivariateDataOfXML.getCoordinates().get(1)).setStatistic(statsIDFNormals);
        ((XMLCoordinates)this.bivariateDataOfXML.getCoordinates().get(1)).setType(1);
        ((XMLCoordinates)this.bivariateDataOfXML.getCoordinates().get(1)).setDoubleVals(this.computeCumProbs());
        return this.bivariateDataOfXML;
    }
}

