/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acmapreduce.Mergeable;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.statistics.CCBitSet;
import com.spss.math.statistics.Power;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ROCCurve
implements Mergeable<ROCCurve>,
ACSerializable {
    private int nMerged = 1;
    private static final long serialVersionUID = 7760366939902165844L;
    private DenseRectMatrix rocCurve = null;
    private double tolence = 1.0E-13;
    private double totalFreq = 0.0;
    protected int interval = 401;
    protected double intervalWidth = 0.0;
    protected DenseRectMatrix criticalProb = null;
    private DenseRectMatrix liftCurve = null;
    private DenseRectMatrix gainsCurve = null;

    public ROCCurve() {
    }

    public ROCCurve(DenseRectMatrix matrix) {
        if (matrix != null) {
            this.interval = matrix.getNCols() - 1;
            this.criticalProb = matrix;
            this.intervalWidth = 1.0 / (double)(this.criticalProb.getNCols() - 1);
        }
    }

    public boolean compute() {
        int i;
        if (this.criticalProb == null || this.criticalProb.getNCols() == 0 || this.criticalProb.getNRows() != 2) {
            return false;
        }
        long cat0Freq = 0L;
        long cat1Freq = 0L;
        double[] cat0Prob = this.criticalProb.getRow(0);
        double[] cat1Prob = this.criticalProb.getRow(1);
        for (int i2 = 0; i2 < cat0Prob.length; ++i2) {
            cat0Freq = (long)((double)cat0Freq + cat0Prob[i2]);
            cat1Freq = (long)((double)cat1Freq + cat1Prob[i2]);
        }
        this.totalFreq = cat0Freq + cat1Freq;
        long cat0False = 0L;
        long cat1False = 0L;
        double rho1 = 0.0;
        double rho2 = 0.0;
        double phi0 = 0.0;
        if (this.rocCurve == null) {
            this.rocCurve = new DenseRectMatrix(3, this.criticalProb.getNCols());
        }
        if (this.liftCurve == null) {
            this.liftCurve = new DenseRectMatrix(3, this.criticalProb.getNCols());
        }
        if (this.gainsCurve == null) {
            this.gainsCurve = new DenseRectMatrix(3, this.criticalProb.getNCols());
        }
        for (int i3 = 0; i3 < cat0Prob.length; ++i3) {
            long tp = cat1Freq - cat1False;
            long fn = cat1False;
            long fp = cat0Freq - cat0False;
            long tn = cat0False;
            rho1 = (double)tp / (double)(tp + fn);
            rho2 = (double)tn / (double)(fp + tn);
            phi0 = 1.0 - rho2;
            this.rocCurve.setElem(0, i3, rho1);
            this.rocCurve.setElem(1, i3, phi0);
            this.rocCurve.setElem(2, i3, this.intervalWidth * (double)i3);
            cat0False += (long)cat0Prob[i3];
            cat1False += (long)cat1Prob[i3];
            double lift = 0.0;
            double gain = 0.0;
            if (fp + tp == 0L) {
                gain = 1.0;
                lift = i3 == 0 ? 1.0 : this.liftCurve.getElem(0, i3 - 1);
            } else {
                gain = (double)tp / (double)(fp + tp);
                lift = (double)tp / (double)(fp + tp) / ((double)(fn + tp) / (double)(tn + fp + fn + tp));
            }
            double depth = (double)(fp + tp) / (double)(tn + fp + fn + tp);
            this.liftCurve.setElem(0, i3, lift);
            this.liftCurve.setElem(1, i3, depth);
            this.liftCurve.setElem(2, i3, this.intervalWidth * (double)i3);
            this.gainsCurve.setElem(0, i3, gain);
            this.gainsCurve.setElem(1, i3, depth);
            this.gainsCurve.setElem(2, i3, this.intervalWidth * (double)i3);
        }
        DenseRectMatrix tempCurve = this.rocCurve;
        CCBitSet redun = new CCBitSet(tempCurve.getNCols());
        int len = this.getDuplicate(tempCurve, redun);
        this.rocCurve = new DenseRectMatrix(3, len);
        int pos = 0;
        for (i = 0; i < redun.size(); ++i) {
            if (!redun.get(i)) continue;
            this.rocCurve.setElem(0, pos, tempCurve.getElem(0, i));
            this.rocCurve.setElem(1, pos, tempCurve.getElem(1, i));
            this.rocCurve.setElem(2, pos, tempCurve.getElem(2, i));
            ++pos;
        }
        redun.clear();
        tempCurve = this.liftCurve;
        len = this.getDuplicate(tempCurve, redun);
        this.liftCurve = new DenseRectMatrix(3, len);
        pos = 0;
        for (i = 0; i < redun.size(); ++i) {
            if (!redun.get(i)) continue;
            this.liftCurve.setElem(0, pos, tempCurve.getElem(0, i));
            this.liftCurve.setElem(1, pos, tempCurve.getElem(1, i));
            this.liftCurve.setElem(2, pos, tempCurve.getElem(2, i));
            ++pos;
        }
        redun.clear();
        tempCurve = this.gainsCurve;
        len = this.getDuplicate(tempCurve, redun);
        this.gainsCurve = new DenseRectMatrix(3, len);
        pos = 0;
        for (i = 0; i < redun.size(); ++i) {
            if (!redun.get(i)) continue;
            this.gainsCurve.setElem(0, pos, tempCurve.getElem(0, i));
            this.gainsCurve.setElem(1, pos, tempCurve.getElem(1, i));
            this.gainsCurve.setElem(2, pos, tempCurve.getElem(2, i));
            ++pos;
        }
        return true;
    }

    private int getDuplicate(DenseRectMatrix matrix, CCBitSet redun) {
        double rho1 = 0.0;
        double phi0 = 0.0;
        int lenth = 0;
        for (int i = 0; i < matrix.getNCols(); ++i) {
            if (i == 0) {
                rho1 = matrix.getElem(0, i);
                phi0 = matrix.getElem(1, i);
                redun.set(i, true);
                ++lenth;
                continue;
            }
            double rhoi1 = matrix.getElem(0, i);
            double phii0 = matrix.getElem(1, i);
            if (Power.almostEqual((double)rhoi1, (double)rho1, (double)this.tolence) && Power.almostEqual((double)phii0, (double)phi0, (double)this.tolence)) {
                redun.set(i, false);
            } else {
                redun.set(i, true);
                ++lenth;
            }
            rho1 = rhoi1;
            phi0 = phii0;
        }
        return lenth;
    }

    public DenseRectMatrix getRocCurveResult() {
        return this.rocCurve;
    }

    public double getTotalFreq() {
        return this.totalFreq;
    }

    public DenseRectMatrix getLiftChart() {
        return this.liftCurve;
    }

    public DenseRectMatrix getGainChart() {
        return this.gainsCurve;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.interval);
        dataOutput.writeDouble(this.intervalWidth);
        dataOutput.writeBoolean(this.criticalProb == null);
        if (this.criticalProb != null) {
            this.criticalProb.writeObject(dataOutput);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.interval = dataInput.readInt();
        this.intervalWidth = dataInput.readDouble();
        boolean probCountsNull = dataInput.readBoolean();
        this.criticalProb = new DenseRectMatrix(2, this.interval);
        if (!probCountsNull) {
            this.criticalProb.readObject(dataInput);
        }
        return this;
    }

    public void merge(ROCCurve result) {
        if (this.criticalProb == null) {
            this.criticalProb = new DenseRectMatrix(result.getProbCountsResult().getNRows(), result.getProbCountsResult().getNCols());
        }
        double[] matrix = this.criticalProb.getMatrix();
        double[] addMatrix = result.getProbCountsResult().getMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            int n = i;
            matrix[n] = matrix[n] + addMatrix[i];
        }
    }

    public int getNMerged() {
        return this.nMerged;
    }

    public DenseRectMatrix getProbCountsResult() {
        return this.criticalProb;
    }
}

