/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.ac.acbase.collections.ACUtils;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.acbase.tuple.Tuple3;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.ac.acmapreduce.ListMergeable;
import com.spss.ac.acmapreduce.Mergeable;
import com.spss.ac.acxml.variatedata.VariateData;
import com.spss.ac.acxml.variatedata.XMLCoordinates;
import com.spss.ac.acxml.variatedata.XMLCounts;
import com.spss.utilities.i18n.LocMsgId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScatterPlotData
implements ACSerializable,
ListMergeable<ScatterPlotData>,
Mergeable<ScatterPlotData> {
    private static final long serialVersionUID = -7604346718948246268L;
    protected int nBinsX;
    protected int nBinsY;
    protected double stepLenX;
    protected double stepLenY;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean ifNeed2Bin;
    protected double[][] vvXMeans = null;
    protected double[][] vvYMeans = null;
    protected double[][] vvNCases = null;
    protected double[][] vvWeight = null;
    protected double weight;
    protected double totalFreqWeight;
    protected double nCases;
    protected VariateData variateData = null;
    protected int nMerged;

    public ScatterPlotData() {
        this.nBinsX = 1;
        this.nBinsY = 1;
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = 1.0;
        this.maxY = 1.0;
        this.nCases = 0.0;
        this.weight = 0.0;
        this.totalFreqWeight = 0.0;
        this.ifNeed2Bin = false;
        this.stepLenX = 2.0;
        this.stepLenY = 2.0;
        this.prepareVariateDataResult();
    }

    public ScatterPlotData(int nBinX, int nBinY, double minValX, double minValY, double maxValX, double maxValY, boolean bNeed2Bin) {
        this.nBinsX = nBinX;
        this.nBinsY = nBinY;
        this.minX = minValX;
        this.minY = minValY;
        this.maxX = maxValX;
        this.maxY = maxValY;
        this.nCases = 0.0;
        this.weight = 0.0;
        this.totalFreqWeight = 0.0;
        this.ifNeed2Bin = bNeed2Bin;
        if (this.ifNeed2Bin) {
            if (nBinX > 1 && minValX < maxValX) {
                this.stepLenX = (maxValX - minValX) / (double)nBinX;
            } else {
                this.nBinsX = 1;
            }
            if (nBinY > 1 && minValY < maxValY) {
                this.stepLenY = (maxValY - minValY) / (double)nBinY;
            } else {
                this.nBinsY = 1;
            }
            this.vvXMeans = new double[this.nBinsX][this.nBinsY];
            this.vvYMeans = new double[this.nBinsX][this.nBinsY];
            this.vvNCases = new double[this.nBinsX][this.nBinsY];
            this.vvWeight = new double[this.nBinsX][this.nBinsY];
            for (int i = 0; i < this.nBinsX; ++i) {
                this.vvXMeans[i] = new double[this.nBinsY];
                this.vvYMeans[i] = new double[this.nBinsY];
                this.vvNCases[i] = new double[this.nBinsY];
                this.vvWeight[i] = new double[this.nBinsY];
            }
        }
        this.prepareVariateDataResult();
    }

    public void updateData(double freqWeight, double regrWeight, double x, double y) {
        if (!this.ifNeed2Bin) {
            double totalFreq = this.variateData.getCounts().getTotalFreq();
            this.variateData.getCounts().setTotalFreq(totalFreq += freqWeight);
            ((XMLCoordinates)this.variateData.getCoordinates().get(0)).getDoubleVals().add(x);
            ((XMLCoordinates)this.variateData.getCoordinates().get(1)).getDoubleVals().add(y);
            ((XMLCoordinates)this.variateData.getCoordinates().get(2)).getDoubleVals().add(freqWeight);
        } else {
            int binX = 0;
            int binY = 0;
            if (this.nBinsX > 1) {
                binX = (int)((x - this.minX) / this.stepLenX);
                if (binX < 0) {
                    binX = 0;
                } else if (binX >= this.nBinsX) {
                    binX = this.nBinsX - 1;
                }
            }
            if (this.nBinsY > 1) {
                binY = (int)((y - this.minY) / this.stepLenY);
                if (binY < 0) {
                    binY = 0;
                } else if (binY >= this.nBinsY) {
                    binY = this.nBinsY - 1;
                }
            }
            double weight = freqWeight * regrWeight;
            this.nCases += 1.0;
            this.weight += weight;
            this.totalFreqWeight += freqWeight;
            double[] dArray = this.vvWeight[binX];
            int n = binY;
            dArray[n] = dArray[n] + weight;
            double[] dArray2 = this.vvNCases[binX];
            int n2 = binY;
            dArray2[n2] = dArray2[n2] + freqWeight;
            double binRatio = weight / this.vvWeight[binX][binY];
            double incr = (x - this.vvXMeans[binX][binY]) * binRatio;
            double[] dArray3 = this.vvXMeans[binX];
            int n3 = binY;
            dArray3[n3] = dArray3[n3] + incr;
            incr = (y - this.vvYMeans[binX][binY]) * binRatio;
            double[] dArray4 = this.vvYMeans[binX];
            int n4 = binY;
            dArray4[n4] = dArray4[n4] + incr;
        }
    }

    public VariateData getVariateData(String varXName, String varXFeature, String varXStat, String varYName, String varYFeature, String varYStat) {
        ((XMLCoordinates)this.variateData.getCoordinates().get(0)).setFeature(varXFeature);
        ((XMLCoordinates)this.variateData.getCoordinates().get(0)).setField(varXName);
        ((XMLCoordinates)this.variateData.getCoordinates().get(0)).setStatistic(varXStat);
        ((XMLCoordinates)this.variateData.getCoordinates().get(1)).setFeature(varYFeature);
        ((XMLCoordinates)this.variateData.getCoordinates().get(1)).setField(varYName);
        ((XMLCoordinates)this.variateData.getCoordinates().get(1)).setStatistic(varYStat);
        if (this.ifNeed2Bin && this.variateData.getCounts().getTotalFreq() == 0.0) {
            this.variateData.getCounts().setTotalFreq(this.totalFreqWeight);
            for (int i = 0; i < this.nBinsX; ++i) {
                for (int j = 0; j < this.nBinsY; ++j) {
                    if (!(this.vvNCases[i][j] > 0.0)) continue;
                    ((XMLCoordinates)this.variateData.getCoordinates().get(0)).getDoubleVals().add(this.vvXMeans[i][j]);
                    ((XMLCoordinates)this.variateData.getCoordinates().get(1)).getDoubleVals().add(this.vvYMeans[i][j]);
                    ((XMLCoordinates)this.variateData.getCoordinates().get(2)).getDoubleVals().add(this.vvNCases[i][j]);
                }
            }
        }
        return this.variateData;
    }

    public double getTotalWeight() {
        return this.totalFreqWeight;
    }

    public double[][] readTwoDimensionalDoubleArray(DataInput dataInput) throws IOException {
        double[][] dTwoDimArr = null;
        if (ACSerializationUtils.readObjectExistFlag((String)"dTwoDimArr", (DataInput)dataInput)) {
            int Rows = dataInput.readInt();
            int Columns = dataInput.readInt();
            dTwoDimArr = new double[Rows][Columns];
            for (int i = 0; i < Rows; ++i) {
                dTwoDimArr[i] = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
            }
        }
        return dTwoDimArr;
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nBinsX = dataInput.readInt();
        this.nBinsY = dataInput.readInt();
        this.stepLenX = dataInput.readDouble();
        this.stepLenY = dataInput.readDouble();
        this.minX = dataInput.readDouble();
        this.maxX = dataInput.readDouble();
        this.minY = dataInput.readDouble();
        this.maxY = dataInput.readDouble();
        this.ifNeed2Bin = dataInput.readBoolean();
        this.vvXMeans = this.readTwoDimensionalDoubleArray(dataInput);
        this.vvYMeans = this.readTwoDimensionalDoubleArray(dataInput);
        this.vvNCases = this.readTwoDimensionalDoubleArray(dataInput);
        this.vvWeight = this.readTwoDimensionalDoubleArray(dataInput);
        this.weight = dataInput.readDouble();
        this.totalFreqWeight = dataInput.readDouble();
        this.nCases = dataInput.readDouble();
        double dVal = dataInput.readDouble();
        this.variateData.getCounts().setTotalFreq(dVal);
        for (int i = 0; i < 3; ++i) {
            int len = dataInput.readInt();
            if (len > 0) {
                char[] charsFeature = new char[len];
                for (int j = 0; j < len; ++j) {
                    charsFeature[j] = dataInput.readChar();
                }
                String strFeature = new String(charsFeature);
                ((XMLCoordinates)this.variateData.getCoordinates().get(i)).setFeature(strFeature);
            }
            if ((len = dataInput.readInt()) > 0) {
                char[] charsField = new char[len];
                for (int j = 0; j < len; ++j) {
                    charsField[j] = dataInput.readChar();
                }
                String strField = new String(charsField);
                ((XMLCoordinates)this.variateData.getCoordinates().get(i)).setFeature(strField);
            }
            if ((len = dataInput.readInt()) > 0) {
                char[] charsStatistic = new char[len];
                for (int j = 0; j < len; ++j) {
                    charsStatistic[j] = dataInput.readChar();
                }
                String strStatistic = new String(charsStatistic);
                ((XMLCoordinates)this.variateData.getCoordinates().get(i)).setFeature(strStatistic);
            }
            int type = dataInput.readInt();
            ((XMLCoordinates)this.variateData.getCoordinates().get(i)).setType(type);
            if (!ACSerializationUtils.readObjectExistFlag((String)"dList", (DataInput)dataInput)) continue;
            int size = dataInput.readInt();
            for (int j = 0; j < size; ++j) {
                ((XMLCoordinates)this.variateData.getCoordinates().get(i)).getDoubleVals().add(dataInput.readDouble());
            }
        }
        return this;
    }

    public void writeTwoDimensionalDoubleArray(double[][] dTwoDimArr, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag((String)"dTwoDimArr", (dTwoDimArr != null ? 1 : 0) != 0, (DataOutput)dataOutput);
        if (dTwoDimArr != null) {
            int Rows = dTwoDimArr.length;
            dataOutput.writeInt(Rows);
            int Columns = dTwoDimArr[0].length;
            dataOutput.writeInt(Columns);
            for (int i = 0; i < Rows; ++i) {
                ACSerializationUtils.writeDoubleArray((double[])dTwoDimArr[i], (DataOutput)dataOutput);
            }
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nBinsX);
        dataOutput.writeInt(this.nBinsY);
        dataOutput.writeDouble(this.stepLenX);
        dataOutput.writeDouble(this.stepLenY);
        dataOutput.writeDouble(this.minX);
        dataOutput.writeDouble(this.maxX);
        dataOutput.writeDouble(this.minY);
        dataOutput.writeDouble(this.maxY);
        dataOutput.writeBoolean(this.ifNeed2Bin);
        this.writeTwoDimensionalDoubleArray(this.vvXMeans, dataOutput);
        this.writeTwoDimensionalDoubleArray(this.vvYMeans, dataOutput);
        this.writeTwoDimensionalDoubleArray(this.vvNCases, dataOutput);
        this.writeTwoDimensionalDoubleArray(this.vvWeight, dataOutput);
        dataOutput.writeDouble(this.weight);
        dataOutput.writeDouble(this.totalFreqWeight);
        dataOutput.writeDouble(this.nCases);
        dataOutput.writeDouble(this.variateData.getCounts().getTotalFreq());
        for (int i = 0; i < 3; ++i) {
            String strFeature = ((XMLCoordinates)this.variateData.getCoordinates().get(i)).getFeature();
            if (strFeature != null && !strFeature.isEmpty()) {
                char[] charsFeature = strFeature.toCharArray();
                dataOutput.writeInt(charsFeature.length);
                for (int j = 0; j < charsFeature.length; ++j) {
                    dataOutput.writeChar(charsFeature[j]);
                }
            } else {
                dataOutput.writeInt(0);
            }
            String strField = ((XMLCoordinates)this.variateData.getCoordinates().get(i)).getField();
            if (strField != null && !strField.isEmpty()) {
                char[] charsField = strField.toCharArray();
                dataOutput.writeInt(charsField.length);
                for (int j = 0; j < charsField.length; ++j) {
                    dataOutput.writeChar(charsField[j]);
                }
            } else {
                dataOutput.writeInt(0);
            }
            String strStatistic = ((XMLCoordinates)this.variateData.getCoordinates().get(i)).getStatistic();
            if (strStatistic != null && !strStatistic.isEmpty()) {
                char[] charsStatistic = strStatistic.toCharArray();
                dataOutput.writeInt(charsStatistic.length);
                for (int j = 0; j < charsStatistic.length; ++j) {
                    dataOutput.writeChar(charsStatistic[j]);
                }
            } else {
                dataOutput.writeInt(0);
            }
            dataOutput.writeInt(((XMLCoordinates)this.variateData.getCoordinates().get(i)).getType());
            ACSerializationUtils.writeDoubleList((List)((XMLCoordinates)this.variateData.getCoordinates().get(i)).getDoubleVals(), (DataOutput)dataOutput);
        }
    }

    private void prepareVariateDataResult() {
        this.variateData = new VariateData();
        this.variateData.setCounts(new XMLCounts());
        this.variateData.getCounts().setTotalFreq(0.0);
        ArrayList<XMLCoordinates> coordinates = new ArrayList<XMLCoordinates>(3);
        coordinates.add(new XMLCoordinates());
        ((XMLCoordinates)coordinates.get(0)).setDoubleVals(new ArrayList());
        coordinates.add(new XMLCoordinates());
        ((XMLCoordinates)coordinates.get(1)).setDoubleVals(new ArrayList());
        coordinates.add(new XMLCoordinates());
        ((XMLCoordinates)coordinates.get(2)).setDoubleVals(new ArrayList());
        this.variateData.setCoordinates(coordinates);
        ((XMLCoordinates)this.variateData.getCoordinates().get(2)).setFeature("frequency");
        ((XMLCoordinates)this.variateData.getCoordinates().get(0)).setType(1);
        ((XMLCoordinates)this.variateData.getCoordinates().get(1)).setType(1);
        ((XMLCoordinates)this.variateData.getCoordinates().get(2)).setType(1);
    }

    public int getNMerged() {
        return this.nMerged;
    }

    public void merge(List<ScatterPlotData> result) {
        int j;
        ScatterPlotData res;
        int k;
        int i;
        int first = 0;
        if (this.nCases == 0.0) {
            ScatterPlotData firstResult = result.get(0);
            this.nBinsX = firstResult.nBinsX;
            this.nBinsY = firstResult.nBinsY;
            this.stepLenX = firstResult.stepLenX;
            this.stepLenY = firstResult.stepLenY;
            this.minX = firstResult.minX;
            this.minY = firstResult.minY;
            this.maxX = firstResult.maxX;
            this.maxY = firstResult.maxY;
            this.ifNeed2Bin = firstResult.ifNeed2Bin;
            this.nCases = firstResult.nCases;
            this.weight = firstResult.weight;
            this.totalFreqWeight = firstResult.totalFreqWeight;
            this.vvNCases = new double[firstResult.nBinsX][];
            this.vvWeight = new double[firstResult.nBinsX][];
            this.vvXMeans = new double[firstResult.nBinsX][];
            this.vvYMeans = new double[firstResult.nBinsX][];
            for (i = 0; i < firstResult.nBinsX; ++i) {
                this.vvNCases[i] = new double[firstResult.nBinsY];
                System.arraycopy(firstResult.vvNCases[i], 0, this.vvNCases[i], 0, firstResult.nBinsX);
                this.vvWeight[i] = new double[firstResult.nBinsY];
                System.arraycopy(firstResult.vvWeight[i], 0, this.vvWeight[i], 0, firstResult.nBinsX);
                this.vvXMeans[i] = new double[firstResult.nBinsY];
                System.arraycopy(firstResult.vvXMeans[i], 0, this.vvXMeans[i], 0, firstResult.nBinsX);
                this.vvYMeans[i] = new double[firstResult.nBinsY];
                System.arraycopy(firstResult.vvYMeans[i], 0, this.vvYMeans[i], 0, firstResult.nBinsX);
            }
            first = 1;
        }
        boolean mergeError = false;
        for (k = first; k < result.size(); ++k) {
            res = result.get(k);
            if (this.ifNeed2Bin == res.ifNeed2Bin && this.nBinsX == res.nBinsX && this.nBinsY == res.nBinsY) {
                this.nCases += res.nCases;
                this.weight += res.weight;
                this.totalFreqWeight += res.totalFreqWeight;
                for (int i2 = 0; i2 < this.nBinsX; ++i2) {
                    for (j = 0; j < this.nBinsY; ++j) {
                        double[] dArray = this.vvNCases[i2];
                        int n = j;
                        dArray[n] = dArray[n] + res.vvNCases[i2][j];
                        double[] dArray2 = this.vvWeight[i2];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + res.vvWeight[i2][j];
                    }
                }
                continue;
            }
            mergeError = true;
            break;
        }
        if (mergeError) {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        if (this.nCases > 0.0) {
            for (i = 0; i < this.nBinsX; ++i) {
                for (int j2 = 0; j2 < this.nBinsY; ++j2) {
                    if (!(result.get((int)0).vvWeight[i][j2] > 0.0)) continue;
                    double coeff = result.get((int)0).vvWeight[i][j2] / this.vvWeight[i][j2];
                    double[] dArray = this.vvXMeans[i];
                    int n = j2;
                    dArray[n] = dArray[n] * coeff;
                    double[] dArray3 = this.vvYMeans[i];
                    int n3 = j2;
                    dArray3[n3] = dArray3[n3] * coeff;
                }
            }
            for (k = first; k < result.size(); ++k) {
                res = result.get(k);
                for (int i3 = 0; i3 < this.nBinsX; ++i3) {
                    for (j = 0; j < this.nBinsY; ++j) {
                        if (!(res.vvWeight[i3][j] > 0.0)) continue;
                        double coeff = res.vvWeight[i3][j] / this.vvWeight[i3][j];
                        double[] dArray = this.vvXMeans[i3];
                        int n = j;
                        dArray[n] = dArray[n] + coeff * res.vvXMeans[i3][j];
                        double[] dArray4 = this.vvYMeans[i3];
                        int n4 = j;
                        dArray4[n4] = dArray4[n4] + coeff * res.vvYMeans[i3][j];
                    }
                }
            }
        }
        this.nMerged += result.size();
    }

    public void merge(ScatterPlotData result) {
        if (this.nCases == 0.0) {
            ScatterPlotData firstResult = result;
            this.nBinsX = firstResult.nBinsX;
            this.nBinsY = firstResult.nBinsY;
            this.stepLenX = firstResult.stepLenX;
            this.stepLenY = firstResult.stepLenY;
            this.minX = firstResult.minX;
            this.minY = firstResult.minY;
            this.maxX = firstResult.maxX;
            this.maxY = firstResult.maxY;
            this.ifNeed2Bin = firstResult.ifNeed2Bin;
            this.nCases = firstResult.nCases;
            this.weight = firstResult.weight;
            this.totalFreqWeight = firstResult.totalFreqWeight;
            if (firstResult.vvNCases != null) {
                this.vvNCases = ACUtils.clone((double[][])firstResult.vvNCases);
            }
            if (firstResult.vvWeight != null) {
                this.vvWeight = ACUtils.clone((double[][])firstResult.vvWeight);
            }
            if (firstResult.vvXMeans != null) {
                this.vvXMeans = ACUtils.clone((double[][])firstResult.vvXMeans);
            }
            if (firstResult.vvYMeans != null) {
                this.vvYMeans = ACUtils.clone((double[][])firstResult.vvYMeans);
            }
        } else {
            double coeff;
            int j;
            int i;
            double[][] copyOfWeight = ACUtils.clone((double[][])this.vvWeight);
            ScatterPlotData res = result;
            if (this.ifNeed2Bin == res.ifNeed2Bin && this.nBinsX == res.nBinsX && this.nBinsY == res.nBinsY) {
                this.nCases += res.nCases;
                this.weight += res.weight;
                this.totalFreqWeight += res.totalFreqWeight;
                for (i = 0; i < this.nBinsX; ++i) {
                    for (j = 0; j < this.nBinsY; ++j) {
                        double[] dArray = this.vvNCases[i];
                        int n = j;
                        dArray[n] = dArray[n] + res.vvNCases[i][j];
                        double[] dArray2 = this.vvWeight[i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + res.vvWeight[i][j];
                    }
                }
            } else {
                throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
            }
            for (i = 0; i < this.nBinsX; ++i) {
                for (j = 0; j < this.nBinsY; ++j) {
                    if (!(copyOfWeight[i][j] > 0.0)) continue;
                    coeff = copyOfWeight[i][j] / this.vvWeight[i][j];
                    double[] dArray = this.vvXMeans[i];
                    int n = j;
                    dArray[n] = dArray[n] * coeff;
                    double[] dArray3 = this.vvYMeans[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] * coeff;
                }
            }
            if (this.nCases > 0.0) {
                for (i = 0; i < this.nBinsX; ++i) {
                    for (j = 0; j < this.nBinsY; ++j) {
                        if (!(res.vvWeight[i][j] > 0.0)) continue;
                        coeff = res.vvWeight[i][j] / this.vvWeight[i][j];
                        double[] dArray = this.vvXMeans[i];
                        int n = j;
                        dArray[n] = dArray[n] + coeff * res.vvXMeans[i][j];
                        double[] dArray4 = this.vvYMeans[i];
                        int n4 = j;
                        dArray4[n4] = dArray4[n4] + coeff * res.vvYMeans[i][j];
                    }
                }
            }
        }
        this.merge4NoBin(result);
        ++this.nMerged;
    }

    public void merge4NoBin(ScatterPlotData result) {
        if (!this.ifNeed2Bin) {
            double totalFreq = this.variateData.getCounts().getTotalFreq() + result.variateData.getCounts().getTotalFreq();
            this.variateData.getCounts().setTotalFreq(totalFreq);
            for (int i = 0; i < 3; ++i) {
                ArrayList vals = ((XMLCoordinates)result.variateData.getCoordinates().get(i)).getDoubleVals();
                ((XMLCoordinates)this.variateData.getCoordinates().get(i)).getDoubleVals().addAll(vals);
            }
        }
    }

    public void sortVariateData() {
        ArrayList<Tuple3> sortedCoordinates = new ArrayList<Tuple3>();
        ArrayList firstVals = ((XMLCoordinates)this.variateData.getCoordinates().get(0)).getDoubleVals();
        ArrayList secondVals = ((XMLCoordinates)this.variateData.getCoordinates().get(1)).getDoubleVals();
        ArrayList freqVals = ((XMLCoordinates)this.variateData.getCoordinates().get(2)).getDoubleVals();
        for (int i = 0; i < firstVals.size(); ++i) {
            sortedCoordinates.add(new Tuple3(firstVals.get(i), secondVals.get(i), freqVals.get(i)));
        }
        int len = sortedCoordinates.size();
        Tuple3 temp = new Tuple3((Object)0.0, (Object)0.0, (Object)0.0);
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len - i - 1; ++j) {
                Tuple3 ta = (Tuple3)sortedCoordinates.get(j);
                Tuple3 tb = (Tuple3)sortedCoordinates.get(j + 1);
                boolean exchange = false;
                if ((Double)ta.first > (Double)tb.first) {
                    exchange = true;
                } else if (ta.first == tb.first && (Double)ta.second > (Double)tb.second) {
                    exchange = true;
                }
                if (!exchange) continue;
                temp.first = ta.first;
                temp.second = ta.second;
                temp.third = ta.third;
                ta.first = tb.first;
                ta.second = tb.second;
                ta.third = tb.third;
                tb.first = temp.first;
                tb.second = temp.second;
                tb.third = temp.third;
            }
        }
        firstVals.clear();
        secondVals.clear();
        freqVals.clear();
        for (Tuple3 tuple : sortedCoordinates) {
            firstVals.add(tuple.first);
            secondVals.add(tuple.second);
            freqVals.add(tuple.third);
        }
    }

    public String toString() {
        return "ScatterPlotData [ifNeed2Bin=" + this.ifNeed2Bin + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", minX=" + this.minX + ", minY=" + this.minY + ", nBinsX=" + this.nBinsX + ", nBinsY=" + this.nBinsY + ", nCases=" + this.nCases + ", nMerged=" + this.nMerged + ", stepLenX=" + this.stepLenX + ", stepLenY=" + this.stepLenY + ", totalFreqWeight=" + this.totalFreqWeight + ", variateData=" + this.variateData + ", vvNCases=" + Arrays.deepToString((Object[])this.vvNCases) + ", vvWeight=" + Arrays.deepToString((Object[])this.vvWeight) + ", vvXMeans=" + Arrays.deepToString((Object[])this.vvXMeans) + ", vvYMeans=" + Arrays.deepToString((Object[])this.vvYMeans) + ", weight=" + this.weight + "]";
    }
}

