/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.output;

import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.ac.acmath.output.ClassificationMatrix;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.utilities.i18n.LocMsgId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TargetClassAnalysis {
    private DenseRectMatrix mProbabilities;
    private DenseRectMatrix mNRecs;
    private int theTargetClass;
    private boolean isDone = false;
    private int nTargetCategs = 0;
    private int nCells = 0;
    private int nGroups = 0;
    private ArrayList<Double> probabilitiesSorted = new ArrayList();
    private ArrayList<Integer> probabilitiesIndices = new ArrayList();
    private ArrayList<Double> modelAccuracies = new ArrayList();
    private ArrayList<Double> casePercentages = new ArrayList();
    private Double[][] truePositiveRates;
    private ArrayList<Double> falsePositiveRates = new ArrayList();
    private ArrayList<Double> positivePredictiveValues = new ArrayList();
    private ArrayList<Double> gmeans = new ArrayList();
    private ArrayList<Double> fmeasures = new ArrayList();
    private double[][] classificationTable;

    public TargetClassAnalysis(DenseRectMatrix mProbabilities, DenseRectMatrix mNRecs, int theTargetClass) {
        this.mProbabilities = mProbabilities;
        this.mNRecs = mNRecs;
        this.theTargetClass = theTargetClass;
        this.isDone = this.setupModel();
    }

    private boolean setupModel() {
        int i;
        if (this.mProbabilities.getNRows() != this.mNRecs.getNRows()) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (this.mProbabilities.getNCols() != this.mNRecs.getNCols()) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (this.mProbabilities.getNRows() == 0) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (this.mProbabilities.getNCols() == 0) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        if (this.theTargetClass < 0 || this.theTargetClass >= this.mProbabilities.getNCols()) {
            throw new ACException((LocMsgId)ACMessages.REGR_INTERNAL_ERROR, new Object[0]);
        }
        this.nCells = this.mProbabilities.getNRows();
        this.nGroups = this.nCells + 1;
        this.nTargetCategs = this.mProbabilities.getNCols();
        this.probabilitiesSorted.clear();
        this.probabilitiesIndices.clear();
        ArrayList<Double> nodesSize = new ArrayList<Double>();
        Integer[] nonTargetClasses = new Integer[this.nCells];
        for (i = 0; i < this.nCells; ++i) {
            double maxProb = 0.0;
            int prediction = -1;
            double secondProb = 0.0;
            int secondPrediction = -1;
            double nodeSize = 0.0;
            for (int j = 0; j < this.nTargetCategs; ++j) {
                double prob = this.mProbabilities.getElem(i, j);
                if (prob > maxProb) {
                    secondPrediction = prediction;
                    secondProb = maxProb;
                    maxProb = prob;
                    prediction = j;
                } else if (prob == maxProb || prob > secondProb) {
                    secondProb = prob;
                    secondPrediction = j;
                } else if (prob == secondProb && secondPrediction == -1) {
                    secondPrediction = j;
                }
                nodeSize += this.mNRecs.getElem(i, j);
            }
            this.probabilitiesSorted.add(this.mProbabilities.getElem(i, this.theTargetClass));
            this.probabilitiesIndices.add(i);
            nodesSize.add(nodeSize);
            if (prediction == this.theTargetClass) {
                nonTargetClasses[i] = secondPrediction;
                continue;
            }
            if (prediction < 0) continue;
            nonTargetClasses[i] = prediction;
        }
        this.sortTuplesDIGT(this.probabilitiesSorted, nodesSize, this.probabilitiesIndices);
        this.modelAccuracies.clear();
        this.casePercentages.clear();
        this.falsePositiveRates.clear();
        this.positivePredictiveValues.clear();
        this.gmeans.clear();
        this.fmeasures.clear();
        this.truePositiveRates = new Double[this.nTargetCategs][];
        for (i = 0; i < this.nTargetCategs; ++i) {
            this.truePositiveRates[i] = new Double[this.nGroups];
        }
        this.classificationTable = new double[this.nGroups][];
        for (int iGroup = 0; iGroup < this.nGroups; ++iGroup) {
            int k;
            int i2;
            ClassificationMatrix clsMatrix = new ClassificationMatrix(this.nTargetCategs);
            for (i2 = 0; i2 < iGroup; ++i2) {
                for (k = 0; k < this.nTargetCategs; ++k) {
                    clsMatrix.updateData(this.mNRecs.getElem(this.probabilitiesIndices.get(i2).intValue(), k), this.theTargetClass, k);
                }
            }
            for (i2 = iGroup; i2 < this.nCells; ++i2) {
                for (k = 0; k < this.nTargetCategs; ++k) {
                    clsMatrix.updateData(this.mNRecs.getElem(this.probabilitiesIndices.get(i2).intValue(), k), nonTargetClasses[this.probabilitiesIndices.get(i2)], k);
                }
            }
            this.classificationTable[iGroup] = new double[this.nTargetCategs * this.nTargetCategs];
            System.arraycopy(clsMatrix.getMatrix().getMatrix(), 0, this.classificationTable[iGroup], 0, this.nTargetCategs * this.nTargetCategs);
            double numAccuracy = 0.0;
            double numCases2 = 0.0;
            double numFalsePositive = 0.0;
            double numTotalFalsePositive = 0.0;
            for (int i3 = 0; i3 < this.nTargetCategs; ++i3) {
                numAccuracy += clsMatrix.getMatrix().getElem(i3, i3);
                numCases2 += clsMatrix.getMatrix().getElem(this.theTargetClass, i3);
                if (i3 != this.theTargetClass) {
                    numFalsePositive += clsMatrix.getMatrix().getElem(this.theTargetClass, i3);
                }
                double numTruePositive = 0.0;
                for (int j = 0; j < this.nTargetCategs; ++j) {
                    numTruePositive += clsMatrix.getMatrix().getElem(j, i3);
                    if (j == this.theTargetClass) continue;
                    numTotalFalsePositive += clsMatrix.getMatrix().getElem(i3, j);
                }
                this.truePositiveRates[i3][iGroup] = clsMatrix.getMatrix().getElem(i3, i3) / numTruePositive;
            }
            this.modelAccuracies.add(numAccuracy / clsMatrix.getTotalWeight());
            this.casePercentages.add(numCases2 / clsMatrix.getTotalWeight());
            this.falsePositiveRates.add(numFalsePositive / numTotalFalsePositive);
            double ppv = clsMatrix.getMatrix().getElem(this.theTargetClass, this.theTargetClass) / numCases2;
            this.positivePredictiveValues.add(ppv);
            double tpr = this.truePositiveRates[this.theTargetClass][iGroup];
            this.fmeasures.add(2.0 * tpr * ppv / (tpr + ppv));
        }
        ArrayList<Integer> excludedList = new ArrayList<Integer>(this.nTargetCategs);
        for (int i4 = 0; i4 < this.nTargetCategs; ++i4) {
            boolean isConstant = true;
            for (int iGroup = 0; iGroup < this.nGroups; ++iGroup) {
                if (this.truePositiveRates[i4][iGroup] == 0.0) continue;
                isConstant = false;
                break;
            }
            if (!isConstant) continue;
            excludedList.add(i4);
        }
        for (int iGroup = 0; iGroup < this.nGroups; ++iGroup) {
            double gmean = 1.0;
            for (int i5 = 0; i5 < this.nTargetCategs; ++i5) {
                double tpr;
                if (excludedList.indexOf(i5) != -1 || MissingValue.isMissing((double)(tpr = this.truePositiveRates[i5][iGroup].doubleValue()))) continue;
                gmean *= tpr;
            }
            this.gmeans.add(Math.pow(gmean, 1.0 / (double)(this.nTargetCategs - excludedList.size())));
        }
        this.probabilitiesSorted.add(0, Double.NaN);
        this.probabilitiesIndices.add(0, -1);
        return true;
    }

    public boolean isModelSetupDone() {
        return this.isDone;
    }

    public int getNumOfGroups() {
        return this.nGroups;
    }

    public List<Double> getProbabilities() {
        return this.probabilitiesSorted;
    }

    public List<Integer> getGroups() {
        return this.probabilitiesIndices;
    }

    public List<Double> getModelAccuracies() {
        return this.modelAccuracies;
    }

    public List<Double> getPercentages() {
        return this.casePercentages;
    }

    public List<Double> getFalsePositiveRates() {
        return this.falsePositiveRates;
    }

    public List<Double> getPositivePredictiveValues() {
        return this.positivePredictiveValues;
    }

    public List<Double> getGMeans() {
        return this.gmeans;
    }

    public List<Double> getFMeasure() {
        return this.fmeasures;
    }

    public Double[][] getTruePositiveRates() {
        return (Double[][])this.truePositiveRates.clone();
    }

    public double[][] getClassificationTable() {
        return (double[][])this.classificationTable.clone();
    }

    private void sortTuplesDIGT(ArrayList<Double> alDbl, ArrayList<Double> alDbl2, ArrayList<Integer> alInt) {
        int nVals = alDbl.size();
        ArrayList<DDITuple> list = new ArrayList<DDITuple>();
        for (int i = 0; i < nVals; ++i) {
            list.add(new DDITuple(alDbl.get(i), alDbl2.get(i), alInt.get(i)));
        }
        DDITupleGTComparator comparator = new DDITupleGTComparator();
        Collections.sort(list, comparator);
        for (int i = 0; i < nVals; ++i) {
            DDITuple tuple = (DDITuple)list.get(i);
            alDbl.set(i, tuple.first);
            alDbl2.set(i, tuple.second);
            alInt.set(i, tuple.third);
        }
    }

    static class DDITupleGTComparator
    implements Comparator<DDITuple>,
    Serializable {
        private static final long serialVersionUID = -4940218612236654070L;

        DDITupleGTComparator() {
        }

        @Override
        public int compare(DDITuple object1, DDITuple object2) {
            int cmp = Double.compare(object2.first, object1.first);
            if (cmp == 0) {
                cmp = Double.compare(object2.second, object1.second);
            }
            return cmp;
        }
    }

    static class DDITuple {
        public double first;
        public double second;
        public int third;

        public DDITuple(double first, double second, int third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }
    }
}

