/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.MathFun;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class EigenValues {
    private int maxIter = 30;
    private double tolerance = 1.0E-12;
    private final double tolPD = 1.0E-6;
    private final double largeEigVal = 1000.0;
    int nRows = 0;
    boolean doEigenVectors = false;
    DenseSymMatrix mH = null;
    DenseSymMatrix mE = null;
    double[] eDiag = null;
    DenseSymMatrix mEChol = null;
    DenseSymMatrix mECholInv = null;
    DenseSymMatrix mVHV = null;
    DenseSymMatrix mOrthInfo = null;
    DenseSymMatrix mEVEV;
    int eRank;
    boolean validEMatrix = false;
    double[] diag3 = null;
    double[] subDiag3 = null;
    double[] eigenVals;
    int nEigenVals;
    DenseRectMatrix mEigenVectors;

    public EigenValues() {
        this.doEigenVectors = false;
        this.nRows = 0;
        this.eRank = 0;
        this.validEMatrix = false;
        this.nEigenVals = 0;
    }

    public EigenValues(double tol, int maxIter) {
        this.tolerance = tol;
        this.maxIter = maxIter;
        this.doEigenVectors = false;
        this.nRows = 0;
        this.eRank = 0;
        this.validEMatrix = false;
        this.nEigenVals = 0;
    }

    public EigenValues(DenseSymMatrix mtxH, double tol, int maxIter) {
        this(tol, maxIter);
        this.setHMatrix(mtxH);
    }

    public EigenValues(DenseSymMatrix mtxH, DenseSymMatrix mtxE, double tol, int maxIter) {
        this(mtxH, tol, maxIter);
        this.validEMatrix = this.setEMatrix(mtxE);
    }

    public boolean setTolerance(double tol) {
        boolean result;
        boolean bl = result = tol > 0.0;
        if (result) {
            this.tolerance = tol;
        }
        return result;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public boolean setMaxIter(int maxIter) {
        boolean result;
        boolean bl = result = maxIter > 0;
        if (result) {
            this.maxIter = maxIter;
        }
        return result;
    }

    public int getMaxIter() {
        return this.maxIter;
    }

    public void setHMatrix(DenseSymMatrix mtxH) {
        this.nRows = mtxH.getNRows();
        this.mH = new DenseSymMatrix(this.nRows);
        mtxH.copyTo(this.mH);
    }

    public boolean setEMatrix(DenseSymMatrix mtxE) {
        boolean result;
        boolean bl = result = this.nRows == mtxE.getNRows();
        if (result) {
            this.mE = new DenseSymMatrix(this.nRows);
            mtxE.copyTo(this.mE);
            this.eDiag = new double[this.nRows];
            this.mEChol = new DenseSymMatrix(this.nRows);
            this.mE.copyTo(this.mEChol);
            int nDep = this.mEChol.lTChol(this.eDiag, this.tolerance, false);
            this.eRank = 0;
            if (nDep >= 0) {
                this.eRank = this.nRows - nDep;
            }
            boolean bl2 = result = this.eRank > 0;
        }
        if (result) {
            this.mECholInv = new DenseSymMatrix(this.nRows);
            this.mEChol.copyTo(this.mECholInv);
            double[] det = new double[2];
            int job = 10;
            this.mECholInv.lTDetInverse(det, job);
            result = this.mH.computeLSLTrans(this.mECholInv, this.mVHV);
        }
        if (!result) {
            this.mE.resize(0);
            this.mEChol.resize(0);
            this.eRank = 0;
            this.mECholInv.resize(0);
        }
        this.validEMatrix = result;
        return result;
    }

    public boolean IsValidEMatrix() {
        return this.validEMatrix;
    }

    public int compute(double[] eigenVals) {
        int result = -1;
        if (eigenVals.length >= this.nRows) {
            result = 0;
        }
        if (result == 0) {
            this.triDiag();
            int retCode = this.eigenValuesTQLI();
            result = retCode == 0 ? this.nRows : retCode - 1;
        }
        if (result > 0) {
            if (this.eigenVals == null || this.eigenVals.length != this.nRows) {
                this.eigenVals = new double[this.nRows];
            }
            System.arraycopy(this.diag3, 0, this.eigenVals, 0, result);
            System.arraycopy(this.eigenVals, 0, eigenVals, 0, this.nRows);
        }
        return result;
    }

    public int compute(double[] eigenVals, DenseRectMatrix mEigenVectors) {
        this.doEigenVectors = true;
        int result = this.compute(eigenVals);
        if (result > 0) {
            this.backTransVectors();
            this.mEigenVectors.copyTo(mEigenVectors);
        }
        return result;
    }

    public int getSorted(double[] eigenVals, boolean descending) {
        int result = -1;
        if (eigenVals.length < this.nRows) {
            return result;
        }
        result = 0;
        result = this.nEigenVals;
        if (this.eigenVals == null || this.eigenVals.length != this.nRows) {
            result = this.compute(eigenVals);
        } else if (result > 0) {
            System.arraycopy(this.eigenVals, 0, eigenVals, 0, this.nRows);
        }
        if (result > 0) {
            if (descending) {
                int i;
                for (i = 0; i < eigenVals.length; ++i) {
                    eigenVals[i] = -eigenVals[i];
                }
                Arrays.sort(eigenVals);
                for (i = 0; i < eigenVals.length; ++i) {
                    eigenVals[i] = -eigenVals[i];
                }
            } else {
                Arrays.sort(eigenVals);
            }
        }
        return result;
    }

    public int getSorted(double[] eigenVals, DenseRectMatrix mEigenVectors, boolean descending) {
        Serializable comparator;
        int result = -1;
        if (eigenVals.length < this.nRows) {
            return result;
        }
        result = 0;
        result = this.nEigenVals;
        if (this.mEigenVectors == null || this.mEigenVectors.getNRows() == 0) {
            result = this.compute(eigenVals, mEigenVectors);
        }
        if (result <= 0) {
            return result;
        }
        ArrayList<DIPair> list = new ArrayList<DIPair>();
        for (int i = 0; i < result; ++i) {
            list.add(new DIPair(this.eigenVals[i], i));
        }
        if (descending) {
            comparator = new DIPairGTComparator();
            Collections.sort(list, comparator);
        } else {
            comparator = new DIPairLTComparator();
            Collections.sort(list, comparator);
        }
        if (mEigenVectors.getNRows() != this.nRows || mEigenVectors.getNCols() != this.nRows) {
            mEigenVectors.resize(this.nRows, this.nRows);
        }
        for (int i = 0; i < result; ++i) {
            DIPair pair = (DIPair)list.get(i);
            eigenVals[i] = pair.first;
            int iRowFrom = pair.second;
            this.mEigenVectors.copyRowToRow(iRowFrom, i, mEigenVectors);
        }
        return result;
    }

    public boolean isPDHMatrix(double tol) {
        double[] eigenVals;
        boolean result = true;
        if (tol <= 0.0) {
            tol = 1.0E-6;
        }
        if (this.compute(eigenVals = new double[this.nRows]) != this.nRows) {
            result = false;
        }
        if (result) {
            for (int i = 0; i < this.nRows; ++i) {
                if (!(eigenVals[i] < tol)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean getPDHMatrix(double tol, DenseSymMatrix mtxPD, boolean[] changed) {
        if (tol <= 0.0) {
            tol = 1.0E-6;
        }
        boolean result = true;
        changed[0] = false;
        if (mtxPD.getNRows() != this.nRows) {
            result = mtxPD.resize(this.nRows);
        }
        if (result) {
            mtxPD.clear();
            double[] eigenVals = new double[this.nRows];
            this.doEigenVectors = true;
            if (this.compute(eigenVals) != this.nRows) {
                result = false;
            }
            if (result) {
                boolean reConstr;
                double eigMin = Double.MAX_VALUE;
                for (int i = 0; i < this.nRows; ++i) {
                    if (!(eigenVals[i] < eigMin)) continue;
                    eigMin = eigenVals[i];
                }
                boolean bl = reConstr = eigMin < tol;
                if (reConstr) {
                    this.backTransVectors();
                    if (this.mEVEV == null) {
                        this.mEVEV = new DenseSymMatrix(this.nRows);
                    } else if (this.mEVEV.getNRows() != this.nRows) {
                        this.mEVEV.resize(this.nRows);
                    }
                    this.mEVEV.clear();
                    for (int i = 0; i < this.nRows; ++i) {
                        double[] row;
                        if (eigenVals[i] < tol) {
                            eigenVals[i] = tol;
                        }
                        if ((result = this.mEVEV.setToVV(row = this.mEigenVectors.getRow(i))) && (result = mtxPD.computeAXpY(eigenVals[i], this.mEVEV))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    this.mH.copyTo(mtxPD);
                }
                if (reConstr && result) {
                    changed[0] = true;
                }
            }
        }
        return result;
    }

    public boolean getPDHMatrix(double tol, DenseSymMatrix mtxPD, boolean[] changed, boolean relTol) {
        if (!relTol) {
            return this.getPDHMatrix(tol, mtxPD, changed);
        }
        if (tol <= 0.0) {
            tol = 1.0E-6;
        }
        boolean result = true;
        changed[0] = false;
        if (mtxPD.getNRows() != this.nRows) {
            result = mtxPD.resize(this.nRows);
        }
        if (result) {
            mtxPD.clear();
            double[] eigenVals = new double[this.nRows];
            this.doEigenVectors = true;
            if (this.compute(eigenVals) != this.nRows) {
                result = false;
            }
            if (result) {
                boolean reConstr;
                double eigMin = Double.MAX_VALUE;
                double eigMax = -1.7976931348623157E308;
                for (int i = 0; i < this.nRows; ++i) {
                    double eVal = eigenVals[i];
                    if (eVal < eigMin) {
                        eigMin = eVal;
                    }
                    if (!(eVal > eigMax)) continue;
                    eigMax = eVal;
                }
                double useTol = eigMax < this.largeEigVal ? tol : tol * eigMax;
                boolean bl = reConstr = eigMin < useTol;
                if (reConstr) {
                    this.backTransVectors();
                    if (this.mEVEV == null) {
                        this.mEVEV = new DenseSymMatrix(this.nRows);
                    } else if (this.mEVEV.getNRows() != this.nRows) {
                        this.mEVEV.resize(this.nRows);
                    }
                    this.mEVEV.clear();
                    for (int i = 0; i < this.nRows; ++i) {
                        double[] row;
                        if (eigenVals[i] < useTol) {
                            eigenVals[i] = useTol;
                        }
                        if ((result = this.mEVEV.setToVV(row = this.mEigenVectors.getRow(i))) && (result = mtxPD.computeAXpY(eigenVals[i], this.mEVEV))) {
                            continue;
                        }
                        break;
                    }
                } else {
                    this.mH.copyTo(mtxPD);
                }
                if (reConstr && result) {
                    changed[0] = true;
                }
            }
        }
        return result;
    }

    public boolean getPDHMatrix(double tol, DenseSymMatrix mtxPD) {
        boolean[] changed = new boolean[1];
        return this.getPDHMatrix(tol, mtxPD, changed);
    }

    public void triDiag() {
        if (this.mOrthInfo == null) {
            this.mOrthInfo = new DenseSymMatrix(this.nRows);
        }
        this.mH.copyTo(this.mOrthInfo);
        if (this.eRank > 0) {
            this.mVHV.copyTo(this.mOrthInfo);
        }
        this.tred3();
        if (!this.doEigenVectors) {
            this.mOrthInfo.resize(0);
        }
    }

    private int eigenValuesTQLI() {
        int result = 0;
        if (this.nRows <= 0 || this.diag3.length != this.nRows || this.subDiag3.length != this.nRows) {
            result = -1;
        }
        if (result != -1) {
            int i;
            double[] vSubDiag = new double[this.nRows];
            if (this.doEigenVectors) {
                if (this.mEigenVectors == null) {
                    this.mEigenVectors = new DenseRectMatrix(this.nRows, this.nRows);
                } else if (this.mEigenVectors.getNRows() != this.nRows || this.mEigenVectors.getNCols() != this.nRows) {
                    this.mEigenVectors.resize(this.nRows, this.nRows);
                }
                this.mEigenVectors.clear();
                for (i = 0; i < this.nRows; ++i) {
                    this.mEigenVectors.setElem(i, i, 1.0);
                }
            }
            if (this.nRows == 1) {
                vSubDiag[0] = 0.0;
            } else {
                for (i = 0; i < this.nRows - 1; ++i) {
                    vSubDiag[i] = this.subDiag3[i + 1];
                }
                vSubDiag[this.nRows - 1] = 0.0;
            }
            int eCount = 0;
            while (result == 0 && eCount < this.nRows) {
                int iEigen = ++eCount - 1;
                int iter = 0;
                while (result == 0 && iter < this.maxIter) {
                    int m = eCount;
                    int iM = m - 1;
                    boolean bOK = true;
                    while (bOK) {
                        double aSum = Math.abs(this.diag3[iM]);
                        if (iM + 1 < this.nRows) {
                            aSum += Math.abs(this.diag3[iM + 1]);
                        }
                        if (Math.abs(vSubDiag[iM]) > this.tolerance * aSum) {
                            ++iM;
                            bOK = ++m < this.nRows;
                            continue;
                        }
                        bOK = false;
                    }
                    if (m != eCount) {
                        ++iter;
                        double g = (this.diag3[iEigen + 1] - this.diag3[iEigen]) / (2.0 * vSubDiag[iEigen]);
                        double r = Math.sqrt(g * g + 1.0);
                        double sR = g >= 0.0 ? r : -r;
                        g = this.diag3[iM] - this.diag3[iEigen] + vSubDiag[iEigen] / (g + sR);
                        double sine = 1.0;
                        double cosine = 1.0;
                        double p = 0.0;
                        for (i = m - 1; i >= eCount; --i) {
                            int im1 = i - 1;
                            double f = sine * vSubDiag[im1];
                            double b = cosine * vSubDiag[im1];
                            if (Math.abs(f) >= Math.abs(g)) {
                                cosine = g / f;
                                r = Math.sqrt(cosine * cosine + 1.0);
                                vSubDiag[im1 + 1] = f * r;
                                sine = 1.0 / r;
                                cosine *= sine;
                            } else {
                                sine = f / g;
                                r = Math.sqrt(sine * sine + 1.0);
                                vSubDiag[im1 + 1] = g * r;
                                cosine = 1.0 / r;
                                sine *= cosine;
                            }
                            g = this.diag3[im1 + 1] - p;
                            r = (this.diag3[im1] - g) * sine + 2.0 * cosine * b;
                            p = sine * r;
                            this.diag3[im1 + 1] = g + p;
                            g = cosine * r - b;
                            if (!this.doEigenVectors) continue;
                            for (int km1 = 0; km1 < this.nRows; ++km1) {
                                b = this.mEigenVectors.getElem(im1, km1);
                                f = this.mEigenVectors.getElem(im1 + 1, km1);
                                this.mEigenVectors.setElem(im1 + 1, km1, sine * b + cosine * f);
                                this.mEigenVectors.setElem(im1, km1, cosine * b - sine * f);
                            }
                        }
                        this.diag3[iEigen] = this.diag3[iEigen] - p;
                        vSubDiag[iEigen] = g;
                        vSubDiag[iM] = 0.0;
                        continue;
                    }
                    result = -2;
                }
                if (result == 0) {
                    result = eCount;
                    continue;
                }
                result = 0;
            }
        }
        if (result == 0) {
            this.nEigenVals = this.nRows;
        } else if (result > 0) {
            this.nEigenVals = result - 1;
        }
        return result;
    }

    private void backTransVectors() {
        double[] vOrth = this.mOrthInfo.getMatrix();
        double[] vEigVec = this.mEigenVectors.getMatrix();
        int iDiag = 0;
        for (int i = 2; i <= this.nRows; ++i) {
            int iRow1 = iDiag + 1;
            iDiag += i;
            int im1 = i - 1;
            double diagElm = this.mOrthInfo.getElem(im1, im1);
            if (diagElm == 0.0) continue;
            int iEVec1 = 0;
            for (int j = 0; j < this.nEigenVals; ++j) {
                double dotProd = MathFun.dDot((int)im1, (double[])vOrth, (int)iRow1, (int)1, (double[])vEigVec, (int)iEVec1, (int)1);
                dotProd /= diagElm;
                MathFun.daxpy((int)im1, (double)(dotProd /= -diagElm), (double[])vOrth, (int)iRow1, (int)1, (double[])vEigVec, (int)iEVec1, (int)1);
                iEVec1 += this.nRows;
            }
        }
    }

    private void tred3() {
        double[] vOrth = this.mOrthInfo.getMatrix();
        double dMin = Double.MIN_VALUE;
        if (this.diag3 == null || this.diag3.length != this.nRows) {
            this.diag3 = new double[this.nRows];
        }
        if (this.subDiag3 == null || this.subDiag3.length != this.nRows) {
            this.subDiag3 = new double[this.nRows];
        }
        for (int i = this.nRows; i >= 2; --i) {
            int im1 = i - 1;
            int iAij = i * im1 / 2 - 1;
            double hVal = 0.0;
            double scale = 0.0;
            int jTo = 0;
            for (int j = iAij + 1; j < iAij + i; ++j) {
                this.diag3[jTo++] = vOrth[j];
            }
            scale = MathFun.dASum((int)im1, (double[])this.diag3, (int)1);
            iAij += im1;
            if (scale > dMin) {
                MathFun.dScal((int)im1, (double)(1.0 / scale), (double[])this.diag3, (int)0, (int)1);
                hVal = MathFun.dDot((int)im1, (double[])this.diag3, (int)0, (int)1, (double[])this.diag3, (int)0, (int)1);
                double f = this.diag3[im1 - 1];
                double g = -Math.sqrt(hVal);
                if (f < 0.0) {
                    g = -g;
                }
                this.subDiag3[i - 1] = scale * g;
                this.diag3[im1 - 1] = f - g;
                vOrth[iAij] = scale * (f - g);
                this.mOrthInfo.computeSV(im1, this.diag3, this.subDiag3);
                double recpH = 1.0 / (hVal -= f * g);
                MathFun.dScal((int)im1, (double)recpH, (double[])this.subDiag3, (int)0, (int)1);
                double kVal = 0.5 * recpH * MathFun.dDot((int)im1, (double[])this.diag3, (int)0, (int)1, (double[])this.subDiag3, (int)0, (int)1);
                int iArj = 0;
                for (int j = 1; j <= im1; ++j) {
                    int jm1 = j - 1;
                    f = this.diag3[jm1];
                    this.subDiag3[jm1] = g = this.subDiag3[jm1] - kVal * f;
                    MathFun.daxpy((int)j, (double)(-f), (double[])this.subDiag3, (int)0, (int)1, (double[])vOrth, (int)iArj, (int)1);
                    MathFun.daxpy((int)j, (double)(-g), (double[])this.diag3, (int)0, (int)1, (double[])vOrth, (int)iArj, (int)1);
                    iArj += j;
                }
                this.diag3[i - 1] = vOrth[iAij + 1];
                vOrth[iAij + 1] = scale * Math.sqrt(hVal);
                continue;
            }
            this.subDiag3[i - 1] = 0.0;
            this.diag3[i - 1] = vOrth[iAij + 1];
            vOrth[iAij + 1] = 0.0;
        }
        if (this.nRows > 0) {
            this.subDiag3[0] = 0.0;
            this.diag3[0] = vOrth[0];
            vOrth[0] = 0.0;
        }
    }

    static class DIPairLTComparator
    implements Comparator<DIPair>,
    Serializable {
        private static final long serialVersionUID = -5719920362263370603L;

        DIPairLTComparator() {
        }

        @Override
        public int compare(DIPair object1, DIPair object2) {
            int cmp = Double.compare(object1.first, object2.first);
            return cmp;
        }
    }

    static class DIPairGTComparator
    implements Comparator<DIPair>,
    Serializable {
        private static final long serialVersionUID = -8762355011164650063L;

        DIPairGTComparator() {
        }

        @Override
        public int compare(DIPair object1, DIPair object2) {
            int cmp = Double.compare(object2.first, object1.first);
            return cmp;
        }
    }

    static class DIPair {
        public double first;
        public int second;

        public DIPair(double first, int second) {
            this.first = first;
            this.second = second;
        }
    }
}

