/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class HashKey
implements Comparable<HashKey>,
ACSerializable {
    private static final long serialVersionUID = 5252894256084359827L;
    static final int[] factor = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229};
    private int[] theArray = null;
    private int hashCode = 0;

    public HashKey() {
        this.theArray = new int[0];
        this.hashCode = this.hash();
    }

    public HashKey(int nItems) {
        this.theArray = new int[nItems];
        this.hashCode = this.hash();
    }

    public HashKey(HashKey set) {
        this.theArray = (int[])set.getTheArray().clone();
        this.hashCode = set.hashCode;
    }

    public HashKey(HashKey set, int item) {
        this.theArray = new int[set.length() + 1];
        for (int i = 0; i < set.length(); ++i) {
            this.theArray[i] = set.getItemAt(i);
        }
        this.theArray[set.length()] = item;
        this.hashCode = this.hash();
    }

    public HashKey(int[] array) {
        this.theArray = (int[])array.clone();
        this.hashCode = this.hash();
    }

    public HashKey(int[] set, int length) {
        this.theArray = new int[length];
        for (int i = 0; i < this.theArray.length; ++i) {
            this.theArray[i] = set[i];
        }
        this.hashCode = this.hash();
    }

    public HashKey(int[] set, int[] seq, int length) {
        this.theArray = new int[length];
        for (int i = 0; i < this.theArray.length; ++i) {
            this.theArray[i] = set[seq[i]];
        }
        this.hashCode = this.hash();
    }

    public void display() {
        for (int i = 0; i < this.theArray.length; ++i) {
            System.out.print(" " + this.theArray[i]);
        }
        System.out.println(" End of Set ");
    }

    public String toString() {
        String result = "Hashkey:";
        for (int i = 0; i < this.theArray.length; ++i) {
            result = result + " " + this.theArray[i];
        }
        result = result + " Hash code = " + this.hashCode + "\n";
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o != null) {
            boolean allSame = true;
            try {
                int[] oI = ((HashKey)o).getTheArray();
                if (oI.length == this.theArray.length && o.hashCode() == this.hashCode) {
                    for (int i = 0; i < this.theArray.length; ++i) {
                        if (oI[i] == this.theArray[i]) continue;
                        allSame = false;
                        break;
                    }
                    if (allSame) {
                        result = true;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public int compareTo(HashKey o) {
        if (o == null) {
            return 1;
        }
        int result = -1;
        int l1 = this.theArray.length;
        int[] oI = o.getTheArray();
        int l2 = oI.length;
        if (l1 < l2) {
            result = -1;
        } else if (l1 > l2) {
            result = 1;
        } else {
            result = 0;
            for (int i = 0; i < l1; ++i) {
                int item1 = this.theArray[i];
                int item2 = oI[i];
                if (item1 < item2) {
                    result = -1;
                    break;
                }
                if (item1 <= item2) continue;
                result = 1;
                break;
            }
        }
        return result;
    }

    public int length() {
        return this.theArray.length;
    }

    public int getItemAt(int i) {
        return this.theArray[i];
    }

    public int[] getTheArray() {
        return this.theArray;
    }

    public void updateHashKey(int[] set) {
        this.hashCode = 0;
        for (int i = 0; i < this.theArray.length && i < set.length; ++i) {
            this.theArray[i] = set[i];
        }
        this.hashCode = this.hash();
    }

    public void updateHashKey(int index, int item) {
        this.theArray[index] = item;
    }

    public void updateHashKey(int[] set, int[] seq) {
        this.hashCode = 0;
        for (int i = 0; i < this.theArray.length && i < seq.length; ++i) {
            this.theArray[i] = set[seq[i]];
        }
        this.hashCode = this.hash();
    }

    public int updateHashCode() {
        this.hashCode = this.hash();
        return this.hashCode;
    }

    private int hash() {
        int result = 0;
        for (int i = 0; i < this.theArray.length; ++i) {
            result ^= this.theArray[i] * factor[i % 49];
        }
        return result;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeIntArray((int[])this.theArray, (DataOutput)dataOutput);
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.theArray = ACSerializationUtils.readIntArray((DataInput)dataInput);
        if (this.theArray == null) {
            this.theArray = new int[0];
        }
        this.updateHashCode();
        return this;
    }
}

