/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.acbase.annotation.FromCppClass;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.ac.acmath.util.Sampler;
import com.spss.utilities.i18n.LocMsgId;
import java.util.Arrays;

@FromCppClass(value="CFPartitionSampler")
public class InnerPartition {
    private boolean isThreeWay = false;
    private Sampler sampler1;
    private Sampler sampler2;
    double[] partitionWeights = new double[3];

    public InnerPartition(double seed, double totalSize, double partition1Size, double partition2Size) {
        double t;
        boolean isValid = false;
        double s1 = Math.floor(partition1Size);
        double s2 = Math.floor(partition2Size);
        if (totalSize >= 1.0 && totalSize == Math.floor(totalSize) && partition1Size >= 0.0 && partition1Size == s1 && partition2Size >= 0.0 && partition2Size == s2 && (t = partition1Size + partition2Size) < totalSize) {
            if (partition2Size > 0.0) {
                this.isThreeWay = true;
            }
            isValid = true;
        }
        if (isValid) {
            this.sampler1 = new Sampler(seed, totalSize, partition1Size);
            if (this.isThreeWay) {
                this.sampler2 = new Sampler(seed, totalSize - partition1Size, partition2Size);
            }
        } else {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }

    public InnerPartition(double seed, double partition1Percent, double partition2Percent) {
        boolean isValid = false;
        if (partition1Percent >= 0.0 && partition1Percent <= 1.0 && partition2Percent >= 0.0 && partition2Percent <= 1.0) {
            double t = partition1Percent + partition2Percent;
            if (t < 1.0) {
                this.isThreeWay = true;
                isValid = true;
            } else if (t == 1.0) {
                this.isThreeWay = false;
                isValid = true;
            }
        }
        if (isValid) {
            this.sampler1 = new Sampler(seed, partition1Percent);
            if (this.isThreeWay) {
                this.sampler2 = new Sampler(seed, partition2Percent / (1.0 - partition1Percent));
            }
        } else {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }

    public double[] getPartitionWeights(double freqWeight) {
        Arrays.fill(this.partitionWeights, 0.0);
        if (freqWeight >= 1.0) {
            double[] t1 = this.sampler1.getWeights(freqWeight);
            this.partitionWeights[0] = t1[0];
            if (this.isThreeWay) {
                if (t1[1] != 0.0) {
                    double[] t2 = this.sampler2.getWeights(t1[1]);
                    this.partitionWeights[1] = t2[0];
                    this.partitionWeights[2] = t2[1];
                }
            } else {
                this.partitionWeights[1] = t1[1];
            }
        }
        return this.partitionWeights;
    }

    public boolean isThreeWay() {
        return this.isThreeWay;
    }
}

