/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.acbase.annotation.FromCppClass;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseSymMatrix;
import java.util.Arrays;

@FromCppClass(value="MCMATH_NAMESPACE::MCSparseVector")
public class SparseVector {
    private int nElements = 0;
    private int[] svIndices = null;
    private double[] svValues = null;
    private boolean svValid = false;

    public SparseVector(int[] svIndices, double[] svValues) {
        this.nElements = svIndices.length;
        this.svIndices = svIndices;
        this.svValues = svValues;
        this.svValid = true;
        if (this.nElements == 0 || this.svValues.length != this.nElements || this.svIndices[0] < 0) {
            this.svValid = false;
        }
        if (this.svValid) {
            for (int i = 0; i < this.nElements - 1; ++i) {
                if (this.svIndices[i + 1] > this.svIndices[i]) continue;
                this.svValid = false;
                break;
            }
        }
    }

    boolean isValid() {
        return this.svValid;
    }

    int getNElements() {
        return this.nElements;
    }

    int getMinVecSize() {
        int minSize = this.svIndices[this.nElements - 1] + 1;
        return minSize;
    }

    int getIndex(int iElm) {
        int result = -1;
        if (iElm >= 0 && iElm < this.nElements) {
            result = this.svIndices[iElm];
        }
        return result;
    }

    int[] getIndices() {
        return this.svIndices;
    }

    double getValue(int iElm) {
        double result = MissingValue.getMissing();
        if (iElm >= 0 && iElm < this.nElements) {
            result = this.svValues[iElm];
        }
        return result;
    }

    double[] getValues() {
        return this.svValues;
    }

    int convertToRegularVector(double[] vec) {
        int minSize = this.getMinVecSize();
        if (vec.length < minSize) {
            return -1;
        }
        Arrays.fill(vec, 0, minSize - 1, 0.0);
        for (int i = 0; i < this.nElements; ++i) {
            vec[this.svIndices[i]] = this.svValues[i];
        }
        return minSize;
    }

    boolean incrementPart(double[] regVec, int offset, double coeff) {
        boolean result = false;
        int minSize = this.getMinVecSize();
        if (offset >= 0 && offset + minSize <= regVec.length) {
            result = true;
            for (int iElm = 0; iElm < this.nElements; ++iElm) {
                int n = offset + this.svIndices[iElm];
                regVec[n] = regVec[n] + this.svValues[iElm] * coeff;
            }
        }
        return result;
    }

    boolean incrementPart(double[] regVec, int offset) {
        return this.incrementPart(regVec, offset, 1.0);
    }

    double innerProductWithPart(double[] regVec, int offset) {
        double result = MissingValue.getMissing();
        int minSize = this.getMinVecSize();
        if (offset >= 0 && offset + minSize <= regVec.length) {
            result = 0.0;
            for (int iElm = 0; iElm < this.nElements; ++iElm) {
                result += this.svValues[iElm] * regVec[offset + this.svIndices[iElm]];
            }
        }
        return result;
    }

    static double innerProduct(int[] ind1, double[] val1, int sInd1, int nElm1, int[] ind2, double[] val2, int sInd2, int nElm2) {
        if (sInd1 < 0 || nElm1 < 0 || sInd1 >= nElm1 || sInd2 < 0 || nElm2 < 0 || sInd2 >= nElm2) {
            return MissingValue.getMissing();
        }
        int index1 = sInd1;
        int index2 = sInd2;
        double result = 0.0;
        int firstIndex = ind1[index1];
        int secondIndex = ind2[index2];
        while (index1 < nElm1 && index2 < nElm2) {
            if (firstIndex == secondIndex) {
                result += val1[index1] * val2[index2];
                firstIndex = ind1[index1];
                secondIndex = ind2[index2];
                ++index1;
                ++index2;
                continue;
            }
            if (firstIndex < secondIndex) {
                firstIndex = ind1[index1];
                ++index1;
                continue;
            }
            secondIndex = ind2[index2];
            ++index2;
        }
        return result;
    }

    void quadraticOuterProduct(DenseSymMatrix outSym) {
        int minSize = this.getMinVecSize();
        if (outSym.getNRows() < minSize) {
            outSym.setNRows(minSize);
        } else {
            outSym.clear();
        }
        for (int i = 0; i < this.nElements; ++i) {
            double val1 = this.svValues[i];
            for (int j = 0; j <= i; ++j) {
                double product = val1 * this.svValues[j];
                outSym.setElem(this.svIndices[i], this.svIndices[j], product);
            }
        }
    }

    void quadraticOuterProductIncr(DenseSymMatrix outSym, double coeff) {
        int minSize = this.getMinVecSize();
        if (outSym.getNRows() < minSize) {
            outSym.setNRows(minSize);
        }
        for (int i = 0; i < this.nElements; ++i) {
            double val1 = this.svValues[i];
            int index1 = this.svIndices[i];
            for (int j = 0; j <= i; ++j) {
                int index2 = this.svIndices[j];
                double product = val1 * this.svValues[j];
                double oldValue = outSym.getElem(index1, index2);
                outSym.setElem(index1, index2, oldValue + product * coeff);
            }
        }
    }

    void quadraticOuterProductIncr(DenseSymMatrix outSym) {
        this.quadraticOuterProductIncr(outSym, 1.0);
    }

    boolean quadraticOuterProductPartIncr(DenseSymMatrix outSym, int offset, double coeff) {
        boolean result = false;
        int minSize = this.getMinVecSize();
        int nRows = outSym.getNRows();
        if (offset >= 0 && offset + minSize <= nRows) {
            result = true;
            for (int i = 0; i < this.nElements; ++i) {
                double val1 = this.svValues[i];
                int index1 = offset + this.svIndices[i];
                for (int j = 0; j <= i; ++j) {
                    int index2 = offset + this.svIndices[j];
                    double product = val1 * this.svValues[j];
                    double oldValue = outSym.getElem(index1, index2);
                    outSym.setElem(index1, index2, oldValue + product * coeff);
                }
            }
        }
        return result;
    }

    boolean quadraticOuterProductPartIncr(DenseSymMatrix outSym, int offset) {
        return this.quadraticOuterProductPartIncr(outSym, offset, 1.0);
    }

    boolean quadraticOuterProductPartIncr(DenseSymMatrix outSym) {
        return this.quadraticOuterProductPartIncr(outSym, 0, 1.0);
    }

    boolean incrementRowPart(DenseSymMatrix outSym, int iRow, int offset, double coeff) {
        boolean result = false;
        int minSize = this.getMinVecSize();
        int nRows = outSym.getNRows();
        if (iRow >= 0 && iRow < nRows && offset >= 0 && offset + minSize <= nRows) {
            result = true;
            for (int iElm = 0; iElm < this.nElements; ++iElm) {
                int index = offset + this.svIndices[iElm];
                double oldValue = outSym.getElem(iRow, index);
                outSym.setElem(iRow, index, oldValue + this.svValues[iElm] * coeff);
            }
        }
        return result;
    }

    boolean incrementRowPart(DenseSymMatrix outSym, int iRow, int offset) {
        return this.incrementRowPart(outSym, iRow, offset, 1.0);
    }

    boolean computeProbabilities(double[] beta, int nCats, int nPar1, double[] vProb, double[] lpLog) {
        boolean result;
        int minSize = this.getMinVecSize();
        boolean bl = result = nCats > 0 && nPar1 > 0 && beta.length >= nPar1 * (nCats - 1) && nPar1 >= minSize && vProb.length >= nCats;
        if (result) {
            int iCat;
            double maxExp = 709.78;
            double minExp = -744.44;
            int offset = 0;
            double[] dps = new double[nCats - 1];
            double dpMax = -1.7976931348623157E308;
            double dpMin = Double.MAX_VALUE;
            for (iCat = 0; iCat < nCats - 1; ++iCat) {
                double dp = this.innerProductWithPart(beta, offset);
                offset += nPar1;
                if (dp > dpMax) {
                    dpMax = dp;
                }
                if (dp < dpMin) {
                    dpMin = dp;
                }
                dps[iCat] = dp;
            }
            if (nCats > 1 && dpMax > dpMin) {
                double prob;
                int shift = (int)(dpMax - maxExp);
                if (dpMax <= maxExp) {
                    if (dpMin >= minExp) {
                        shift = 0;
                    } else {
                        int expDiff = (int)(dpMin - minExp);
                        if (shift < expDiff) {
                            shift = expDiff;
                        }
                    }
                }
                double denom = 0.0;
                double expArg = -dpMax;
                if (expArg >= minExp) {
                    denom += Math.exp(expArg);
                }
                for (iCat = 0; iCat < nCats - 1; ++iCat) {
                    expArg = dps[iCat] - dpMax;
                    if (!(expArg >= minExp)) continue;
                    denom += Math.exp(expArg);
                }
                double shLog = dpMax - (double)shift + Math.log(denom);
                for (iCat = 0; iCat < nCats - 1; ++iCat) {
                    expArg = dps[iCat] - (double)shift - shLog;
                    prob = expArg >= minExp ? Math.exp(expArg) : 0.0;
                    vProb[iCat] = prob;
                }
                expArg = (double)(-shift) - shLog;
                prob = expArg >= minExp ? Math.exp(expArg) : 0.0;
                vProb[nCats - 1] = prob;
                lpLog[0] = expArg;
            } else if (nCats > 1 && dpMax == dpMin) {
                double lastProb;
                double prob;
                if (dpMax > maxExp) {
                    prob = 1.0 / (double)(nCats - 1);
                    lastProb = 0.0;
                    lpLog[0] = -dpMax - Math.log(nCats - 1);
                } else if (dpMax < minExp) {
                    prob = 0.0;
                    lastProb = 1.0;
                    lpLog[0] = 0.0;
                } else {
                    double exp1 = Math.exp(dpMax);
                    double denom = 1.0 + (double)(nCats - 1) * exp1;
                    prob = exp1 / denom;
                    lastProb = 1.0 / denom;
                    lpLog[0] = -Math.log(denom);
                }
                for (iCat = 0; iCat < nCats - 1; ++iCat) {
                    vProb[iCat] = prob;
                }
                vProb[nCats - 1] = lastProb;
            } else {
                vProb[0] = 1.0;
                lpLog[0] = 0.0;
            }
        }
        return result;
    }
}

