/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");

    @Override
    public String getHead(Handler handler) {
        return "<log>\n";
    }

    @Override
    public String getTail(Handler handler) {
        return "</log>";
    }

    @Override
    public String format(LogRecord logRecord) {
        String messageThrowableString = LogFormatter.getMessageThrowableString(logRecord);
        Level level = logRecord.getLevel();
        long timestamp = logRecord.getMillis();
        return String.format("<event level=\"%s\" timestamp=\"%s\"><![CDATA[%s]]></event>%n", level, this.dateFormat.format(new Date(timestamp)), messageThrowableString);
    }

    private static String getMessageThrowableString(LogRecord logRecord) {
        Throwable throwable;
        StringBuilder sb = new StringBuilder();
        String message = logRecord.getMessage();
        if (message != null) {
            sb.append(message);
        }
        if ((throwable = logRecord.getThrown()) != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            if (message != null) {
                sb.append("\n");
            }
            sb.append(stringWriter.toString());
        }
        return sb.toString();
    }
}

