/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.util;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorClient;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACMessageKeys;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACRuntimeException;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.util.SOAPUtility;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.message.SOAPHeaderElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BiBusHeaderUtility {
    public static final QName BI_BUS_HEADER_QNAME = new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");

    public static BiBusHeader getBiBusHeader(SOAPHeaderElement soapHeaderElement) {
        try {
            return (BiBusHeader)soapHeaderElement.getValueAsType(BI_BUS_HEADER_QNAME);
        }
        catch (Exception e) {
            AggregateAdvisorClient.getLogger().log(Level.SEVERE, String.format("Failed to get the BiBusHeader from Axis: soapHeaderElement=%s", soapHeaderElement), e);
            throw AACRuntimeException.wrap(AACMessageKeys.GEN_FailedToGetBiBusHeaderFromAxis, e);
        }
    }

    public static javax.xml.soap.SOAPHeaderElement getBiBusHeaderElement(SOAPMessage message) throws SOAPException {
        SOAPHeader soapHeader;
        if (message != null && (soapHeader = message.getSOAPHeader()) != null) {
            Iterator soapHeaderElementIterator = soapHeader.examineAllHeaderElements();
            while (soapHeaderElementIterator.hasNext()) {
                javax.xml.soap.SOAPHeaderElement soapHeaderElement = (javax.xml.soap.SOAPHeaderElement)soapHeaderElementIterator.next();
                Name soapHeaderElementName = soapHeaderElement.getElementName();
                String soapHeaderElementURI = soapHeaderElementName.getURI();
                String soapHeaderElementLocalName = soapHeaderElementName.getLocalName();
                if (!BI_BUS_HEADER_QNAME.getNamespaceURI().equals(soapHeaderElementURI) || !BI_BUS_HEADER_QNAME.getLocalPart().equals(soapHeaderElementLocalName)) continue;
                return soapHeaderElement;
            }
        }
        return null;
    }

    public static javax.xml.soap.SOAPHeaderElement getBiBusHeaderElement(BiBusHeader biBusHeader) throws SOAPException {
        String biBusHeaderString;
        Document document;
        SOAPMessage soapMessage = SOAPUtility.createMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        javax.xml.soap.SOAPHeaderElement biBusHeaderElement = soapHeader.addHeaderElement(soapEnvelope.createName(BI_BUS_HEADER_QNAME.getLocalPart(), BI_BUS_HEADER_QNAME.getPrefix(), BI_BUS_HEADER_QNAME.getNamespaceURI()));
        if (biBusHeader != null && (document = BiBusHeaderUtility.parseBiBusHeader(biBusHeaderString = BiBusHeaderUtility.serializeBiBusHeader(biBusHeader))) != null) {
            NodeList docNodes = document.getChildNodes();
            NodeList nodes = null;
            if (docNodes.getLength() == 1) {
                Node node = docNodes.item(0);
                nodes = node.getChildNodes();
            } else {
                nodes = docNodes;
            }
            int numNodes = nodes.getLength();
            for (int i = 0; i < numNodes; ++i) {
                Node node = nodes.item(0);
                biBusHeaderElement.getOwnerDocument().adoptNode(node);
                biBusHeaderElement.appendChild(node);
            }
        }
        return biBusHeaderElement;
    }

    public static String serializeBiBusHeader(BiBusHeader biBusHeader) {
        if (biBusHeader == null) {
            return null;
        }
        StringWriter biBusHeaderStringWriter = new StringWriter();
        SerializationContext serializationContext = new SerializationContext((Writer)biBusHeaderStringWriter);
        Serializer serializer = BiBusHeader.getSerializer((String)BiBusHeader.class.getName(), BiBusHeader.class, (QName)BI_BUS_HEADER_QNAME);
        try {
            serializer.serialize(BI_BUS_HEADER_QNAME, null, (Object)biBusHeader, serializationContext);
        }
        catch (Exception e) {
            AggregateAdvisorClient.getLogger().log(Level.SEVERE, String.format("Failed to serialize the BiBusHeader: %s", biBusHeader), e);
            throw AACRuntimeException.wrap(AACMessageKeys.GEN_FailedSerializeBiBusHeader, e);
        }
        return biBusHeaderStringWriter.toString();
    }

    private static Document parseBiBusHeader(String biBusHeaderString) {
        Document document;
        if (biBusHeaderString == null || biBusHeaderString.length() == 0) {
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new ByteArrayInputStream(biBusHeaderString.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            AggregateAdvisorClient.getLogger().log(Level.SEVERE, String.format("Failed to parse the BiBusHeader: %s", biBusHeaderString), e);
            throw AACRuntimeException.wrap(AACMessageKeys.GEN_FailedParseBiBusHeader, e);
        }
        return document;
    }
}

