/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.AdaptorMethodOverride;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class TeradataResultSetAdaptor
extends BaseResultSetAdaptor {
    private static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final int MILLISECONDS_PER_MINUTE = 60000;

    public TeradataResultSetAdaptor(ResultSet rs, AdaptorFactory factory) {
        super(rs, factory);
    }

    @AdaptorMethodOverride
    public String getExtendedData(int type, int column) throws SQLException {
        if (type != -1001 && type != -1002) {
            return super.getExtendedData(type, column);
        }
        GregorianCalendar cal = new GregorianCalendar();
        String s = null;
        String ns = "";
        if (type == -1001) {
            Timestamp ts = this.getResultSet().getTimestamp(column, (Calendar)cal);
            if (ts == null) {
                return null;
            }
            s = ts.toString();
        } else {
            Time t = this.getResultSet().getTime(column, (Calendar)cal);
            if (t == null) {
                return null;
            }
            long nanoseconds = t.getTime() % 1000L * 1000000L;
            if (nanoseconds > 0L) {
                ns = String.format(".%1$09d", nanoseconds);
            }
            s = t.toString();
        }
        s = s + ns + this.convertTimeZoneToString(cal);
        return s;
    }

    public String convertTimeZoneToString(Calendar value) {
        StringBuilder b = new StringBuilder();
        int hour = value.get(15) / 3600000;
        int minute = Math.abs(value.get(15) % 3600000 / 60000);
        if (hour < 0) {
            hour = -hour;
            b.append("-");
        } else {
            b.append("+");
        }
        DecimalFormat f = new DecimalFormat("00");
        b.append(f.format(hour) + ":" + f.format(minute));
        return b.toString();
    }

    private ResultSet getResultSet() {
        return this.rs;
    }

    public static class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new TeradataResultSetAdaptor((ResultSet)toWrap, factory);
        }
    }
}

