/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.microsoft.sqlserver.jdbc.cognos.adaptor.SQLServerDatabaseMetadataAdaptor;
import com.microsoft.sqlserver.jdbc.cognos.adaptor.SQLServerMetadataMapper;
import com.microsoft.sqlserver.jdbc.cognos.adaptor.SQLServerSubtype;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.regex.Pattern;

public class SQLServerDriverSqlserverAdaptorFactory
extends AdaptorFactory {
    private static volatile AbstractPropertyLoader propertyLoader;
    SQLServerSubtype serverType;

    protected void setPropertyLoader(AbstractPropertyLoader loader) {
        propertyLoader = loader;
    }

    public AbstractPropertyLoader getPropertyLoader() {
        return propertyLoader;
    }

    protected void registerWrappers() {
        this.setDatabaseMetadataWrapper(new SQLServerDatabaseMetadataAdaptor.Wrapper());
        this.setMetadataMapper(new SQLServerMetadataMapper(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(Driver driver, String url, Properties driverProperties, Properties ibmCognosProperties) throws SQLException {
        Connection connection;
        block9: {
            connection = null;
            this.serverType = SQLServerSubtype.SQLSERVER;
            connection = driver.connect(url, driverProperties);
            try (Statement st = null;){
                st = connection.createStatement();
                st.execute("select @@version");
                ResultSet rs = st.getResultSet();
                String version = null;
                if (rs != null) {
                    while (rs.next()) {
                        version = rs.getString(1);
                    }
                    rs.close();
                }
                if (version == null) break block9;
                for (SQLServerSubtype sqlType : SQLServerSubtype.values()) {
                    Pattern p = Pattern.compile(sqlType.typeName(), 2);
                    if (!p.matcher(version).find()) continue;
                    this.serverType = sqlType;
                    break;
                }
            }
        }
        return connection;
    }

    protected void determineSubType(Connection connection) throws SQLException {
        if (this.serverType != SQLServerSubtype.SQLSERVER) {
            this.setSubType(this.serverType.name().toLowerCase());
        } else {
            super.determineSubType(connection);
        }
    }
}

