/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BibusSoapAction {
    public static BibusSoapAction Unknown = new BibusSoapAction(null);
    private static final String LOCAL_ROUTING_PREFIX = "local.";
    private String soapAction;
    private String version;
    private String service;
    private String affinity;
    private Format format;
    private String routing;

    public BibusSoapAction(String s) {
        this.format = Format.Unknown;
        if (s == null || s.length() == 0) {
            this.soapAction = s;
            return;
        }
        if (s.length() >= 2) {
            s = BibusSoapAction.stripQuotes(s);
        }
        this.soapAction = s;
        s = this.stripRouting(s);
        for (Format f : Format.values()) {
            String base;
            if (f == Format.Unknown || !s.startsWith(base = f.getBaseURL())) continue;
            s = s.substring(base.length());
            if (!f.handler.parse(this, s)) continue;
            this.format = f;
            return;
        }
    }

    private String stripRouting(String s) {
        if (s.startsWith(LOCAL_ROUTING_PREFIX)) {
            int i = LOCAL_ROUTING_PREFIX.length();
            this.routing = LOCAL_ROUTING_PREFIX.substring(0, i - 1);
            s = s.substring(i);
        }
        return s;
    }

    public BibusSoapAction(Format f, String service, String version) {
        if (f == Format.Unknown) {
            throw new IllegalArgumentException("Unsupported format");
        }
        this.format = f;
        this.service = service;
        this.version = version;
    }

    private static String stripQuotes(String s) {
        char ch = s.charAt(0);
        if ((ch == '\'' || ch == '\"') && s.charAt(s.length() - 1) == ch) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String getBaseURL() {
        return this.format.getBaseURL();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String s) {
        this.version = s;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String s) {
        this.service = s;
    }

    public String getAffinity() {
        return this.affinity;
    }

    public void setAffinity(String s) {
        this.affinity = s;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getRouting() {
        return this.routing;
    }

    public void setRouting(String v) {
        this.routing = v;
    }

    public String getOriginalAction() {
        return this.soapAction;
    }

    public String toString() {
        if (this.format == Format.Unknown) {
            return this.soapAction == null ? "" : this.soapAction;
        }
        StringBuilder buf = new StringBuilder();
        if (this.routing != null) {
            buf.append(this.routing).append('.');
        }
        buf.append(this.format.getBaseURL());
        this.format.handler.format(this, buf);
        return buf.toString();
    }

    private static class ColoradoFormat
    extends FormatHandler {
        private static final Pattern pat = Pattern.compile(ColoradoFormat.join("([\\w\\-\\.]+)", "/", "(\\d+|\\*)", "(?:\\.([a-zA-Z]+))?"));

        private ColoradoFormat() {
        }

        @Override
        public boolean parse(BibusSoapAction action, String s) {
            Matcher m = pat.matcher(s);
            if (!m.matches()) {
                return false;
            }
            action.service = m.group(1);
            action.version = m.group(2);
            action.affinity = m.group(3);
            return true;
        }

        @Override
        public void format(BibusSoapAction action, StringBuilder buf) {
            buf.append(action.service).append('/').append(action.version);
            if (action.affinity != null) {
                buf.append('.').append(action.affinity);
            }
        }
    }

    private static class IBMFormat
    extends FormatHandler {
        private static final Pattern pat = Pattern.compile(IBMFormat.join("([\\w\\-\\.]+)", "/", "(\\d+|\\*)", "/", "(?:\\.([a-zA-Z]+))?"));

        private IBMFormat() {
        }

        @Override
        boolean parse(BibusSoapAction action, String s) {
            Matcher m = pat.matcher(s);
            if (!m.matches()) {
                return false;
            }
            action.service = m.group(1);
            action.version = m.group(2);
            action.affinity = m.group(3);
            return true;
        }

        @Override
        void format(BibusSoapAction action, StringBuilder buf) {
            buf.append(action.service).append('/').append(action.version).append('/');
            if (action.affinity != null) {
                buf.append('.').append(action.affinity);
            }
        }
    }

    private static class BalticFormat
    extends FormatHandler {
        private static final Pattern pat = Pattern.compile(BalticFormat.join("(\\d+|\\*)", "#", "([\\w\\-\\.]+)", "(?:\\.([a-zA-Z]+))?"));

        private BalticFormat() {
        }

        @Override
        boolean parse(BibusSoapAction action, String s) {
            Matcher m = pat.matcher(s);
            if (!m.matches()) {
                return false;
            }
            action.service = m.group(2);
            action.version = m.group(1);
            action.affinity = m.group(3);
            return true;
        }

        @Override
        void format(BibusSoapAction action, StringBuilder buf) {
            buf.append(action.version).append('#').append(action.service);
            if (action.affinity != null) {
                buf.append('.').append(action.affinity);
            }
        }
    }

    private static abstract class FormatHandler {
        protected static final String reService = "([\\w\\-\\.]+)";
        protected static final String reVersion = "(\\d+|\\*)";
        protected static final String reAffinity = "(?:\\.([a-zA-Z]+))?";

        private FormatHandler() {
        }

        abstract boolean parse(BibusSoapAction var1, String var2);

        abstract void format(BibusSoapAction var1, StringBuilder var2);

        static String join(String ... args) {
            StringBuilder b = new StringBuilder();
            for (String arg : args) {
                b.append(arg);
            }
            return b.toString();
        }
    }

    public static enum Format {
        IBM("http://www.ibm.com/xmlns/prod/cognos/", new IBMFormat()),
        Baltic("http://developer.cognos.com/schemas/bibus/", new BalticFormat()),
        Colorado("http://developer.cognos.com/schemas/", new ColoradoFormat()),
        Unknown(null, null);

        private String base;
        private FormatHandler handler;

        private Format(String base, FormatHandler h) {
            this.base = base;
            this.handler = h;
        }

        public String getBaseURL() {
            return this.base;
        }
    }
}

