/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import com.ibm.cognos.internal.ombridge.BibusSoapAction;
import com.ibm.cognos.internal.ombridge.MultirefResolver;
import com.ibm.cognos.internal.ombridge.OMBridge;
import com.ibm.cognos.internal.ombridge.Signer;
import com.ibm.cognos.internal.ombridge.SignerFactory;
import com.ibm.cognos.internal.ombridge.TypeLibLocator;
import com.ibm.cognos.internal.ombridge.UserCapabilityCache;
import com.ibm.cognos.internal.ombridge.logging.Logger;
import com.ibm.cognos.internal.ombridge.schema.BuildNumber;
import com.ibm.cognos.internal.ombridge.schema.TypeLibrary;
import com.ibm.cognos.internal.ombridge.schema.TypeLibraryLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BridgeHandler {
    public static boolean BRIDGE_ACTIVATED = true;
    public static final String LOWEST_VERSION = "201012";
    private static int VERSION_LENGTH = 6;
    private static int minVersion = 0;
    private static int maxVersion = 0;
    public static Map<String, TypeLibrary> mapTypeLib = new ConcurrentHashMap<String, TypeLibrary>();
    private static Map<String, OMBridge> bridgeMap = new ConcurrentHashMap<String, OMBridge>();
    private static Signer signer = SignerFactory.createSigner();
    public static OutputFormat PRETTY_PRINT = BridgeHandler.createPrettyPrint();
    private static OutputFormat SIMPLE_FORMAT = new OutputFormat();
    private static TypeLibLocator typeLibLocator;
    private static String cmVersion;

    static void init() {
        typeLibLocator = TypeLibLocator.getInstance();
        BridgeHandler.initVersions();
    }

    public static List<String> getSupportedVersions() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(typeLibLocator.getVersions());
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    private static void initVersions() {
        minVersion = Integer.MAX_VALUE;
        maxVersion = Integer.MIN_VALUE;
        mapTypeLib.clear();
        ArrayList<String> versions = new ArrayList<String>();
        versions.addAll(typeLibLocator.getVersions());
        for (String v : versions) {
            if (v == null || v.length() != VERSION_LENGTH) continue;
            int n = Integer.parseInt(v);
            minVersion = Math.min(minVersion, n);
            maxVersion = Math.max(maxVersion, n);
        }
        cmVersion = Integer.toString(maxVersion);
    }

    public static String mapEditionToSoapActionVersion(String edition) {
        BuildNumber build = new BuildNumber(edition);
        if (build.compareTo(new BuildNumber(Integer.MAX_VALUE, 0, 0, 0)) > 0) {
            Logger.BRIDGE.error("Not a valid build number: " + edition + ". Assume the latest.");
        }
        List<String> versions = BridgeHandler.getSupportedVersions();
        for (String version : versions) {
            BuildNumber buildNum = typeLibLocator.getBuild(version);
            if (buildNum.compareTo(build) > 0) continue;
            Logger.BRIDGE.info("Mapping build " + edition + " to a version " + version);
            return version;
        }
        String version = versions.get(versions.size() - 1);
        Logger.BRIDGE.info("Mapping build " + edition + " to a version " + version);
        return version;
    }

    private static void initProperties() {
        Properties props = BridgeHandler.loadProperties();
        BRIDGE_ACTIVATED = "true".equalsIgnoreCase(props.getProperty("BRIDGE_ACTIVATED", "true"));
        if (!BRIDGE_ACTIVATED) {
            Logger.BRIDGE.error("WARNING: OM bridge is disabled");
        }
    }

    private static Properties loadProperties() {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = BridgeHandler.class.getClassLoader().getResourceAsStream("ombridge.properties");
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            Logger.BRIDGE.fatal("Error loading ombridge.properties file", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    public static boolean shouldBridge(String srcVersion, String dstVersion) {
        if (!BRIDGE_ACTIVATED) {
            return false;
        }
        if (srcVersion == null || dstVersion == null) {
            return false;
        }
        if (!typeLibLocator.getVersions().contains(srcVersion)) {
            Logger.BRIDGE.error("Invalid source version: " + srcVersion);
            return false;
        }
        if (!typeLibLocator.getVersions().contains(dstVersion)) {
            Logger.BRIDGE.error("Invalid target version: " + dstVersion);
            return false;
        }
        return !srcVersion.equals(dstVersion);
    }

    public static byte[] bridgeMessage(byte[] request, byte[] response, String sourceVersion, String targetVersion, boolean isRequest) {
        byte[] buf;
        byte[] byArray = buf = isRequest ? request : response;
        if (buf == null || buf.length == 0 || !BridgeHandler.shouldBridge(sourceVersion, targetVersion)) {
            return buf;
        }
        Document docBiBusEnvelope = null;
        try {
            SAXReader reader = new SAXReader();
            docBiBusEnvelope = reader.read((InputStream)new ByteArrayInputStream(buf));
        }
        catch (DocumentException e) {
            Logger.BRIDGE.error("Error parsing SOAP message", e);
            return buf;
        }
        BridgeHandler.processMessage(docBiBusEnvelope, sourceVersion, targetVersion, null);
        return BridgeHandler.getBytes(docBiBusEnvelope);
    }

    public static byte[] bridgeMessage(byte[] buf, String soapAction, String passport) {
        String dstVer = BridgeHandler.getSOAPActionVersion(soapAction);
        if (buf == null || buf.length == 0 || !BridgeHandler.shouldBridge(cmVersion, dstVer)) {
            return buf;
        }
        Document doc = null;
        try {
            SAXReader reader = new SAXReader();
            doc = reader.read((InputStream)new ByteArrayInputStream(buf));
        }
        catch (DocumentException e) {
            Logger.BRIDGE.error("Error parsing SOAP message", e);
            return buf;
        }
        BridgeHandler.processMessage(doc, cmVersion, dstVer, passport);
        return BridgeHandler.getBytes(doc);
    }

    public static boolean isMessageTrusted(byte[] buf) {
        return signer.isTrusted(buf);
    }

    public static byte[] setMessageTrust(byte[] msg, String serviceID) {
        return signer.setMessageTrust(msg, serviceID);
    }

    public static void processMessage(Document doc, String srcVersion, String dstVersion, String passportId) {
        if (!BRIDGE_ACTIVATED) {
            return;
        }
        OMBridge bridge = BridgeHandler.getOMBridge(srcVersion, dstVersion);
        MultirefResolver.resolve(doc);
        UserCapabilityCache ucCache = new UserCapabilityCache(bridge.getTargetLibrary());
        ucCache.verify(doc, passportId);
        bridge.bridge(doc);
        ucCache.sign(doc, passportId);
    }

    private static OMBridge getOMBridge(String sourceVersion, String targetVersion) {
        String version = sourceVersion + "_" + targetVersion;
        OMBridge bridge = bridgeMap.get(version);
        if (bridge == null) {
            TypeLibrary srcLib = BridgeHandler.getLib(sourceVersion);
            TypeLibrary dstLib = BridgeHandler.getLib(targetVersion);
            bridge = new OMBridge(srcLib, dstLib);
            bridgeMap.putIfAbsent(version, bridge);
        }
        return bridge;
    }

    public static String getSOAPActionVersion(String soapAction) {
        BibusSoapAction action = new BibusSoapAction(soapAction);
        if (action.getFormat() == BibusSoapAction.Format.Unknown) {
            return null;
        }
        if (action.getFormat() != BibusSoapAction.Format.IBM) {
            return LOWEST_VERSION;
        }
        String version = action.getVersion();
        return version;
    }

    private static OutputFormat createPrettyPrint() {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        format.setIndent(true);
        format.setIndentSize(4);
        format.setSuppressDeclaration(true);
        format.setTrimText(true);
        format.setExpandEmptyElements(false);
        return format;
    }

    private static byte[] getBytes(Document doc) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)baos, SIMPLE_FORMAT);
            writer.write(doc);
            writer.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            Logger.BRIDGE.error("Error converting document to byte array", e);
            return null;
        }
    }

    private static TypeLibrary getLib(String version) {
        TypeLibrary typeLib = mapTypeLib.get(version);
        if (typeLib == null) {
            typeLib = BridgeHandler.loadTypeLib(version);
        }
        return typeLib;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TypeLibrary loadTypeLib(String version) {
        try (InputStream stream = typeLibLocator.getStream(version);){
            TypeLibraryLoader loader = new TypeLibraryLoader();
            TypeLibrary typeLib = loader.load(stream);
            String v = typeLib.getVersion();
            if (v == null) return null;
            if (v.length() != VERSION_LENGTH) return null;
            TypeLibrary oldLib = mapTypeLib.putIfAbsent(v, typeLib);
            Logger.BRIDGE.info("Adding type library: " + v);
            TypeLibrary typeLibrary = oldLib == null ? typeLib : oldLib;
            return typeLibrary;
        }
        catch (Exception e) {
            Logger.BRIDGE.fatal("Exception when loading TypeLibrary: " + e);
        }
        return null;
    }

    static {
        BridgeHandler.initProperties();
        BridgeHandler.init();
    }
}

