/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import com.ibm.cognos.internal.ombridge.Signer;
import com.ibm.cognos.internal.ombridge.logging.Logger;

public class CAMSigner
implements Signer {
    private static CAMFactory camFactory;

    @Override
    public byte[] createTrustToken(byte[] txt, String passportId) {
        if (camFactory == null) {
            return null;
        }
        try {
            GenericTrustedSession trustedSession = camFactory.createGenericTrustedSession();
            return trustedSession.createTrustToken(txt, passportId);
        }
        catch (CAMCryptoException e) {
            Logger.BRIDGE.error("Error creating trust token", e);
            return null;
        }
    }

    @Override
    public boolean verifyTrustToken(byte[] txt, byte[] signature, String passportId) {
        if (camFactory == null) {
            return false;
        }
        try {
            GenericTrustedSession trustedSession = camFactory.createGenericTrustedSession();
            return passportId == null ? trustedSession.verifyTrustToken(signature, txt) : trustedSession.verifyTrustToken(signature, txt, passportId);
        }
        catch (CAMCryptoException e) {
            Logger.BRIDGE.error("Error verifying trust token", e);
            return false;
        }
    }

    @Override
    public byte[] setMessageTrust(byte[] txt, String serviceId) {
        if (camFactory == null) {
            return null;
        }
        try {
            TrustedRequestSession trustedRequestSession = camFactory.createTrustedSession();
            return trustedRequestSession.setMessageTrust(serviceId, txt);
        }
        catch (CAMCryptoException e) {
            Logger.BRIDGE.error("Error signing trusted request", e);
            return null;
        }
    }

    @Override
    public boolean isTrusted(byte[] txt) {
        if (camFactory == null) {
            return false;
        }
        try {
            TrustedRequestSession trustedRequestSession = camFactory.createTrustedSession();
            return trustedRequestSession.isTrusted(txt);
        }
        catch (CAMCryptoException e) {
            Logger.BRIDGE.error("Error verifying trusted request", e);
            return false;
        }
    }

    static {
        try {
            camFactory = new CAMFactory();
            camFactory.initialize("<initializeDocument><serviceID>Bridge</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoException e) {
            Logger.BRIDGE.error("Error initializing CAM factory", e);
            camFactory = null;
        }
    }
}

