/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import com.ibm.cognos.internal.ombridge.BridgeHandler;
import com.ibm.cognos.internal.ombridge.TypeLibLocator;
import com.ibm.cognos.internal.ombridge.TypeLibMetadata;
import com.ibm.cognos.internal.ombridge.logging.Logger;
import com.ibm.cognos.internal.ombridge.schema.BuildNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarLocator
extends TypeLibLocator {
    protected HashMap<String, TypeLibMetadata> metadataMap = new HashMap();
    private static String classesPath;

    JarLocator() {
        this(BridgeHandler.class.getClassLoader().getResource("ombridge.properties"));
    }

    JarLocator(URL url) {
        classesPath = JarLocator.getClassesFile(url);
        this.initVersions();
    }

    static String getClassesFile(URL dirURL) {
        String path = dirURL.getPath();
        String jarFileNamePath = path.substring(5, path.indexOf(33));
        return jarFileNamePath;
    }

    private void initVersions() {
        try (JarFile jar = new JarFile(URLDecoder.decode(classesPath, "UTF-8"));){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!JarLocator.isTypeLibFile(name).booleanValue()) continue;
                String version = JarLocator.extractVersion(name);
                try {
                    InputStream stream = JarLocator.class.getClassLoader().getResourceAsStream(name);
                    Throwable throwable = null;
                    try {
                        String buildNum = this.getBuildNumber(stream);
                        TypeLibMetadata meta = new TypeLibMetadata(name, new BuildNumber(buildNum));
                        this.metadataMap.put(version, meta);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Exception e) {
                    System.out.print(e);
                }
            }
        }
        catch (IOException e) {
            Logger.BRIDGE.fatal("Unable to read file " + classesPath + ": " + e.toString());
        }
    }

    @Override
    public Collection<String> getVersions() {
        return this.metadataMap.keySet();
    }

    @Override
    public InputStream getStream(String version) {
        InputStream returnStream = JarLocator.class.getClassLoader().getResourceAsStream(this.metadataMap.get(version).getFileName());
        return returnStream;
    }

    @Override
    public BuildNumber getBuild(String version) {
        return this.metadataMap.get(version).getBuild();
    }
}

