/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import java.util.HashMap;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class MultirefResolver {
    private static final Namespace SOAPENC_NS = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final QName SOAPENC_ROOT = QName.get((String)"root", (Namespace)SOAPENC_NS);
    private HashMap<String, Element> ids;
    private HashMap<String, Element> idsResolved;

    private void doResolve(Element elRoot) {
        this.findIDs(elRoot.element("Header"));
        this.findIDs(elRoot.element("Body"));
        if (this.ids == null) {
            return;
        }
        this.resolveHref(elRoot);
        if (this.idsResolved.size() > 0) {
            for (Element elMultiRef : this.idsResolved.values()) {
                elMultiRef.detach();
            }
        }
    }

    private void findIDs(Element el) {
        if (el == null || el.elements() == null) {
            return;
        }
        for (Element e : el.elements()) {
            String id = e.attributeValue("id");
            if (id == null || id.length() == 0) continue;
            if (this.ids == null) {
                this.ids = new HashMap();
                this.idsResolved = new HashMap();
            }
            this.ids.put(id, e);
        }
    }

    public static void resolve(Document doc) {
        Element elRoot = doc.getRootElement();
        if (!elRoot.getName().equals("Envelope")) {
            return;
        }
        MultirefResolver resolver = new MultirefResolver();
        resolver.doResolve(elRoot);
    }

    private void resolveHref(Element el) {
        for (Element child : el.elements()) {
            this.resolveHref(child);
        }
        Attribute attrHref = el.attribute("href");
        if (attrHref == null) {
            return;
        }
        String href = attrHref.getText();
        if (href == null || href.length() < 2 || !href.startsWith("#")) {
            return;
        }
        String id = href.substring(1);
        Element elId = this.resolveMultiref(id);
        if (elId == null) {
            return;
        }
        MultirefResolver.copyContent(elId, el);
        el.remove(attrHref);
    }

    private static void copyContent(Element from, Element to) {
        to.clearContent();
        for (Node node : from.content()) {
            to.add((Node)node.clone());
        }
        for (Attribute attr : from.attributes()) {
            QName name = attr.getQName();
            if (name.getName().equals("id") || name.equals((Object)SOAPENC_ROOT)) continue;
            to.add((Attribute)attr.clone());
        }
    }

    private Element resolveMultiref(String id) {
        Element elId = this.idsResolved.get(id);
        if (elId != null) {
            return elId;
        }
        elId = this.ids.get(id);
        if (elId == null) {
            return null;
        }
        for (Element el : elId.elements()) {
            this.resolveHref(el);
        }
        this.idsResolved.put(id, elId);
        return elId;
    }
}

