/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge;

import com.ibm.cognos.internal.ombridge.BridgeHandler;
import com.ibm.cognos.internal.ombridge.FolderLocator;
import com.ibm.cognos.internal.ombridge.JarLocator;
import com.ibm.cognos.internal.ombridge.logging.Logger;
import com.ibm.cognos.internal.ombridge.schema.BuildNumber;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TypeLibLocator {
    public abstract BuildNumber getBuild(String var1);

    public abstract Collection<String> getVersions();

    public abstract InputStream getStream(String var1) throws FileNotFoundException;

    public static TypeLibLocator getInstance() {
        URL dirURL = BridgeHandler.class.getClassLoader().getResource("ombridge.properties");
        if (dirURL == null) {
            Logger.BRIDGE.fatal("Unable to locate ombridge.properties.");
            return null;
        }
        if (dirURL != null && dirURL.getProtocol().contains("jar")) {
            return new JarLocator();
        }
        return new FolderLocator();
    }

    protected static String extractVersion(String name) {
        return name.substring(name.indexOf("ombridge_types_") + 15, name.indexOf(".xml"));
    }

    protected static Boolean isTypeLibFile(String name) {
        return name.contains("ombridge_types_");
    }

    protected String getBuildNumber(InputStream stream) {
        Scanner s = new Scanner(stream);
        Pattern p = Pattern.compile("build=\"([^\"]*)\"");
        while (s.hasNext()) {
            String line = s.nextLine();
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            s.close();
            return m.group(1);
        }
        s.close();
        return null;
    }
}

