/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge.logging;

import com.ibm.cognos.internal.ombridge.logging.DefaultLogger;
import com.ibm.cognos.internal.ombridge.logging.IPFLogger;
import java.util.HashMap;

public abstract class BridgeLogger {
    public static final String LOGGER_PROPERTY = "com.ibm.cognos.internal.ombridge.logging.ipf";
    public static final String USE_IPF_LOGGER = "true";
    private static HashMap<Integer, Integer> threadRequestID = new HashMap(Thread.activeCount());
    protected static int nextRequestID = 1;

    static BridgeLogger getInstance(String name) {
        BridgeLogger logger = null;
        String useIPF = System.getProperty(LOGGER_PROPERTY, USE_IPF_LOGGER);
        logger = useIPF.equalsIgnoreCase(USE_IPF_LOGGER) ? new IPFLogger(name) : new DefaultLogger(name);
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getRequestID() {
        HashMap<Integer, Integer> hashMap = threadRequestID;
        synchronized (hashMap) {
            Integer threadID = new Integer(Thread.currentThread().hashCode());
            Integer requestID = threadRequestID.get(threadID);
            if (requestID != null) {
                return Integer.toString(requestID);
            }
            threadRequestID.put(threadID, new Integer(nextRequestID));
            return Integer.toString(nextRequestID++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseRequestId() {
        HashMap<Integer, Integer> hashMap = threadRequestID;
        synchronized (hashMap) {
            threadRequestID.remove(new Integer(Thread.currentThread().hashCode()));
        }
    }

    protected static String addRequestID(String s) {
        StringBuffer entry = new StringBuffer(s.length() + 13);
        entry.append("[");
        entry.append(BridgeLogger.getRequestID());
        entry.append("] ");
        entry.append(s);
        return entry.toString();
    }

    public abstract void debug(String var1);

    public abstract void info(String var1);

    public abstract void warn(String var1);

    public abstract void error(String var1);

    public abstract void error(Throwable var1);

    public abstract void error(String var1, Throwable var2);

    public abstract void fatal(String var1);

    public abstract void fatal(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();
}

