/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.internal.ombridge.logging.BridgeLogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class IPFLogger
extends BridgeLogger {
    private static final String TRACE = "Trace.";
    private static final String AUDIT = "Audit.";
    private String componentName = "OMBRIDGE";
    private int componentVersion = 1;
    private LogTypedLogger log;
    private LogTypedLogger auditLog = null;

    public IPFLogger(String name) {
        try {
            this.log = LogTypedLogger.getInstance((String)(TRACE + name), LogTraceIndication.class);
            this.auditLog = LogTypedLogger.getInstance((String)(AUDIT + name), LogAuditIndication.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logTraceMessage(String s, int level) {
        try {
            LogTraceIndication ind = new LogTraceIndication(this.componentName, this.componentVersion);
            ind.setLevel(level);
            ind.setRequestID(IPFLogger.getRequestID());
            String msg = "<trace><![CDATA[ " + s + " ]]></trace>";
            ind.setMessage(msg);
            this.log.log((Object)ind);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logAuditMessage(String s, int level) {
        try {
            LogAuditAccessIndication ind = new LogAuditAccessIndication(this.componentName, this.componentVersion);
            ind.setLevel(level);
            ind.setRequestID(IPFLogger.getRequestID());
            ind.setErrorMessage(s);
            this.auditLog.log((Object)ind);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void debug(String s) {
        if (this.isDebugEnabled()) {
            this.logTraceMessage(s, 10000);
        }
    }

    @Override
    public void info(String s) {
        if (this.isInfoEnabled()) {
            this.logAuditMessage(s, 20000);
        }
    }

    @Override
    public void warn(String s) {
        if (this.isWarnEnabled()) {
            this.logAuditMessage(s, 30000);
        }
    }

    @Override
    public void error(String s) {
        if (this.isErrorEnabled()) {
            this.logAuditMessage(s, 40000);
        }
    }

    @Override
    public void error(Throwable t) {
        if (this.isErrorEnabled()) {
            this.logAuditMessage(this.formatMessage(null, t), 40000);
        }
    }

    @Override
    public void error(String s, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logAuditMessage(this.formatMessage(s, t), 40000);
        }
    }

    @Override
    public void fatal(String s) {
        if (this.isFatalEnabled()) {
            this.logAuditMessage(s, 50000);
        }
    }

    @Override
    public void fatal(String s, Throwable t) {
        if (this.isFatalEnabled()) {
            this.logAuditMessage(this.formatMessage(s, t), 50000);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isTraceLevelEnabled(10000);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isTraceLevelEnabled(20000);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isAuditLevelEnabled(30000);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isAuditLevelEnabled(40000);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isAuditLevelEnabled(50000);
    }

    private boolean isAuditLevelEnabled(int level) {
        try {
            return this.auditLog.isEnabled(level);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isTraceLevelEnabled(int level) {
        try {
            return this.log.isEnabled(level);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String formatMessage(String s, Throwable t) {
        StringWriter sw = new StringWriter();
        if (s != null) {
            sw.write(s);
            sw.write(": ");
        }
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static {
        try {
            LogIPFControl.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

