/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge.schema;

import com.ibm.cognos.internal.ombridge.schema.Schema;
import com.ibm.cognos.internal.ombridge.schema.Type;

public abstract class AbstractType
implements Type {
    protected final String name;
    protected AbstractType base;
    protected Schema schema;
    protected boolean hasDerived;

    public AbstractType(String name) {
        this.name = name;
    }

    @Override
    public Type baseType() {
        return this.base;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        if (this.schema != null) {
            throw new IllegalStateException("Schema redefinition.");
        }
        this.schema = schema;
    }

    @Override
    public void setBaseType(Type t) {
        if (!this.getClass().isInstance(t)) {
            throw new IllegalStateException("Invalid base type " + t.name());
        }
        if (this.base != null) {
            throw new IllegalStateException("Base type redefinition.");
        }
        this.base = (AbstractType)t;
        this.base.hasDerived = true;
    }

    @Override
    public boolean hasDerived() {
        return this.hasDerived;
    }

    @Override
    public boolean isSubclassOf(Type base) {
        for (Type t = this; t != null; t = t.baseType()) {
            if (t != base) continue;
            return true;
        }
        return false;
    }
}

