/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge.schema;

import com.ibm.cognos.internal.ombridge.schema.ArrayType;
import com.ibm.cognos.internal.ombridge.schema.EnumType;
import com.ibm.cognos.internal.ombridge.schema.PrimitiveType;
import com.ibm.cognos.internal.ombridge.schema.Schema;
import com.ibm.cognos.internal.ombridge.schema.StructType;
import com.ibm.cognos.internal.ombridge.schema.Type;
import com.ibm.cognos.internal.ombridge.schema.TypeLibrary;
import com.ibm.cognos.internal.ombridge.schema.UserCapabilityBitEncoder;
import com.ibm.cognos.internal.ombridge.schema.XSD;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class TypeLibraryLoader {
    private SAXReader saxReader = new SAXReader();
    private TypeLibrary typeLib;
    private HashMap<String, Schema> schemasByPrefix = new HashMap();

    public TypeLibrary load(Document doc) {
        String name;
        this.schemasByPrefix.clear();
        Element root = doc.getRootElement();
        String version = root.attributeValue("version");
        String build = root.attributeValue("build");
        this.typeLib = new TypeLibrary(version, build);
        for (Element el : this.elements(root)) {
            name = el.getName();
            if ("schema".equals(name)) {
                this.createSchema(el);
                continue;
            }
            if (!"misc".equals(name)) continue;
            this.createMisc(el);
        }
        for (Element el : this.elements(root)) {
            name = el.getName();
            if (!"schema".equals(name)) continue;
            this.loadTypes(el);
        }
        return this.typeLib;
    }

    public TypeLibrary load(File f) throws DocumentException {
        return this.load(this.saxReader.read(f));
    }

    public TypeLibrary load(InputStream is) throws DocumentException {
        return this.load(this.saxReader.read(is));
    }

    public TypeLibrary load(String s) throws DocumentException {
        return this.load(this.saxReader.read((Reader)new StringReader(s)));
    }

    private void loadTypes(Element el) {
        String name = el.attributeValue("name");
        Schema schema = this.typeLib.getSchemaByName(name);
        for (Element e : this.elements(el)) {
            name = e.attributeValue("name");
            Type t = schema.getType(name);
            String base = e.attributeValue("base");
            if (base != null) {
                Type baseType = this.resolveType(base);
                t.setBaseType(baseType);
            }
            if (t instanceof ArrayType) {
                this.loadArray(e, (ArrayType)t);
                continue;
            }
            if (t instanceof StructType) {
                this.loadStruct(e, (StructType)t);
                continue;
            }
            if (t instanceof EnumType) {
                this.loadEnum(e, (EnumType)t);
                continue;
            }
            if (!(t instanceof PrimitiveType)) continue;
        }
    }

    private void loadEnum(Element el, EnumType t) {
        for (Element e : this.elements(el)) {
            t.addItem(e.attributeValue("name"));
        }
    }

    private void loadStruct(Element el, StructType t) {
        String ordered = el.attributeValue("odrered");
        if (ordered != null) {
            t.setOrdered(ordered.equals("true"));
        }
        for (Element pe : this.elements(el)) {
            String name = pe.attributeValue("name");
            String type = pe.attributeValue("type");
            t.addProperty(name, this.resolveType(type), 0, 1);
        }
    }

    private void loadArray(Element el, ArrayType t) {
        String arrayType = el.attributeValue("arrayType");
        Type itemType = this.resolveType(arrayType);
        t.setItemType(itemType);
    }

    private Type resolveType(String type) {
        int p = type.indexOf(58);
        String prefix = type.substring(0, p);
        Schema schema = this.schemasByPrefix.get(prefix);
        if (schema == null) {
            throw new IllegalStateException("Unresolved type reference: " + type);
        }
        String name = type.substring(p + 1);
        Type result = schema.getType(name);
        if (result == null) {
            throw new IllegalStateException("Unresolved type reference: " + type);
        }
        return result;
    }

    private void createSchema(Element el) {
        String name = el.attributeValue("name");
        String prefix = el.attributeValue("prefix");
        Schema schema = null;
        if (name.equals("xsd")) {
            schema = XSD.instance;
        } else {
            String url = el.attributeValue("url");
            schema = new Schema(name, url);
        }
        this.schemasByPrefix.put(prefix, schema);
        this.typeLib.addSchema(schema);
        for (Element e : this.elements(el)) {
            schema.addType(this.createType(e));
        }
    }

    private List<Element> elements(Element e) {
        return e.elements();
    }

    private Type createType(Element el) {
        String name = el.attributeValue("name");
        String kind = el.getName();
        if (kind.equals("array")) {
            return new ArrayType(name);
        }
        if (kind.equals("enum")) {
            return new EnumType(name);
        }
        if (kind.equals("struct")) {
            return new StructType(name);
        }
        if (kind.equals("primitive")) {
            return new PrimitiveType(name);
        }
        throw new IllegalStateException("Unexpected element: " + el.getPath());
    }

    private void createMisc(Element eMisc) {
        String value;
        Element eItem;
        if (eMisc == null) {
            return;
        }
        List lItems = eMisc.selectNodes("./enumeration[@name='userCapabilityEnum']/item");
        if (lItems != null && lItems.size() > 0) {
            UserCapabilityBitEncoder encoder = this.typeLib.getUserCapabilityBitEncoder();
            for (Node nItem : lItems) {
                eItem = (Element)nItem;
                value = eItem.attributeValue("value");
                String bitIndex = eItem.attributeValue("bitIndex");
                encoder.addCapability(value, new Integer(bitIndex));
            }
        }
        if ((lItems = eMisc.selectNodes("./passthrough/item")) != null && lItems.size() > 0) {
            Set<String> setPassthrough = this.typeLib.getPassthrough();
            for (Node nItem : lItems) {
                eItem = (Element)nItem;
                value = eItem.getText();
                if (value.length() == 0) continue;
                setPassthrough.add(value);
            }
        }
    }
}

