/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.ombridge.schema;

import java.util.HashMap;
import java.util.List;

public class UserCapabilityBitEncoder {
    private HashMap<String, Integer> map = new HashMap();
    private int maxBitIndex = -1;

    public void addCapability(String s, Integer bitIndex) {
        this.map.put(s, bitIndex);
        this.maxBitIndex = Math.max(this.maxBitIndex, bitIndex);
    }

    public int getMaxBitIndex() {
        return this.maxBitIndex;
    }

    public String encode(List<String> capabilities, String separator) {
        if (capabilities.size() == 0 || this.maxBitIndex == -1) {
            return "0";
        }
        int n = (this.maxBitIndex >> 5) + 1;
        int[] words = new int[n];
        for (String s : capabilities) {
            Integer bit = this.map.get(s);
            if (bit == null) continue;
            int ibit = bit;
            int n2 = ibit >> 5;
            words[n2] = words[n2] | 1 << ibit;
        }
        --n;
        while (n != 0 && words[n] == 0) {
            --n;
        }
        StringBuilder buf = new StringBuilder();
        while (n != 0) {
            buf.append(Integer.toHexString(words[n]));
            buf.append(separator);
            --n;
        }
        buf.append(Integer.toHexString(words[0]));
        return buf.toString();
    }
}

