/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.datamodel;

import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableGroupBuilder;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple3;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SampleTableSelection {
    private static final Logger LOG = PredictLoggerFactory.getLogger(SampleTableSelection.class);
    final Map<String, Map<String, Integer>> sourceTableToGroup;

    public SampleTableSelection(Map<String, TableCharacteristics> tables) {
        this.sourceTableToGroup = new TableGroupBuilder(tables).buildTableGroups();
    }

    public String selectSampleTable(List<FieldCharacteristics> focusFields) {
        Set<String> focusTableIds = focusFields.stream().map(FieldCharacteristics::tables).flatMap(Collection::stream).map(TableCharacteristics::id).collect(Collectors.toSet());
        List<String> groups = this.getSuitableGroups(this.sourceTableToGroup, focusTableIds);
        if (groups.isEmpty()) {
            return focusFields.get(0).tables().get(0).id();
        }
        if (groups.size() == 1) {
            return groups.get(0);
        }
        List<Tuple3<Integer, Integer, String>> metrics = this.generateMetrics(focusTableIds, groups);
        return (String)((Tuple3)metrics.stream().sorted((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, compareMetrics(com.ibm.bi.predict.utils.Tuple3<java.lang.Integer, java.lang.Integer, java.lang.String> com.ibm.bi.predict.utils.Tuple3<java.lang.Integer, java.lang.Integer, java.lang.String> ), (Lcom/ibm/bi/predict/utils/Tuple3;Lcom/ibm/bi/predict/utils/Tuple3;)I)()).findFirst().get())._3;
    }

    private List<Tuple3<Integer, Integer, String>> generateMetrics(Set<String> focusTableIds, List<String> groups) {
        List<Tuple3<Integer, Integer, String>> metrics = groups.stream().map(g -> new Tuple3((Object)this.sumFocusTableDistance(this.sourceTableToGroup.get(g), focusTableIds), (Object)this.sumAllDistance(this.sourceTableToGroup.get(g)), g)).collect(Collectors.toList());
        return metrics;
    }

    private static int compareMetrics(Tuple3<Integer, Integer, String> a, Tuple3<Integer, Integer, String> b) {
        int v = ((Integer)a._1).compareTo((Integer)b._1);
        if (v != 0) {
            return v;
        }
        v = ((Integer)a._2).compareTo((Integer)b._2);
        if (v != 0) {
            return v;
        }
        return ((String)a._3).compareTo((String)b._3);
    }

    private List<String> getSuitableGroups(Map<String, Map<String, Integer>> sourceTableToGroup, Set<String> focusTableIds) {
        return sourceTableToGroup.entrySet().stream().filter(v -> ((Map)v.getValue()).keySet().containsAll(focusTableIds)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private int sumAllDistance(Map<String, Integer> groupDistances) {
        return groupDistances.values().stream().mapToInt(Integer::intValue).sum();
    }

    private int sumFocusTableDistance(Map<String, Integer> groupDistances, Set<String> focusTables) {
        return focusTables.stream().mapToInt(groupDistances::get).sum();
    }

    private List<String> getGroupMembers(Map<String, Map<String, Integer>> sourceTableToGroup, String groupID) {
        return sourceTableToGroup.getOrDefault(groupID, Collections.emptyMap()).keySet().stream().collect(Collectors.toList());
    }
}

