/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.datamodel;

import com.ibm.bi.predict.explore.frf.datamodel.Cardinality;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;

public class TableDistance {
    public static final TableDistance SAME_TABLE = new TableDistance(0, 0, 0, 0);
    private final int separation;
    private final int oneToManyCount;
    private final int manyToOneCount;
    private final int manyToManyCount;

    public static boolean isBetter(TableDistance a, TableDistance b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        int d = a.manyToManyCount + a.oneToManyCount - (b.manyToManyCount + b.oneToManyCount);
        if (d != 0) {
            return d < 0;
        }
        d = a.manyToOneCount - b.manyToOneCount;
        if (d != 0) {
            return d < 0;
        }
        return a.separation < b.separation;
    }

    static TableDistance makeForRelationship(TableCharacteristics relatedTable, Cardinality cardinality) {
        if (relatedTable.joinInfo() == null) {
            return null;
        }
        int oneToManyCount = relatedTable.oneToManyCount();
        int manyToOneCount = relatedTable.manyToOneCount();
        int manyToManyCount = relatedTable.manyToManyCount();
        if (cardinality == Cardinality.ONE_TO_MANY) {
            ++oneToManyCount;
            if (manyToOneCount > 0) {
                ++manyToManyCount;
            }
        } else if (cardinality == Cardinality.MANY_TO_ONE) {
            ++manyToOneCount;
        } else if (cardinality == Cardinality.MANY_TO_MANY) {
            ++manyToManyCount;
        }
        return new TableDistance(relatedTable.separation() + 1, oneToManyCount, manyToOneCount, manyToManyCount);
    }

    public TableDistance(int separation, int oneToManyCount, int manyToOneCount, int manyToManyCount) {
        this.separation = separation;
        this.oneToManyCount = oneToManyCount;
        this.manyToOneCount = manyToOneCount;
        this.manyToManyCount = manyToManyCount;
    }

    public int separation() {
        return this.separation;
    }

    public int oneToManyCount() {
        return this.oneToManyCount;
    }

    public int manyToOneCount() {
        return this.manyToOneCount;
    }

    public int manyToManyCount() {
        return this.manyToManyCount;
    }
}

