/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.datamodel;

import com.ibm.bi.predict.explore.frf.datamodel.Cardinality;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableDistance;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

public class TableDistanceAlgorithm {
    private TableDistanceAlgorithm() {
    }

    public static void setDistances(TableCharacteristics ... baseTables) {
        TableDistanceAlgorithm.clearJoinInfo(baseTables);
        Stack<TableCharacteristics> toProcess = new Stack<TableCharacteristics>();
        for (TableCharacteristics t : baseTables) {
            if (t == null) continue;
            t.setJoinInfo(TableDistance.SAME_TABLE);
            toProcess.add(t);
        }
        while (!toProcess.isEmpty()) {
            TableCharacteristics t = (TableCharacteristics)toProcess.pop();
            for (Map.Entry<TableCharacteristics, Cardinality> e : t.relationships().entrySet()) {
                TableCharacteristics other = e.getKey();
                Cardinality otherCardinality = e.getValue();
                TableDistance newInfo = TableDistance.makeForRelationship(t, otherCardinality);
                if (!TableDistance.isBetter(newInfo, other.joinInfo())) continue;
                other.setJoinInfo(newInfo);
                toProcess.add(other);
            }
        }
    }

    static void clearJoinInfo(TableCharacteristics[] tables) {
        HashSet<TableCharacteristics> seen = new HashSet<TableCharacteristics>();
        LinkedList<TableCharacteristics> process = new LinkedList<TableCharacteristics>(Arrays.asList(tables));
        while (!process.isEmpty()) {
            TableCharacteristics t = process.pop();
            if (t == null || !seen.add(t)) continue;
            t.setJoinInfo(null);
            process.addAll(t.relationships.keySet());
        }
    }
}

