/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.datamodel;

import com.ibm.bi.predict.explore.frf.datamodel.Cardinality;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class TableGroupBuilder {
    private final Map<String, TableCharacteristics> connectedTables;

    public TableGroupBuilder(Map<String, TableCharacteristics> connectedTables) {
        this.connectedTables = connectedTables;
    }

    public Map<String, Map<String, Integer>> buildTableGroups() {
        return this.connectedTables.values().stream().collect(Collectors.toMap(TableCharacteristics::id, this::buildAlgorithmGGroup));
    }

    private Map<String, Integer> buildAlgorithmGGroup(TableCharacteristics source) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ArrayDeque<TableCharacteristics> queue = new ArrayDeque<TableCharacteristics>();
        result.put(source.id(), 0);
        queue.add(source);
        while (!queue.isEmpty()) {
            TableCharacteristics node = (TableCharacteristics)queue.remove();
            int distance = (Integer)result.get(node.id());
            node.relationships().forEach((other, cardinality) -> {
                String otherNode = other.id();
                int newDistance = distance + (TableGroupBuilder.isOutgoing(cardinality) ? 1 : 10);
                if (!result.containsKey(otherNode) || newDistance < (Integer)result.get(otherNode)) {
                    result.put(otherNode, newDistance);
                    queue.add((TableCharacteristics)other);
                }
            });
        }
        return result;
    }

    private static boolean isOutgoing(Cardinality c) {
        return c == Cardinality.MANY_TO_ONE || c == Cardinality.ONE_TO_ONE;
    }
}

