/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.framework.serialization;

import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.framework.ExpectedQueryPerformance;
import com.ibm.bi.predict.explore.frf.framework.RelevantFieldDescription;
import com.ibm.bi.predict.explore.frf.framework.RelevantFields;
import com.ibm.bi.predict.explore.frf.framework.RelevantFieldsResult;
import com.ibm.bi.predict.explore.frf.framework.RelevantFieldsSuccessResult;
import com.ibm.bi.predict.result.Message;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class RelevantFieldsResultSerializer {
    static final String VERSION = "version";
    static final String VERSION_NUMBER = "1.1";
    static final String RELEVANTFIELDS_STATUS = "predictStatus";
    static final String STATUS_STATE = "state";
    static final String STATUS_WARNINGS = "warnings";
    static final String STATUS_ERRORS = "errors";
    static final String STATUS_DIAGNOSTICS = "diagnostics";
    static final String MESSAGE_ID = "id";
    static final String MESSAGE_CAPTION = "caption";
    static final String MESSAGE_COLUMNS = "columns";
    static final String FIELD_ID = "fieldID";
    static final String FIELD_ID_FOR_EXPRESSION = "fieldIDForExpression";
    static final String TABLE_ID = "tableID";
    static final String EXPECTED_PERFORMANCE = "expectedPerformance";
    static final String FIELD_LIST = "fields";
    static final String RESULTS = "results";
    static final String RECOMMENDED_FIELDS = "recommendedFields";
    static final String ALTERNATES = "alternates";
    static final String ALL_JOINABLE_FIELDS = "allJoinableFields";

    private RelevantFieldsResultSerializer() {
    }

    public static JSONObject serialize(RelevantFieldsResult result) throws JSONException {
        JSONObject o = new JSONObject();
        o.put(VERSION, (Object)VERSION_NUMBER);
        o.put(RELEVANTFIELDS_STATUS, (Map)RelevantFieldsResultSerializer.serializeStatus(result));
        return o;
    }

    public static JSONObject addFields(RelevantFieldsSuccessResult result, JSONObject o) throws JSONException {
        RelevantFields content = (RelevantFields)result.getContent();
        JSONObject rec = new JSONObject();
        o.put(RESULTS, (Map)rec);
        rec.put(RECOMMENDED_FIELDS, (Map)RelevantFieldsResultSerializer.serializeRelevantFieldsGroup(content.recommendedFields(), content.expectedRecommendedPerformance()));
        if (result.shouldIncludeAlternateFields()) {
            rec.put(ALTERNATES, (Map)RelevantFieldsResultSerializer.serializeRelevantFieldsGroup(content.getAlternateFields(), content.expectedAlternatePerformance()));
        }
        if (result.shouldIncludeAllJoinableFields()) {
            rec.put(ALL_JOINABLE_FIELDS, (Collection)RelevantFieldsResultSerializer.serializeRelevantFieldsList(content.allJoinableFields()));
        }
        return o;
    }

    static JSONObject serializeStatus(RelevantFieldsResult result) throws JSONException {
        JSONObject o = new JSONObject();
        o.put(STATUS_STATE, (Object)result.getStatus().toString());
        JSONArray warnings = new JSONArray();
        o.put(STATUS_WARNINGS, (Collection)warnings);
        for (Object m : result.getWarningMessages()) {
            warnings.add((Object)RelevantFieldsResultSerializer.serializeMessage((Message)m));
        }
        JSONArray errors = new JSONArray();
        o.put(STATUS_ERRORS, (Collection)errors);
        for (Message m : result.getErrorMessages()) {
            errors.add((Object)RelevantFieldsResultSerializer.serializeMessage(m));
        }
        JSONArray diagnostics = new JSONArray();
        o.put(STATUS_DIAGNOSTICS, (Collection)diagnostics);
        for (String s : result.getDiagnosticMessages()) {
            diagnostics.add((Object)s);
        }
        return o;
    }

    static JSONObject serializeMessage(Message m) throws JSONException {
        JSONObject o = new JSONObject();
        o.put(MESSAGE_ID, (Object)m.getMessageCode().toString());
        o.put(MESSAGE_CAPTION, (Object)m.getCaption());
        o.put(MESSAGE_COLUMNS, (Collection)new JSONArray((Collection)m.getColumnIds()));
        return o;
    }

    static JSONObject serializeRelevantField(RelevantFieldDescription field) throws JSONException {
        JSONObject o = new JSONObject();
        FieldCharacteristics fc = field.getField();
        o.put(FIELD_ID_FOR_EXPRESSION, (Object)fc.id());
        o.put(FIELD_ID, (Object)fc.serializedName());
        if (!fc.tables().isEmpty()) {
            o.put(TABLE_ID, (Object)fc.tables().get(0).id());
        }
        return o;
    }

    static JSONArray serializeRelevantFieldsList(List<RelevantFieldDescription> fieldList) throws JSONException {
        JSONArray fields = new JSONArray();
        for (RelevantFieldDescription field : fieldList) {
            fields.add((Object)RelevantFieldsResultSerializer.serializeRelevantField(field));
        }
        return fields;
    }

    static JSONObject serializeRelevantFieldsGroup(List<RelevantFieldDescription> fieldList, ExpectedQueryPerformance performance) throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put(FIELD_LIST, (Collection)RelevantFieldsResultSerializer.serializeRelevantFieldsList(fieldList));
        obj.put(EXPECTED_PERFORMANCE, (Object)performance.toString());
        return obj;
    }
}

