/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.joingraph;

import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.framework.FRFContext;
import com.ibm.bi.predict.explore.frf.joingraph.JoinGraphParser;
import com.ibm.bi.predict.explore.frf.joingraph.JoinGraphService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.json.JSONObject;

public class JoinGraphAccess {
    private final FRFContext context;
    private final Consumer<String> diagnostics;
    private final JoinGraphService service;

    public JoinGraphAccess(FRFContext context, Consumer<String> diagnostics) {
        this(context, diagnostics, new JoinGraphService(context.getHttpContext()));
    }

    JoinGraphAccess(FRFContext context, Consumer<String> diagnostics, JoinGraphService service) {
        this.context = context;
        this.diagnostics = diagnostics;
        this.service = service;
    }

    public List<TableCharacteristics> build() throws Exception {
        try {
            JSONObject json = this.service.joinGraph(this.context.getModuleIdToUse());
            Map<String, TableCharacteristics> tables = JoinGraphParser.parseJoinGraph(json, this.context.isFMPackage());
            return new ArrayList<TableCharacteristics>(tables.values());
        }
        catch (Throwable e) {
            this.diagnostics.accept("JoinGraphAccess: " + e.getClass() + ": " + e.getMessage());
            throw e;
        }
    }
}

