/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.joingraph;

import com.ibm.bi.predict.explore.frf.datamodel.Cardinality;
import com.ibm.bi.predict.explore.frf.datamodel.DatabaseProvider;
import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.IdentifierUtilities;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JoinGraphParser {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(JoinGraphParser.class);
    private static final String FIELD_DATATYPE = "VARCHAR(255)";
    private final Map<String, TableCharacteristics> tables = new HashMap<String, TableCharacteristics>();

    public static Map<String, TableCharacteristics> parseJoinGraph(JSONObject obj, boolean isFMPackage) {
        try {
            return new JoinGraphParser().parse(obj, isFMPackage);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing JoinGraph JSON", (Throwable)e);
            throw new RuntimeException("Error parsing JoinGraph JSON", e);
        }
    }

    private JoinGraphParser() {
    }

    private Map<String, TableCharacteristics> parse(JSONObject obj, boolean isFMPackage) throws JSONException {
        this.parseGroups(obj.getJSONArray("group"));
        this.parseConnectors(obj.getJSONArray("connector"), isFMPackage);
        this.parseQueryItems(obj.getJSONArray("queryitem"));
        return this.tables;
    }

    private void parseGroups(JSONArray groupIds) throws JSONException {
        for (int i = 0; i < groupIds.size(); ++i) {
            this.defineTable(groupIds.getString(i));
        }
    }

    private TableCharacteristics defineTable(String groupId) {
        if (!this.tables.containsKey(groupId)) {
            this.tables.put(groupId, new TableCharacteristics(groupId, DatabaseProvider.UNKNOWN, null));
        }
        return this.tables.get(groupId);
    }

    private void parseConnectors(JSONArray connectors, boolean isFMPackage) throws JSONException {
        for (int i = 0; i < connectors.size(); ++i) {
            JSONObject connector = connectors.getJSONObject(i);
            String leftId = connector.getString("leftId");
            String rightId = connector.getString("rightId");
            Cardinality card = isFMPackage ? Cardinality.MANY_TO_MANY : Cardinality.joinGraphValueOf(connector.getString("cardinality"));
            TableCharacteristics left = this.defineTable(leftId);
            TableCharacteristics right = this.defineTable(rightId);
            TableCharacteristics.defineRelationship(left, right, card);
        }
    }

    private void parseQueryItems(JSONArray queryitems) throws JSONException {
        for (int i = 0; i < queryitems.size(); ++i) {
            JSONObject queryitem = queryitems.getJSONObject(i);
            Iterator it = queryitem.keys();
            while (it.hasNext()) {
                String id = (String)it.next();
                String serializedName = IdentifierUtilities.fieldNameFromFieldId(id);
                FieldCharacteristics field = new FieldCharacteristics(id, serializedName, FIELD_DATATYPE);
                JSONArray groupIds = queryitem.getJSONArray(id);
                for (int j = 0; j < groupIds.size(); ++j) {
                    TableCharacteristics table = this.defineTable(groupIds.getString(j));
                    table.addField(field);
                }
            }
        }
    }
}

