/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.moser.module;

import com.ibm.bi.predict.explore.frf.datamodel.Cardinality;
import com.ibm.bi.predict.explore.frf.datamodel.IdentifierUtilities;
import com.ibm.bi.predict.explore.frf.datamodel.Relationship;
import com.ibm.bi.predict.explore.frf.moser.module.UseSpec;
import com.ibm.bi.predict.explore.frf.moser.module.UseSpecType;
import com.ibm.bi.predict.fastpattern.exceptions.FastPatternException;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class MoserModule {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(MoserModule.class);
    private static final String FOLDER = "folder";
    private static final String QUERYITEM = "queryItem";
    private static final String ITEM = "item";
    private static final String IDENTIFIER = "identifier";
    private static final String SOURCE_CATEGORY = "sourceCategory";
    private final JSONObject jsonModule;
    private final Map<String, List<JSONObject>> fields;
    private Map<String, List<String>> namespaceMap = new HashMap<String, List<String>>();
    private Map<String, String> tableRef = new HashMap<String, String>();
    private Map<String, UseSpec> useSpecs = new HashMap<String, UseSpec>();
    private final Map<String, List<Relationship>> relationships;

    public MoserModule(JSONObject jsonModule) throws JSONException {
        this.jsonModule = jsonModule;
        this.useSpecs = this.getUseSpecs();
        this.fields = this.makeFields();
        this.relationships = this.makeRelationships();
    }

    public Set<String> tableIds() {
        return this.fields.keySet();
    }

    public List<JSONObject> fields(String tableId) {
        return this.fields.get(tableId);
    }

    public Map<String, List<Relationship>> relationships() {
        return this.relationships;
    }

    public Map<String, String> tableRefs() {
        return this.tableRef;
    }

    public Map<String, UseSpec> useSpecs() {
        return this.useSpecs;
    }

    public String namespaceId(String tableId, String ref) {
        UseSpec useSpec = this.useSpecId(tableId, ref);
        if (useSpec == null || useSpec.getType() != UseSpecType.PACKAGE) {
            return "";
        }
        String[] names = tableId.split("\\.");
        if (useSpec.getIdentifier().equals(names[0])) {
            return names[0] + "." + names[1];
        }
        return names[0];
    }

    public Map<String, String> getUseSpecStoreIds() {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            JSONArray useSpecs = this.getArrayFromModule("useSpec");
            for (int i = 0; i < useSpecs.size(); ++i) {
                JSONObject useSpec = useSpecs.getJSONObject(i);
                String providerType = useSpec.getString("type");
                if (!"database".equals(providerType)) continue;
                String identifier = useSpec.getString(IDENTIFIER);
                String schemaStoreId = useSpec.getString("storeID");
                result.put(identifier, schemaStoreId);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.debug("Failed collecting use spec information, returning empty map", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private JSONArray getArrayFromModule(String key) {
        try {
            return this.jsonModule.getJSONArray(key);
        }
        catch (JSONException e) {
            throw new FastPatternException(String.format("Could not find array for key: %s in data module", key), e);
        }
    }

    private Map<String, List<Relationship>> makeRelationships() throws JSONException {
        HashMap<String, List<Relationship>> tableRelations = new HashMap<String, List<Relationship>>();
        if (this.jsonModule.has("relationship")) {
            JSONArray relationships = this.getArrayFromModule("relationship");
            for (int i = 0; i < relationships.length(); ++i) {
                JSONObject item = relationships.getJSONObject(i);
                JSONObject left = item.getJSONObject("left");
                JSONObject right = item.getJSONObject("right");
                this.addRelationship(tableRelations, left, right);
                this.addRelationship(tableRelations, right, left);
            }
        } else {
            this.addFMPackageInternalRelationships(tableRelations);
        }
        return tableRelations;
    }

    protected void addFMPackageInternalRelationships(Map<String, List<Relationship>> tableRelations) {
        for (Map.Entry<String, List<String>> entry : this.namespaceMap.entrySet()) {
            String namespaceId = entry.getKey();
            List<String> tables = entry.getValue();
            for (int i = 0; i < tables.size(); ++i) {
                String right;
                String left;
                for (int j = i + 1; j < tables.size(); ++j) {
                    String left2 = tables.get(i);
                    String right2 = tables.get(j);
                    this.addManyToManyRelationship(tableRelations, left2, right2);
                    this.addManyToManyRelationship(tableRelations, right2, left2);
                }
                if (this.fields.get(namespaceId) == null || (left = tables.get(i)).equals(right = namespaceId)) continue;
                this.addManyToManyRelationship(tableRelations, left, right);
                this.addManyToManyRelationship(tableRelations, right, left);
            }
        }
    }

    private void addManyToManyRelationship(Map<String, List<Relationship>> tableRelations, String id, String to) {
        List<Relationship> tableRelation = tableRelations.get(id);
        if (tableRelation == null) {
            tableRelation = new ArrayList<Relationship>();
        }
        tableRelation.add(new Relationship(to, Cardinality.MANY_TO_MANY));
        tableRelations.put(id, tableRelation);
    }

    private void addRelationship(Map<String, List<Relationship>> tableRelations, JSONObject from, JSONObject to) throws JSONException {
        String id = from.getString("ref");
        List<Relationship> tableRelation = tableRelations.get(id);
        if (tableRelation == null) {
            tableRelation = new ArrayList<Relationship>();
        }
        tableRelation.add(new Relationship(to.getString("ref"), Cardinality.valueOf(from.getString("maxcard"), to.getString("maxcard"))));
        tableRelations.put(id, tableRelation);
    }

    private Map<String, List<JSONObject>> makeFields() throws JSONException {
        HashMap<String, List<JSONObject>> fieldsMap = new HashMap<String, List<JSONObject>>();
        JSONArray tables = this.getArrayFromModule("querySubject");
        for (int tableIdx = 0; tableIdx < tables.length(); ++tableIdx) {
            JSONObject item = tables.getJSONObject(tableIdx);
            if (this.isOLAP(item)) continue;
            String tableId = item.getString(IDENTIFIER);
            fieldsMap.put(tableId, MoserModule.fields(item));
            String ref = MoserModule.parseRef(item, "ref");
            String namespaceId = this.namespaceId(tableId, ref);
            if (!namespaceId.isEmpty()) {
                List namespace = this.namespaceMap.getOrDefault(namespaceId, new ArrayList());
                namespace.add(tableId);
                this.namespaceMap.put(namespaceId, namespace);
            }
            this.tableRef.put(tableId, ref);
        }
        if (this.jsonModule.containsKey((Object)"calculation")) {
            JSONArray calcArray = this.getArrayFromModule("calculation");
            for (int i = 0; i < calcArray.length(); ++i) {
                String idForExpression = calcArray.getJSONObject(i).getString("idForExpression");
                String calcTableId = IdentifierUtilities.tableIdFromFieldId(idForExpression);
                if (!this.isValidCalcTable(calcTableId)) continue;
                if (!fieldsMap.containsKey(calcTableId)) {
                    fieldsMap.put(calcTableId, new ArrayList());
                    this.tableRef.put(calcTableId, "");
                }
                List calcFields = (List)fieldsMap.get(calcTableId);
                calcFields.add(calcArray.getJSONObject(i));
                fieldsMap.put(calcTableId, calcFields);
            }
        }
        return fieldsMap;
    }

    private boolean isValidCalcTable(String calcTableId) {
        if (this.namespaceMap.containsKey(calcTableId)) {
            return true;
        }
        String namespaceId = this.namespaceId(calcTableId, "");
        if (!namespaceId.isEmpty()) {
            List<String> namespace = this.namespaceMap.get(namespaceId);
            if (namespace == null) {
                namespace = new ArrayList<String>();
            }
            namespace.add(calcTableId);
            this.namespaceMap.put(namespaceId, namespace);
            return true;
        }
        return false;
    }

    private boolean isOLAP(JSONObject item) throws JSONException {
        return item.containsKey((Object)SOURCE_CATEGORY) && item.getString(SOURCE_CATEGORY).startsWith("dimension");
    }

    private UseSpec useSpecId(String tableId, String ref) {
        if (this.useSpecs.size() <= 1) {
            return this.useSpecs.get("ES");
        }
        String[] names = !ref.isEmpty() ? ref.split("\\.") : tableId.split("\\.");
        return this.useSpecs.get(names[0]);
    }

    private static String parseRef(JSONObject item, String key) {
        if (!item.containsKey((Object)key)) {
            return "";
        }
        try {
            String id = item.getJSONArray(key).getString(0);
            if (id.indexOf(46) != -1) {
                id = id.substring(0, id.indexOf(46));
            }
            return id;
        }
        catch (Exception e) {
            LOGGER.debug("Exception parsing the 'ref' of a MoserModule, possibly an unexpected module syntax", (Throwable)e);
            return "";
        }
    }

    private static List<JSONObject> fields(JSONObject item) throws JSONException {
        ArrayList<JSONObject> fields = new ArrayList<JSONObject>();
        JSONArray querySubjectItem = item.getJSONArray(ITEM);
        for (int j = 0; j < querySubjectItem.length(); ++j) {
            JSONObject json = querySubjectItem.getJSONObject(j);
            if (json.containsKey((Object)QUERYITEM)) {
                JSONObject queryItem = querySubjectItem.getJSONObject(j).getJSONObject(QUERYITEM);
                String fieldName = queryItem.getString(IDENTIFIER);
                if (fieldName.endsWith("_row_id")) continue;
                fields.add(queryItem);
                continue;
            }
            if (!json.containsKey((Object)FOLDER)) continue;
            JSONObject yy = json.getJSONObject(FOLDER);
            fields.addAll(MoserModule.getFolderQueryItems(yy));
        }
        return fields;
    }

    private static List<JSONObject> getFolderQueryItems(JSONObject folder) throws JSONException {
        ArrayList<JSONObject> fields = new ArrayList<JSONObject>();
        JSONArray items = folder.containsKey((Object)ITEM) ? folder.getJSONArray(ITEM) : new JSONArray();
        for (int j = 0; j < items.length(); ++j) {
            JSONObject json = items.getJSONObject(j);
            if (json.containsKey((Object)QUERYITEM)) {
                fields.add(json.getJSONObject(QUERYITEM));
                continue;
            }
            if (!json.containsKey((Object)FOLDER)) continue;
            fields.addAll(MoserModule.getFolderQueryItems(json.getJSONObject(FOLDER)));
        }
        return fields;
    }

    private Map<String, UseSpec> getUseSpecs() throws JSONException {
        JSONArray useSpecArray = this.getArrayFromModule("useSpec");
        HashMap<String, UseSpec> useSpecMap = new HashMap<String, UseSpec>();
        for (int i = 0; i < useSpecArray.size(); ++i) {
            JSONObject jsonUseSpec = useSpecArray.getJSONObject(i);
            String identifier = jsonUseSpec.getString(IDENTIFIER);
            UseSpecType type = UseSpecType.fromString(jsonUseSpec.getString("type"));
            String schemaStoreId = jsonUseSpec.getString("storeID");
            useSpecMap.put(identifier, new UseSpec(identifier, type, schemaStoreId));
        }
        return useSpecMap;
    }
}

