/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.moserjoingraph;

import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.framework.FRFContext;
import com.ibm.bi.predict.explore.frf.joingraph.JoinGraphParser;
import com.ibm.bi.predict.explore.frf.joingraph.JoinGraphService;
import com.ibm.bi.predict.explore.frf.moser.ContentService;
import com.ibm.bi.predict.explore.frf.moser.module.MoserTableParser;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class MoserJoinGraphAccess {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(MoserJoinGraphAccess.class);
    private final FRFContext context;
    private final Consumer<String> diagnostics;
    private final ContentService contentService;
    private final JoinGraphService joingraphService;

    public MoserJoinGraphAccess(FRFContext context, Consumer<String> diagnostics) {
        this(context, diagnostics, new ContentService(context.getHttpContext()), new JoinGraphService(context.getHttpContext()));
    }

    MoserJoinGraphAccess(FRFContext context, Consumer<String> diagnostics, ContentService contentService, JoinGraphService joingraphService) {
        this.context = context;
        this.diagnostics = diagnostics;
        this.contentService = contentService;
        this.joingraphService = joingraphService;
    }

    public List<TableCharacteristics> build(ExecutorService executor) throws Exception {
        Optional<List<TableCharacteristics>> moduleTables = this.getFromTempModule(executor);
        if (moduleTables.isPresent()) {
            this.diagnostics.accept("MoserJoinGraphAccess:  Using the tempModule");
            return moduleTables.get();
        }
        try {
            JSONObject json = this.joingraphService.joinGraph(this.context.getModuleIdToUse());
            Map<String, TableCharacteristics> tables = JoinGraphParser.parseJoinGraph(json, this.context.isFMPackage());
            this.diagnostics.accept("MoserJoinGraphAccess:  Using joingraph");
            return new ArrayList<TableCharacteristics>(tables.values());
        }
        catch (Throwable e) {
            this.diagnostics.accept("MoserJoinGraphAccess error: " + e.getClass() + ": " + e.getMessage());
            throw e;
        }
    }

    private Optional<List<TableCharacteristics>> getFromTempModule(ExecutorService executor) {
        JSONObject json;
        String tempModuleS = this.context.getString("frf.params.tempModule", null);
        if (tempModuleS == null) {
            return Optional.empty();
        }
        try {
            json = (JSONObject)JSON.parse((String)tempModuleS);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to parse tempModule string", (Throwable)e);
            return Optional.empty();
        }
        if (this.shouldUseJoingraph(json)) {
            return Optional.empty();
        }
        try {
            List<TableCharacteristics> tables = new MoserTableParser(this.context, this.diagnostics).build(executor, this.contentService, json);
            return Optional.of(tables);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to create tables from temp module", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean shouldUseJoingraph(JSONObject json) {
        try {
            return this.isPackage(json) && this.hasTargetInCalculations(json);
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean isPackage(JSONObject json) throws JSONException {
        if (!json.containsKey((Object)"useSpec")) {
            return false;
        }
        JSONArray useSpec = json.getJSONArray("useSpec");
        for (int i = 0; i < useSpec.size(); ++i) {
            JSONObject o = useSpec.getJSONObject(i);
            if (!o.containsKey((Object)"type") || !"package".equalsIgnoreCase(o.getString("type"))) continue;
            return true;
        }
        return false;
    }

    private boolean hasTargetInCalculations(JSONObject json) throws JSONException {
        if (!json.containsKey((Object)"calculation")) {
            return false;
        }
        List targets = this.context.getStringList("frf.params.targets", new ArrayList());
        JSONArray calcs = json.getJSONArray("calculation");
        for (int i = 0; i < calcs.size(); ++i) {
            JSONObject o = calcs.getJSONObject(i);
            if (!o.containsKey((Object)"idForExpression") || !targets.contains(o.getString("idForExpression"))) continue;
            return true;
        }
        return false;
    }
}

