/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.performance;

import com.ibm.bi.predict.algorithms.tree.DecisionTree;
import com.ibm.bi.predict.algorithms.tree.NodeContent;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.explore.frf.datamodel.DatabaseProvider;
import com.ibm.bi.predict.explore.frf.performance.QueryDescription;
import com.ibm.bi.predict.fastpattern.chaid.serialize.TreeDeserializer;
import com.ibm.bi.predict.fastpattern.exceptions.FastPatternException;
import com.ibm.bi.predict.graph.TreeNode;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

class BaseModel {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(BaseModel.class);
    private static final String YES = "Yes";
    private final String knownProviderResourceName;
    private final String unknownProviderResourceName;
    private final DecisionTree knownProviderTree;
    private final DecisionTree unknownProviderTree;

    public BaseModel(String knownProviderResourceName, String unknownProviderResourceName) {
        this.knownProviderResourceName = knownProviderResourceName;
        this.unknownProviderResourceName = unknownProviderResourceName;
        this.knownProviderTree = this.ensureLoaded(knownProviderResourceName);
        this.unknownProviderTree = this.ensureLoaded(unknownProviderResourceName);
    }

    public double confidenceForYes(QueryDescription query) {
        long t0 = System.currentTimeMillis();
        Map<String, Object> fieldCharacteristics = query.getAggregatedFieldValues();
        boolean isUnknown = fieldCharacteristics.getOrDefault("provider", (Object)DatabaseProvider.UNKNOWN).toString().equals(DatabaseProvider.UNKNOWN.toString());
        DecisionTree tree = isUnknown ? this.unknownProviderTree : this.knownProviderTree;
        long t1 = System.currentTimeMillis();
        TreeNode leaf = tree.findLeaf(fieldCharacteristics::get);
        long t2 = System.currentTimeMillis();
        DataColumn target = tree.target();
        int categoryForYes = 0;
        for (int i = 0; i < target.getCategories().size(); ++i) {
            if (!YES.equals(((Category)target.getCategories().get(i)).toString())) continue;
            categoryForYes = i;
        }
        int[] frequencies = ((NodeContent)leaf.content()).stats().categoryFrequencies();
        long t3 = System.currentTimeMillis();
        LOGGER.debug(() -> String.format("BaseModel confidenceForYes: isUnknown %s, targets %d, other %d, getAggregatedFieldValues %d ms, findLeaf %d ms, searchCats %d ms", isUnknown ? "true" : "false", query.targets().size(), query.other().size(), t1 - t0, t2 - t1, t3 - t2));
        return (double)frequencies[categoryForYes] / (double)((NodeContent)leaf.content()).rowCount();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DecisionTree ensureLoaded(String resourceName) {
        try (InputStream reader = this.getInputStream(resourceName);){
            JSONObject deserialized = new JSONObject(reader);
            DecisionTree decisionTree = TreeDeserializer.deserialize(deserialized);
            return decisionTree;
        }
        catch (IOException | JSONException e) {
            throw new FastPatternException("Failed to deserialize tree with message: " + e.getMessage(), e);
        }
    }

    InputStream getInputStream(String resourceName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
    }

    public String toString() {
        return "<BaseModel-" + this.knownProviderResourceName + "/" + this.unknownProviderResourceName + ">";
    }
}

