/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.performance;

import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.IdentifierUtilities;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableDistanceAlgorithm;
import com.ibm.bi.predict.explore.frf.framework.ExpectedQueryPerformance;
import com.ibm.bi.predict.explore.frf.framework.RelevantFieldDescription;
import com.ibm.bi.predict.explore.frf.performance.PerformancePrediction;
import com.ibm.bi.predict.explore.frf.performance.RelevanceByDistance;
import com.ibm.bi.predict.explore.frf.smarts.FieldSmartsRelevance;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ListBuilder {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ListBuilder.class);
    private final Map<String, TableCharacteristics> tables;
    private final String idPrefix;
    private final String[] targetIds;
    private Set<FieldCharacteristics> targetFields;
    private final int maxFieldsToReturn;
    private final Consumer<String> diagnostic;
    private List<RelevantFieldDescription> joinableFields;
    private List<RelevantFieldDescription> recommendedFields;
    private List<RelevantFieldDescription> alternateFields;
    private ExpectedQueryPerformance recommendedPerformance = ExpectedQueryPerformance.UNKNOWN;
    private ExpectedQueryPerformance alternatePerformance = ExpectedQueryPerformance.UNKNOWN;
    private Map<String, FieldSmartsRelevance> smartsRelevances;

    public ListBuilder(Map<String, TableCharacteristics> tables, String[] targets, int maxFieldsToReturn, String idPrefix, Consumer<String> diagnostic) {
        this(tables, null, targets, maxFieldsToReturn, idPrefix, diagnostic);
    }

    public ListBuilder(Map<String, TableCharacteristics> tables, Map<String, FieldSmartsRelevance> smartsRelevances, String[] targets, int maxFieldsToReturn, String idPrefix, Consumer<String> diagnostic) {
        this.tables = tables;
        this.smartsRelevances = smartsRelevances;
        this.targetIds = targets;
        this.idPrefix = idPrefix;
        this.maxFieldsToReturn = maxFieldsToReturn;
        this.diagnostic = diagnostic;
    }

    public List<RelevantFieldDescription> allFields() {
        return this.joinableFields;
    }

    public List<RelevantFieldDescription> alternateFields() {
        return this.alternateFields;
    }

    public ExpectedQueryPerformance alternatePerformance() {
        return this.alternatePerformance;
    }

    public boolean build(Function<List<FieldCharacteristics>, PerformancePrediction> speedFunction, Function<FieldCharacteristics, FieldSmartsRelevance> relevanceFunction) {
        long startTime = System.currentTimeMillis();
        if (this.tables == null || this.tables.isEmpty()) {
            return false;
        }
        LOGGER.debug(() -> String.format("%s: ListBuilder - Starting model build, table count: %d, targets: %s, max fields: %d", this.idPrefix, this.tables.size(), Arrays.toString(this.targetIds), this.maxFieldsToReturn));
        boolean smartsUsable = true;
        long t0 = System.currentTimeMillis();
        List<FieldCharacteristics> allFields = this.getAllJoinableFields();
        LOGGER.debug(() -> String.format("%s: ListBuilder getAllJoinableFields %d ms", this.idPrefix, ListBuilder.elapsedTime(t0)));
        long t1 = System.currentTimeMillis();
        this.executeModel(allFields, speedFunction, relevanceFunction);
        LOGGER.debug(() -> String.format("%s: ListBuilder executeModel(1) %d ms", this.idPrefix, ListBuilder.elapsedTime(t1)));
        if (this.recommendedFields.isEmpty() && this.alternateFields.isEmpty()) {
            LOGGER.debug(() -> String.format("%s: ListBuilder - No fields from model; rerun again with the calculated relevance.", this.idPrefix));
            smartsUsable = false;
            this.diagnostic.accept("Smarts input did not produce results in ListBuilder, using distance metric for relevance");
            long t2 = System.currentTimeMillis();
            TableCharacteristics[] targetTables = (TableCharacteristics[])this.targetFields.stream().map(FieldCharacteristics::tables).flatMap(Collection::stream).distinct().toArray(TableCharacteristics[]::new);
            TableDistanceAlgorithm.setDistances(targetTables);
            this.executeModel(allFields, speedFunction, RelevanceByDistance::calculateRelevance);
            LOGGER.debug(() -> String.format("%s: ListBuilder executeModel(2) %d ms", this.idPrefix, ListBuilder.elapsedTime(t2)));
        }
        this.setDiagnosticMessage();
        LOGGER.debug(() -> String.format("%s: ListBuilder - Finish model build (%d ms),  %d all joinable fields, %d recommended fields, %d alternate fields, recommended performance: %s", new Object[]{this.idPrefix, ListBuilder.elapsedTime(startTime), this.joinableFields.size(), this.recommendedFields.size(), this.alternateFields.size(), this.recommendedPerformance}));
        return smartsUsable;
    }

    public boolean hasAlternateRecommendation() {
        return !this.alternateFields.isEmpty();
    }

    public List<RelevantFieldDescription> recommendedFields() {
        return this.recommendedFields;
    }

    public ExpectedQueryPerformance recommendedPerformance() {
        return this.recommendedPerformance;
    }

    List<FieldCharacteristics> getAllJoinableFields() {
        this.targetFields = new HashSet<FieldCharacteristics>();
        HashSet<String> targetIdsSet = new HashSet<String>();
        HashSet<String> otherIdsSet = new HashSet<String>();
        for (String target : this.targetIds) {
            targetIdsSet.add(target);
        }
        this.joinableFields = new ArrayList<RelevantFieldDescription>();
        ArrayList<FieldCharacteristics> allFields = new ArrayList<FieldCharacteristics>();
        for (TableCharacteristics table : this.tables.values()) {
            for (FieldCharacteristics f : table.fields().values()) {
                if (targetIdsSet.contains(f.id())) {
                    this.targetFields.add(f);
                    continue;
                }
                if (otherIdsSet.contains(f.id())) continue;
                this.joinableFields.add(new RelevantFieldDescription(f));
                allFields.add(f);
                otherIdsSet.add(f.id());
            }
        }
        return allFields;
    }

    void executeModel(List<FieldCharacteristics> allFields, Function<List<FieldCharacteristics>, PerformancePrediction> speedFunction, Function<FieldCharacteristics, FieldSmartsRelevance> relevanceFunction) {
        this.recommendedFields = new ArrayList<RelevantFieldDescription>();
        this.alternateFields = new ArrayList<RelevantFieldDescription>();
        if (this.tables.size() == 1) {
            this.handleOneTable(allFields);
            return;
        }
        long t = System.currentTimeMillis();
        Collections.sort(allFields, new FieldCompararator(relevanceFunction));
        LOGGER.debug(() -> String.format("%s ListBuilder.executeModel sort allFields %d ms", this.idPrefix, ListBuilder.elapsedTime(t)));
        ArrayList<FieldCharacteristics> recommendedFieldsModelInput = new ArrayList<FieldCharacteristics>(this.targetFields);
        ArrayList<FieldCharacteristics> alternateFieldsModelInput = new ArrayList<FieldCharacteristics>(this.targetFields);
        long fieldCounter = 0L;
        for (FieldCharacteristics field : allFields) {
            long fc;
            long t0 = System.currentTimeMillis();
            if (relevanceFunction.apply(field).relevance() < 0.0) break;
            recommendedFieldsModelInput.add(field);
            alternateFieldsModelInput.add(field);
            long t1 = System.currentTimeMillis();
            PerformancePrediction perfPred = speedFunction.apply(recommendedFieldsModelInput);
            if (perfPred.type() == ExpectedQueryPerformance.FAST) {
                this.recommendedFields.add(new RelevantFieldDescription(field));
            } else {
                recommendedFieldsModelInput.remove(field);
            }
            long t2 = System.currentTimeMillis();
            if (this.alternateFields.size() < this.maxFieldsToReturn) {
                perfPred = speedFunction.apply(alternateFieldsModelInput);
                if (perfPred.type() == ExpectedQueryPerformance.FAST || perfPred.type() == ExpectedQueryPerformance.MEDIUM) {
                    this.alternateFields.add(new RelevantFieldDescription(field));
                } else {
                    alternateFieldsModelInput.remove(field);
                }
            }
            long t3 = System.currentTimeMillis();
            ++fieldCounter;
            LOGGER.debug(() -> String.format("%s: executeModel %d, overall %d ms, rec %d ms, alt %d ms", this.idPrefix, fc, t3 - t0, t2 - t1, t3 - t2));
            if (this.recommendedFields.size() < this.maxFieldsToReturn) continue;
            break;
        }
        this.setPerformance();
    }

    private void setPerformance() {
        if (!this.recommendedFields.isEmpty()) {
            this.recommendedPerformance = ExpectedQueryPerformance.FAST;
        }
        if (!this.alternateFields.isEmpty()) {
            this.alternatePerformance = ExpectedQueryPerformance.MEDIUM;
        }
        if (this.recommendedFields.isEmpty() && !this.alternateFields.isEmpty()) {
            this.recommendedPerformance = ExpectedQueryPerformance.MEDIUM;
            this.recommendedFields = this.alternateFields;
            this.alternateFields = new ArrayList<RelevantFieldDescription>();
        }
        if (this.recommendedFields.isEmpty()) {
            this.recommendedPerformance = ExpectedQueryPerformance.SLOW;
        }
        if (this.alternateFields.isEmpty()) {
            this.alternatePerformance = ExpectedQueryPerformance.SLOW;
        }
    }

    private void setDiagnosticMessage() {
        if (this.joinableFields.isEmpty()) {
            this.diagnostic.accept("fail to produce all joinable fields");
        }
        if (this.alternateFields.isEmpty()) {
            this.diagnostic.accept("fail to produce alternate fields");
        }
        if (this.recommendedFields.isEmpty()) {
            this.diagnostic.accept("fail to produce recommend fields");
        }
    }

    private List<RelevantFieldDescription> getRecommendFieldsFromSmartsSortByRelevance() {
        Collection<FieldSmartsRelevance> smartsFields = this.smartsRelevances.values();
        ArrayList<FieldSmartsRelevance> smartsFieldsList = new ArrayList<FieldSmartsRelevance>(smartsFields);
        Collections.sort(smartsFieldsList, new FieldSmartsRelevanceCompararator());
        ArrayList<RelevantFieldDescription> list = new ArrayList<RelevantFieldDescription>();
        for (FieldSmartsRelevance fsr : smartsFieldsList) {
            FieldCharacteristics field = IdentifierUtilities.findTargetByID(fsr.id(), this.tables);
            if (field != null && !this.targetFields.contains(field)) {
                list.add(new RelevantFieldDescription(field));
            }
            if (list.size() < this.maxFieldsToReturn) continue;
            break;
        }
        return list;
    }

    private void handleOneTable(List<FieldCharacteristics> allFields) {
        this.recommendedFields = this.smartsRelevances != null && !this.smartsRelevances.isEmpty() ? this.getRecommendFieldsFromSmartsSortByRelevance() : (allFields.size() < this.maxFieldsToReturn ? allFields.stream().sorted(Comparator.comparing(FieldCharacteristics::id)).map(RelevantFieldDescription::new).collect(Collectors.toList()) : allFields.stream().sorted(Comparator.comparing(FieldCharacteristics::id)).limit(this.maxFieldsToReturn).map(RelevantFieldDescription::new).collect(Collectors.toList()));
        this.alternateFields = this.recommendedFields;
        this.setPerformance();
    }

    static long elapsedTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    private static class FieldSmartsRelevanceCompararator
    implements Comparator<FieldSmartsRelevance> {
        private FieldSmartsRelevanceCompararator() {
        }

        @Override
        public int compare(FieldSmartsRelevance o1, FieldSmartsRelevance o2) {
            int v = Double.compare(o2.relevance(), o1.relevance());
            if (v != 0) {
                return v;
            }
            return o1.id().compareTo(o2.id());
        }
    }

    static class FieldCompararator
    implements Comparator<FieldCharacteristics> {
        Function<FieldCharacteristics, FieldSmartsRelevance> relevanceFunction;

        FieldCompararator(Function<FieldCharacteristics, FieldSmartsRelevance> relevanceFunction) {
            this.relevanceFunction = relevanceFunction;
        }

        @Override
        public int compare(FieldCharacteristics f1, FieldCharacteristics f2) {
            int v = Double.compare(this.relevanceFunction.apply(f2).relevance(), this.relevanceFunction.apply(f1).relevance());
            if (v != 0) {
                return v;
            }
            return f1.id().compareTo(f2.id());
        }
    }
}

