/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.performance;

import com.ibm.bi.predict.explore.frf.framework.ExpectedQueryPerformance;
import com.ibm.bi.predict.math.NumericUtils;

public class PerformancePrediction
implements Comparable<PerformancePrediction> {
    public static final PerformancePrediction UNKNOWN = new PerformancePrediction(ExpectedQueryPerformance.UNKNOWN, 0.0);
    public static final PerformancePrediction KNOWN_FAST = new PerformancePrediction(ExpectedQueryPerformance.FAST, 1.0);
    private final ExpectedQueryPerformance type;
    private final double confidence;

    public PerformancePrediction(ExpectedQueryPerformance type, double confidence) {
        this.type = type;
        this.confidence = confidence;
    }

    @Override
    public int compareTo(PerformancePrediction o) {
        int d = this.type.compareTo(o.type);
        return d != 0 ? d : Double.compare(o.confidence, this.confidence);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.confidence);
        return 31 * this.type.hashCode() + (int)(temp ^ temp >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformancePrediction that = (PerformancePrediction)o;
        return this.type == that.type && NumericUtils.equals((double)that.confidence, (double)this.confidence);
    }

    public ExpectedQueryPerformance type() {
        return this.type;
    }

    public double confidence() {
        return this.confidence;
    }

    public String toString() {
        return String.format("<%s-%1.2f>", this.type.toString(), this.confidence);
    }
}

