/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.smarts;

import com.ibm.bi.predict.explore.frf.framework.FRFContext;
import com.ibm.bi.predict.explore.frf.framework.FRFParams;
import com.ibm.bi.predict.explore.frf.smarts.FieldSmartsRelevance;
import com.ibm.bi.predict.explore.frf.smarts.SmartsService;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SmartsAccess {
    private static final Logger LOG = PredictLoggerFactory.getLogger(SmartsAccess.class);
    private static final String MISSING_JSON_KEY = "The response does not have the necessary JSON key element.";
    private static final String ERROR_TO_RUN_SMARTS_CALL = "Internal error to Calling the Smarts Influencers.";
    private static final String RECOMMENDATION = "recommendation";
    private static final String RECOMMENDED_FIELDS = "recommendedFields";
    private final FRFContext context;
    private final Consumer<String> diagnostic;
    private final SmartsService smartsService;
    private JSONObject recommendation;

    public SmartsAccess(FRFParams parameters, Consumer<String> diagnostic) {
        this(new FRFContext().addParams(parameters), diagnostic, new SmartsService(parameters.httpContext()));
    }

    public SmartsAccess(FRFContext context, Consumer<String> diagnostic) {
        this(context, diagnostic, new SmartsService(context.getHttpContext()));
    }

    public SmartsAccess(FRFContext context, Consumer<String> diagnostic, SmartsService smartsService) {
        this.context = context;
        this.diagnostic = diagnostic;
        this.smartsService = smartsService;
    }

    public List<FieldSmartsRelevance> call() throws Exception {
        try {
            this.recommendation = this.smartsService.influencers(this.createPayLoad());
            this.diagnostic.accept("Smarts status " + this.recommendation.getJSONObject("status").toString());
            return this.getFieldSmartsRelevance();
        }
        catch (Throwable e) {
            this.diagnostic.accept(e.getMessage());
            LOG.error(ERROR_TO_RUN_SMARTS_CALL, e);
            throw e;
        }
    }

    protected JSONObject createPayLoad() throws JSONException {
        JSONObject payload = new JSONObject();
        String moduleId = this.context.getString("frf.params.moduleId", null);
        String tempModuleId = this.context.getString("frf.params.tempModuleId", null);
        boolean shaped = this.context.getBoolean("frf.params.shapedModule", false);
        this.logParameterIssues(moduleId, tempModuleId, shaped);
        payload.put("moduleId", (Object)moduleId);
        if (shaped && tempModuleId != null) {
            payload.put("tempModuleId", (Object)tempModuleId);
        }
        payload.put("targetFieldIDForExpression", this.context.getStringList("frf.params.targets", new ArrayList()).get(0));
        payload.put("tuningParams", (Map)this.createTuningParams());
        payload.put("shapedModule", shaped);
        if (this.context.getAnalysisScope() != null) {
            payload.put("analysisScope", (Map)this.context.getAnalysisScope());
        }
        if (this.context.getIntOpt("frf.params.numResults").isPresent()) {
            payload.put("numResults", this.context.getIntOpt("frf.params.numResults").get());
        }
        payload.put("tempModule", (Object)this.context.getString("frf.params.tempModule", null));
        return payload;
    }

    private void logParameterIssues(String moduleId, String tempModuleId, boolean shaped) {
        if (shaped && tempModuleId == null) {
            LOG.error("For moduleId " + moduleId + " shaped was true but no tempModuleId was provided");
        }
        if (!shaped && tempModuleId != null) {
            LOG.error("For moduleId " + moduleId + " shaped was false but a tempModuleId " + tempModuleId + " was provided");
        }
    }

    private JSONObject createTuningParams() throws JSONException {
        JSONObject tuningParams = new JSONObject();
        tuningParams.put("allowCategoryTarget", true);
        tuningParams.put("noCorrelationLimit", true);
        return tuningParams;
    }

    private List<FieldSmartsRelevance> getFieldSmartsRelevance() throws JSONException {
        if (!this.recommendation.containsKey((Object)RECOMMENDATION)) {
            LOG.error(MISSING_JSON_KEY);
            return Collections.emptyList();
        }
        JSONObject rec = this.recommendation.getJSONObject(RECOMMENDATION);
        if (!rec.containsKey((Object)RECOMMENDED_FIELDS)) {
            LOG.error(MISSING_JSON_KEY);
            return Collections.emptyList();
        }
        JSONArray relationships = rec.getJSONArray(RECOMMENDED_FIELDS);
        ArrayList<FieldSmartsRelevance> relevance = new ArrayList<FieldSmartsRelevance>();
        for (int i = 0; i < relationships.length(); ++i) {
            String fieldIDForExpression = relationships.getJSONObject(i).getString("fieldIDForExpression");
            double confidence = relationships.getJSONObject(i).getDouble("confidence");
            relevance.add(new FieldSmartsRelevance(fieldIDForExpression, confidence));
            LOG.debug("Number of relevant fields: {}", (Object)relevance.size());
        }
        return relevance;
    }
}

