/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern;

import com.google.common.primitives.Ints;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.data.DataContext;
import com.ibm.bi.predict.data.DataPrep;
import com.ibm.bi.predict.data.StandardDataPrep;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.exceptions.UnsupportedVersionException;
import com.ibm.bi.predict.exceptions.UserMessageException;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.algorithm.AlgorithmFactory;
import com.ibm.bi.predict.fastpattern.algorithm.AlgorithmType;
import com.ibm.bi.predict.fastpattern.exceptions.BadParametersException;
import com.ibm.bi.predict.fastpattern.exceptions.InvalidDataException;
import com.ibm.bi.predict.fastpattern.exceptions.UnparseableParametersException;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriverAlgorithm;
import com.ibm.bi.predict.fastpattern.result.FastPatternResult;
import com.ibm.bi.predict.fastpattern.result.FastPatternVersionRanges;
import com.ibm.bi.predict.fastpattern.util.ParamsConverter;
import com.ibm.bi.predict.fastpattern.visrecommender.FPDVisRecommender;
import com.ibm.bi.predict.result.DataPrepResult;
import com.ibm.bi.predict.result.ExecutionResult;
import com.ibm.bi.predict.result.Message;
import com.ibm.bi.predict.result.MessageCode;
import com.ibm.bi.predict.result.StatusCode;
import com.ibm.bi.predict.result.Version;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.thirdparty.FieldIdAndType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONObject;

public class FastPatternService
implements PredictServiceFramework {
    private static final Logger LOG = PredictLoggerFactory.getLogger(FastPatternService.class);
    @Deprecated
    public static final String VERSION = Version.LATEST.toString();
    private FastPatternContext context;
    private final AlgorithmFactory algorithmFactory;

    private FastPatternService(FastPatternContext context) {
        this.context = context;
        this.algorithmFactory = new AlgorithmFactory();
    }

    public static FastPatternService getService() {
        return FastPatternService.getService(new FastPatternContext());
    }

    public static FastPatternService getService(FastPatternContext context) {
        return new FastPatternService(context);
    }

    public FastPatternResult run(Collection<PredictServiceRequest> requests, Locale locale) {
        if (requests.isEmpty()) {
            return new FastPatternResult(StatusCode.SUCCESS, Collections.emptyList(), Version.LATEST);
        }
        PredictServiceRequest request = requests.iterator().next();
        FastPatternContext localContext = (FastPatternContext)request.getContext();
        return this.filter(this.runAlgorithms(request.getData().asDataAccessProvider(), localContext), localContext);
    }

    @Deprecated
    public List<KeyDriver> run(DataAccessProvider provider, String params) {
        JSONObject paramObj = ParamsConverter.shimFPDParams(provider.getMetaData(), FastPatternService.parseJson(params));
        FastPatternContext fastPatternContext = new FastPatternContext().mixinParameters(paramObj);
        return this.runAlgorithms(provider, fastPatternContext).getKeyDrivers();
    }

    public FastPatternResult runAlgorithms(DataAccessProvider provider, FastPatternContext context) {
        FastPatternResult fastPatternResult;
        FastPatternService.validateProvider(provider);
        try {
            Optional<Integer> targetIndex = this.getTargetIndex(provider, context);
            int[] driverIndices = FastPatternService.getDriverIndices(provider, context);
            this.validateParams(provider, targetIndex, driverIndices, context);
            DataPrepResult dataPrepResult = this.prepareData(provider, targetIndex, driverIndices);
            List fieldInfo = ((DataPrep)dataPrepResult.getContent()).getColumnMeta();
            LOG.perfStart();
            LOG.perfLog("Completing execution of fast pattern detection");
            List<ExecutionResult<List<KeyDriver>>> results = this.runAlgorithms(dataPrepResult, context);
            fastPatternResult = FastPatternResult.build(dataPrepResult, results, Version.parse((String)context.getVersion()), context.getLocale("locale"));
            FastPatternService.addVisRecommendations(fastPatternResult.getKeyDrivers(), fieldInfo, context.getLocale("locale"));
            FastPatternService.logKeyDriversInfo(fastPatternResult.getKeyDrivers());
        }
        catch (UserMessageException e) {
            fastPatternResult = new FastPatternResult(StatusCode.SUCCESS, Collections.emptyList(), Version.parse((String)context.getVersion()));
            fastPatternResult.addErrorMessage(new Message(e.getMessageCode(), context.getLocale("locale")));
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.perfStop();
            throw e;
        }
        LOG.perfLog(String.format("Finished execution of fast pattern detection with %s drivers.", fastPatternResult.getKeyDrivers().size()));
        LOG.perfStop();
        List drivers = (List)fastPatternResult.getContent();
        if (drivers.isEmpty() && fastPatternResult.getErrorMessages().isEmpty()) {
            fastPatternResult.addWarningMessage(Message.fromCode((MessageCode)MessageCode.NO_KEY_DRIVERS_FOUND, (Locale)context.getLocale("locale")));
        }
        return fastPatternResult;
    }

    private FastPatternResult filter(FastPatternResult result, FastPatternContext context) {
        int limit = context.getTopCountFromFilters().orElse(Integer.MAX_VALUE);
        if (((List)result.getContent()).size() <= limit) {
            return result;
        }
        List<KeyDriver> filteredKeyDrivers = new ArrayList((Collection)result.getContent()).stream().limit(limit).collect(Collectors.toList());
        FastPatternResult filtered = new FastPatternResult(result.getStatus(), filteredKeyDrivers, Version.LATEST);
        filtered.addMessages(result);
        return filtered;
    }

    private List<ExecutionResult<List<KeyDriver>>> runAlgorithms(DataPrepResult dataPrepResult, FastPatternContext context) {
        Stream methods = context.getBoolean("fpd.config.useParallelProcessing", false) ? (Stream)Stream.of(context.getMethods()).parallel() : Stream.of(context.getMethods());
        context.setValue("locale", context.getLocale("locale").toString());
        OneWayKeyDriverAlgorithm oneway = new OneWayKeyDriverAlgorithm((DataPrep)dataPrepResult.getContent(), context, Collections.emptyList());
        ArrayList<ExecutionResult<List<KeyDriver>>> results = new ArrayList<ExecutionResult<List<KeyDriver>>>();
        if (FastPatternService.hasOnewayAlgorithmRequest(context.getMethods())) {
            results.add(oneway.getResults());
        }
        methods.filter(m -> m != AlgorithmType.ONE_WAY_KEY_DRIVERS).map(method -> this.getAlgorithmResultsIfExists((AlgorithmType)((Object)method), (DataPrep)dataPrepResult.getContent(), context, oneway.getUnfilteredResults())).filter(Objects::nonNull).collect(Collectors.toCollection(() -> results));
        List warnings = results.stream().map(ExecutionResult::getWarningMessages).flatMap(Collection::stream).collect(Collectors.toList());
        if (!warnings.isEmpty()) {
            LOG.debug("Warnings: {}", warnings.stream().map(Message::getCaption).collect(Collectors.toList()));
        }
        return results;
    }

    public List<KeyDriver> run(DataAccessProvider provider, JSONObject params, FastPatternContext context) {
        JSONObject paramsObj = FastPatternService.validateInputs(provider, params);
        context.mixinParameters(paramsObj);
        FastPatternResult result = this.runAlgorithms(provider, context);
        return result.getKeyDrivers();
    }

    private DataPrepResult prepareData(DataAccessProvider provider, Optional<Integer> targetIndex, int[] driverIndices) {
        LOG.perfStart();
        LOG.perfLog("Starting data preparation.");
        DataPrep preparation = StandardDataPrep.prepareData((DataAccessProvider)provider, (DataContext)this.context, targetIndex, (int[])driverIndices);
        FastPatternService.logDegenerateFields(preparation);
        DataPrepResult dataPrepResult = preparation.buildResult();
        if (dataPrepResult.getStatus().equals((Object)StatusCode.FAILURE) && ((Message)dataPrepResult.getErrorMessages().get(0)).getMessageCode().equals((Object)MessageCode.INSUFFICIENT_MEMORY)) {
            throw new UserMessageException(MessageCode.INSUFFICIENT_MEMORY);
        }
        FastPatternService.logDataFrameInfo((DataPrep)dataPrepResult.getContent());
        LOG.perfStop("Finished data preparation.");
        return dataPrepResult;
    }

    private Optional<Integer> getTargetIndex(DataAccessProvider provider, FastPatternContext context) {
        return context.getTarget().map(FieldIdAndType::id).map(id -> {
            MetaData metadata = provider.getMetaData();
            int targetIdx = -1;
            for (int i = 0; i < metadata.fieldCount(); ++i) {
                String fieldId = metadata.getFieldIdentifier(i);
                if (!fieldId.equals(id)) continue;
                targetIdx = i;
            }
            return targetIdx;
        }).filter(idx -> idx >= 0);
    }

    private static int[] getDriverIndices(DataAccessProvider provider, FastPatternContext context) {
        List inputIndices = context.getInputIds().map(inputIds -> {
            MetaData metadata = provider.getMetaData();
            ArrayList<Integer> dataItems = new ArrayList<Integer>();
            for (int i = 0; i < metadata.fieldCount(); ++i) {
                String fieldId = metadata.getFieldIdentifier(i);
                if (!inputIds.contains(fieldId)) continue;
                dataItems.add(i);
            }
            return dataItems;
        }).orElseThrow(() -> new BadParametersException("No input indices"));
        return Ints.toArray((Collection)inputIndices);
    }

    private static void addVisRecommendations(List<KeyDriver> keyDrivers, List<DataColumn.ColumnMeta> fieldInfo, Locale locale) {
        FPDVisRecommender recommender = new FPDVisRecommender(fieldInfo, locale);
        recommender.process(keyDrivers);
    }

    private ExecutionResult<List<KeyDriver>> getAlgorithmResultsIfExists(AlgorithmType method, DataPrep dataPrep, FastPatternContext context, List<OneWayKeyDriver> oneway) {
        return this.algorithmFactory.getAlgorithm(method, dataPrep, context, oneway).map(alg -> alg.getResults()).orElse(null);
    }

    private static JSONObject validateInputs(DataAccessProvider provider, JSONObject params) {
        if (provider == null) {
            LOG.error("Data access provider is null");
            throw new BadParametersException("Data access provider is null");
        }
        if (params == null) {
            LOG.error("Passed parameters is null");
            throw new BadParametersException("Passed parameters is null");
        }
        LOG.debug("Field count: {}, row count: {}, params: {}", new Object[]{provider.getMetaData().fieldCount(), provider.getMetaData().rowCount(), params});
        for (int i = 0; i < provider.getMetaData().fieldCount(); ++i) {
            MetaData metadata = provider.getMetaData();
            LOG.debug("Field info - ID: {}, display label: {}, type: {}, num categories: {}", new Object[]{metadata.getFieldIdentifier(i), metadata.getFieldDisplayLabel(i), metadata.getFieldType(i), metadata.getFieldType(i) == FieldType.CATEGORICAL ? Integer.valueOf(metadata.getFieldCategories(i)) : "n/a"});
        }
        return params;
    }

    private static void validateProvider(DataAccessProvider provider) {
        LOG.debug("Validating data access provider");
        if (provider == null) {
            LOG.error("Data access provider is null");
            throw new BadParametersException("Data access provider is null");
        }
        if (provider.getMetaData() == null) {
            LOG.error("Metadata in the data access provider is null");
            throw new InvalidDataException("Metadata in the data access provider is null");
        }
        LOG.debug("Valid data access provider - fieldCount={}", (Object)provider.getMetaData().fieldCount());
    }

    private void validateParams(DataAccessProvider provider, Optional<Integer> targetIndex, int[] inputIndices, FastPatternContext context) {
        LOG.perfStart();
        LOG.perfLog("Validating provider and params.");
        MetaData metadata = provider.getMetaData();
        FastPatternService.validateVersion(context.getVersion());
        int targetIndexVal = targetIndex.filter(idx -> idx >= 0 && idx < metadata.fieldCount()).orElseThrow(() -> {
            LOG.error("Invalid target index");
            return new BadParametersException("Invalid target index");
        });
        if (FastPatternService.isCategoricalTargetRequest(context, metadata, targetIndexVal)) {
            LOG.error("{}{}", (Object)"Categorical target for Key Drivers not yet supported: ", (Object)metadata.getFieldDisplayLabel(targetIndexVal));
            throw new UserMessageException(MessageCode.CATEGORICAL_TARGET);
        }
        Set<Integer> uniqueInputIndices = FastPatternService.getUniqueInputIndices(metadata, inputIndices);
        if (uniqueInputIndices.remove(targetIndexVal)) {
            LOG.warn("Target included in potential drivers");
        }
        if (metadata.fieldCount() < 2) {
            LOG.error("{}{}", (Object)"Too few fields in the data access provider: ", (Object)metadata.fieldCount());
            throw new UserMessageException(MessageCode.TOO_FEW_FIELDS);
        }
        if (metadata.rowCount() < 1) {
            LOG.error("{}{}", (Object)"Not enough records to run an analysis: ", (Object)metadata.rowCount());
            throw new UserMessageException(MessageCode.TOO_FEW_RECORDS);
        }
        LOG.perfStop("Validation complete.");
    }

    private static void validateVersion(String version) {
        Version requestedVersion = Version.parse((String)version);
        if (requestedVersion == null) {
            LOG.error("Invalid version");
            throw new BadParametersException("Invalid version");
        }
        FastPatternVersionRanges versionRange = FastPatternVersionRanges.getInstance();
        if (!versionRange.isSupported(requestedVersion)) {
            String message = String.format("Unsupported version. Valid version ranges are: [%s, %s] and [%s, %s]", versionRange.previousMin(), versionRange.previousMax(), versionRange.latestMin(), versionRange.latestMax());
            LOG.error(message);
            throw new UnsupportedVersionException(message);
        }
    }

    private static boolean isCategoricalTargetRequest(FastPatternContext context, MetaData metadata, int targetIndex) {
        if (FastPatternService.hasOnewayAlgorithmRequest(context.getMethods()) && !context.getBoolean("fpd.config.allowKeyDriverCategoricalTarget", false)) {
            FieldType type = metadata.getFieldType(targetIndex);
            return type == FieldType.CATEGORICAL;
        }
        return false;
    }

    private static boolean hasOnewayAlgorithmRequest(AlgorithmType[] algorithmTypes) {
        return Arrays.stream(algorithmTypes).anyMatch(AlgorithmType.ONE_WAY_KEY_DRIVERS::equals);
    }

    private static Set<Integer> getUniqueInputIndices(MetaData metadata, int[] inputIndices) {
        HashSet<Integer> uniqueInputIndices = new HashSet<Integer>();
        for (int driverIndex : inputIndices) {
            if (driverIndex < 0 || driverIndex >= metadata.fieldCount()) {
                LOG.error("Invalid dataitem index");
                throw new BadParametersException("Invalid dataitem index");
            }
            if (uniqueInputIndices.add(driverIndex)) continue;
            LOG.warn("Duplicate potential drivers included in parameters");
        }
        return uniqueInputIndices;
    }

    private static void logKeyDriversInfo(List<KeyDriver> keyDrivers) {
        for (int i = 0; i < keyDrivers.size(); ++i) {
            LOG.debug("Key driver details = {}", (Object)keyDrivers.get(i));
        }
    }

    private static void logDegenerateFields(DataPrep prep) {
        if (!prep.degenerateColumns().isEmpty()) {
            LOG.debug("Removed degenerate fields: {}", (Object)prep.degenerateColumns());
        }
    }

    private static void logDataFrameInfo(DataPrep dataPrep) {
        if (LOG.isDebugEnabled()) {
            int rows = dataPrep.targetColumn().rowCount();
            int columns = dataPrep.driverColumns().size() + 1;
            LOG.debug("Dimension of the data frame: {} rows and {} columns", (Object)rows, (Object)columns);
            LOG.debug("target = {}", (Object)dataPrep.targetColumn().getId());
            LOG.debug(FastPatternService.transformationInfo(dataPrep.targetColumn()));
            for (DataColumn column : dataPrep.driverColumns()) {
                LOG.debug(FastPatternService.transformationInfo(column));
            }
        }
    }

    private static String transformationInfo(DataColumn column) {
        Set trans = column.getStatus();
        List categories = column.getCategories();
        String s = column.getId() + ": ";
        if (categories != null) {
            s = s + " Categories: " + categories.toString();
        }
        s = s + " Transformations: ";
        s = s + trans.toString();
        return s;
    }

    private static JSONObject parseJson(String json) {
        try {
            return (JSONObject)JSON.parse((String)json, (boolean)false);
        }
        catch (Exception e) {
            LOG.error("Params parsing error", (Throwable)e);
            throw new UnparseableParametersException("Could not parse parameters due to malformed json");
        }
    }
}

