/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern;

import com.ibm.bi.predict.fastpattern.FastPatternParams;
import com.ibm.bi.predict.fastpattern.algorithm.AlgorithmType;
import com.ibm.bi.predict.fastpattern.exceptions.BadParametersException;
import com.ibm.bi.predict.fastpattern.exceptions.UnparseableParametersException;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.TreeSet;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ParamsParser {
    private static final Logger LOG = PredictLoggerFactory.getLogger(ParamsParser.class);
    private static final String DATA_ITEMS = "dataItems";
    private static final String TARGET = "target";
    private static final String PARAMS_PARSER_PARSE = "ParamsParser.parse: ";
    private static final String VERSION = "version";
    private static final String METHODS = "methods";
    private static final String LOCALE = "locale";
    private static final String SAMPLEDDATA = "sampledData";

    private ParamsParser() {
    }

    public static FastPatternParams parse(JSONObject params) {
        if (params == null) {
            throw new UnparseableParametersException("Could not parse parameters due to malformed json");
        }
        String version = ParamsParser.getValue(String.class, params, VERSION, "Can not find version in parameter");
        int targetIndex = ParamsParser.getValue(Integer.class, params, TARGET, "Can not find target in parameter");
        int[] driversIndexes = ParamsParser.parseDriversIndexes(params);
        AlgorithmType[] methods = ParamsParser.parseAlgorithmArray(params);
        String locale = ParamsParser.getValue(String.class, params, LOCALE, null);
        Boolean defaultVal = false;
        boolean sampledData = ParamsParser.getValueOrDefault(Boolean.class, params, SAMPLEDDATA, defaultVal);
        return new FastPatternParams(version, targetIndex, driversIndexes, methods, locale, sampledData);
    }

    private static AlgorithmType[] parseAlgorithmArray(JSONObject json) {
        JSONArray array = ParamsParser.getValue(JSONArray.class, json, METHODS, null);
        if (array == null || array.isEmpty()) {
            return ParamsParser.allMethods();
        }
        TreeSet<AlgorithmType> methods = new TreeSet<AlgorithmType>();
        for (int i = 0; i < array.size(); ++i) {
            try {
                if ("drivers".equals(array.getString(i))) {
                    methods.add(AlgorithmType.fromString("oneway"));
                    methods.add(AlgorithmType.fromString("twoway"));
                    methods.add(AlgorithmType.fromString("tree"));
                    continue;
                }
                methods.add(AlgorithmType.fromString(array.getString(i)));
                continue;
            }
            catch (Exception e) {
                String badMethodName = ParamsParser.getMethodName(array, i);
                LOG.error(String.format("%s: %s", "Unrecognized method" + badMethodName, e));
                throw new BadParametersException("Unrecognized method");
            }
        }
        return methods.toArray(new AlgorithmType[methods.size()]);
    }

    private static String getMethodName(JSONArray methods, int idx) {
        try {
            return methods.getString(idx);
        }
        catch (JSONException e) {
            LOG.error("Unrecognized method", (Throwable)e);
            throw new BadParametersException("Unrecognized method");
        }
    }

    private static AlgorithmType[] allMethods() {
        LOG.debug("No methods specified. Running all methods.");
        return AlgorithmType.values();
    }

    private static int[] parseDriversIndexes(JSONObject json) {
        JSONArray array = ParamsParser.getValue(JSONArray.class, json, DATA_ITEMS, "Can not find dataItems in parameter");
        int[] driversIndexes = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            try {
                driversIndexes[i] = (int)array.getLong(i);
                continue;
            }
            catch (JSONException e) {
                LOG.debug("Can not find dataItems in parameter", (Throwable)e);
                ParamsParser.returnNullOrThrow("Can not find dataItems in parameter");
            }
        }
        return driversIndexes;
    }

    private static <T> T getValue(Class<T> clazz, JSONObject json, String key, String errorMessage) {
        try {
            T value = clazz.cast(json.get(key));
            if (value == null) {
                return ParamsParser.returnNullOrThrow(errorMessage);
            }
            return value;
        }
        catch (Exception e) {
            LOG.debug(String.format(e.getMessage(), e));
            return ParamsParser.returnNullOrThrow(errorMessage);
        }
    }

    private static <T> T getValueOrDefault(Class<T> clazz, JSONObject json, String key, T defaultVal) {
        try {
            if (!json.has(key)) {
                return ParamsParser.logMissingAndReturnDefault(key, defaultVal);
            }
            return clazz.cast(json.get(key));
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            return ParamsParser.logMissingAndReturnDefault(key, defaultVal);
        }
    }

    private static <T> T returnNullOrThrow(String errorMessage) {
        if (errorMessage != null) {
            LOG.error(PARAMS_PARSER_PARSE + errorMessage);
            throw new BadParametersException(errorMessage);
        }
        return null;
    }

    private static <T> T logMissingAndReturnDefault(String key, T defaultVal) {
        LOG.warn(String.format("Parameter %s missing, assigning default value: %s", key, defaultVal.toString()));
        return defaultVal;
    }
}

