/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.algorithm;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum AlgorithmType {
    TREE("tree"),
    ONE_WAY_KEY_DRIVERS("oneway"),
    TWO_WAY_KEY_DRIVERS("twoway");

    private String name;

    private AlgorithmType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static AlgorithmType fromString(String alg) {
        for (AlgorithmType a : AlgorithmType.values()) {
            if (!a.name.equalsIgnoreCase(alg)) continue;
            return a;
        }
        throw new IllegalStateException("Unknown method");
    }

    public static List<String> allMethods() {
        return Arrays.stream(AlgorithmType.values()).map(AlgorithmType::toString).collect(Collectors.toList());
    }
}

