/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.chaid.serialize;

import com.ibm.bi.predict.algorithms.tree.DecisionTree;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.data.DataContext;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.chaid.serialize.TreeJsonBuilder;
import com.ibm.bi.predict.fastpattern.exceptions.FastPatternException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class TreeSerializer {
    private static final String JSON_EXCEPTION = "Failed to parse JSON with exception: %s";
    private static final String FIT_TREE_FIRST = "Tree must be fitted first";

    private TreeSerializer() {
    }

    public static String serialize(DecisionTree tree, DataContext context) throws JSONException {
        if (!tree.fitted()) {
            throw new IllegalStateException(FIT_TREE_FIRST);
        }
        TreeJsonBuilder treeJsonBuilder = new TreeJsonBuilder(tree, context.getLocale("locale"));
        JSONObject serialized = new JSONObject();
        JSONObject result = new JSONObject();
        JSONObject fields = new JSONObject();
        JSONArray resultArr = new JSONArray();
        JSONObject structure = treeJsonBuilder.build();
        fields.put("inputs", (Collection)TreeSerializer.serializeDataColumns(tree.predictors(), context.getLocale("locale")));
        fields.put("target", (Map)TreeSerializer.serializeDataColumn(tree.target(), context.getLocale("locale")));
        result.put("fields", (Map)fields);
        result.put("details", (Map)structure);
        resultArr.add((Object)result);
        serialized.put("results", (Collection)resultArr);
        return serialized.toString();
    }

    private static JSONArray serializeDataColumns(Collection<DataColumn> columns, Locale locale) {
        JSONArray array = new JSONArray();
        for (DataColumn column : columns) {
            JSONObject object = TreeSerializer.serializeDataColumn(column, locale);
            array.add((Object)object);
        }
        return array;
    }

    private static JSONObject serializeDataColumn(DataColumn column, Locale locale) {
        try {
            JSONObject field = new JSONObject();
            JSONArray cats = new JSONArray();
            field.put("id", (Object)column.getId());
            field.put("label", (Object)column.getLabel());
            if (column.getType().equals((Object)FieldType.CATEGORICAL)) {
                for (Category category : column.getCategories()) {
                    cats.add((Object)category.asString(locale));
                }
                field.put("categories", (Collection)cats);
            }
            return field;
        }
        catch (JSONException e) {
            throw new FastPatternException(String.format(JSON_EXCEPTION, new Object[]{e}));
        }
    }
}

