/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.explore.visrecommender.VisRecommendation;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.keydrivers.TargetField;
import com.ibm.bi.predict.fastpattern.result.InputField;
import com.ibm.bi.predict.fastpattern.util.KeyDriverType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public abstract class KeyDriver
implements Comparable<KeyDriver> {
    protected String id;
    protected String[] fields;
    protected List<InputField> inputFields;
    protected String target;
    protected String[] targetCategoryLabels;
    protected List<VisRecommendation> visRecommendations;
    private static final int STRONG_ACCURACY = 2;
    private static final int MODERATE_ACCURACY = 1;
    private static final int WEAK_ACCURACY = 0;
    protected final FastPatternContext context;

    public static String[] toCategoryArray(List<Category> categories, Locale locale) {
        return Optional.ofNullable(categories).map(cats -> (String[])cats.stream().map(c -> c.asString(locale)).toArray(String[]::new)).orElse(null);
    }

    public KeyDriver(String id, List<InputField> inputFields, String targetId, FastPatternContext context) {
        this.id = id;
        this.inputFields = inputFields;
        this.fields = this.createFieldIds();
        this.target = targetId;
        this.context = context;
    }

    public KeyDriver(String id, List<InputField> inputFields, TargetField targetField, FastPatternContext context) {
        this.id = id;
        this.inputFields = inputFields;
        this.fields = this.createFieldIds();
        this.target = targetField.getTargetId();
        this.targetCategoryLabels = targetField.getTargetCategories();
        this.context = context;
        this.visRecommendations = new ArrayList<VisRecommendation>();
    }

    public abstract KeyDriverType getType();

    public String getId() {
        return this.id;
    }

    public String[] getFieldIds() {
        return (String[])this.fields.clone();
    }

    public List<InputField> getInputFields() {
        return this.inputFields;
    }

    public abstract double getPValue();

    public abstract double getAccuracy();

    public String getTargetId() {
        return this.target;
    }

    public String[] getTargetCategories() {
        return this.targetCategoryLabels;
    }

    public int getAccuracyLevel() {
        double accuracy = this.getAccuracy();
        if (accuracy > this.context.getDouble("fpd.config.strongAccuracyThreshold", 0.66)) {
            return 2;
        }
        if (accuracy > this.context.getDouble("fpd.config.moderateAccuracyThreshold", 0.33)) {
            return 1;
        }
        return 0;
    }

    public List<VisRecommendation> getVis() {
        return this.visRecommendations;
    }

    public void addVisRecommendation(VisRecommendation visRecommendation) {
        this.visRecommendations.add(visRecommendation);
    }

    public void addVisRecommendations(List<VisRecommendation> visRecommendations) {
        this.visRecommendations.addAll(visRecommendations);
    }

    private String[] createFieldIds() {
        if (CollectionUtils.isEmpty(this.inputFields)) {
            return new String[0];
        }
        return (String[])this.inputFields.stream().map(InputField::getId).toArray(String[]::new);
    }

    @Override
    public int compareTo(KeyDriver otherKeyDriver) {
        int diff = Double.compare(this.getAccuracy(), otherKeyDriver.getAccuracy());
        if (diff != 0) {
            if (Double.isNaN(this.getAccuracy() + otherKeyDriver.getAccuracy())) {
                return -diff;
            }
            return diff;
        }
        if (this.getType() == KeyDriverType.TREE && otherKeyDriver.getType() != KeyDriverType.TREE) {
            return 1;
        }
        if (this.getType() != KeyDriverType.TREE && otherKeyDriver.getType() == KeyDriverType.TREE) {
            return -1;
        }
        diff = Double.compare(this.inputFields.size(), otherKeyDriver.inputFields.size());
        if (diff != 0) {
            return diff;
        }
        for (int i = 0; i < this.inputFields.size(); ++i) {
            diff = this.inputFields.get(i).getId().compareTo(otherKeyDriver.inputFields.get(i).getId());
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof KeyDriver && this.compareTo((KeyDriver)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.getAccuracy());
    }
}

