/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayStatisticsTest;
import com.ibm.bi.predict.fastpattern.keydrivers.TwoWayStatisticsTest;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.OneWaySummarizer;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.TwoWaySummarizer;
import java.util.List;

public class KeyDriverStatisticsTestFactory {
    private KeyDriverStatisticsTestFactory() {
    }

    public static OneWayStatisticsTest createOneWayTest(DataFrame dataFrame, List<Category> categoryList, FastPatternContext context) {
        OneWayStatisticsTest oneWay = new OneWayStatisticsTest(dataFrame, context);
        if (dataFrame.getTargetType() == FieldType.NUMERICAL) {
            oneWay.setSummarizer(new OneWaySummarizer(OneWaySummarizer::makeAnovaAccumulator));
        } else {
            oneWay.setSummarizer(new OneWaySummarizer(OneWaySummarizer::makeChiSquareTestAccumulator));
        }
        return oneWay;
    }

    public static TwoWayStatisticsTest createTwoWayTest(DataFrame dataFrame, List<Category> categoryList, FastPatternContext context, List<OneWayKeyDriver> oneway) {
        TwoWayStatisticsTest twoWay;
        if (dataFrame.getTargetType() == FieldType.NUMERICAL) {
            twoWay = new TwoWayStatisticsTest(dataFrame, oneway, context);
            twoWay.setSummarizer(new TwoWaySummarizer(TwoWaySummarizer::makeAnovaAccumulator));
        } else {
            twoWay = new TwoWayStatisticsTest(dataFrame, oneway, categoryList, context);
            twoWay.setSummarizer(new TwoWaySummarizer(TwoWaySummarizer::makeChiSquareTestAccumulator));
        }
        return twoWay;
    }
}

