/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.TargetField;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.SummaryStats;
import com.ibm.bi.predict.fastpattern.result.InputField;
import com.ibm.bi.predict.fastpattern.util.KeyDriverType;
import java.util.List;
import java.util.Objects;

public class OneWayKeyDriver
extends KeyDriver {
    private int factorIndex;
    private SummaryStats summaryStats;

    public OneWayKeyDriver(String id, SummaryStats summaryStats, List<InputField> inputFields, int factorIndex, String target, FastPatternContext context) {
        this(id, summaryStats, inputFields, factorIndex, target, null, context);
    }

    public OneWayKeyDriver(String id, SummaryStats summaryStats, List<InputField> inputFields, int factorIndex, String targetId, String[] targetCategories, FastPatternContext context) {
        super(id, inputFields, new TargetField(targetId, targetCategories), context);
        this.summaryStats = summaryStats;
        this.factorIndex = factorIndex;
    }

    public int getFactorIndex() {
        return this.factorIndex;
    }

    @Override
    public KeyDriverType getType() {
        return KeyDriverType.ONE_WAY;
    }

    public SummaryStats getStats() {
        return this.summaryStats;
    }

    @Override
    public double getPValue() {
        return this.summaryStats.getPValue();
    }

    @Override
    public double getAccuracy() {
        return this.summaryStats.getAccuracy();
    }

    public String toString() {
        return "\n One-Way: ID: " + this.id + " - " + this.summaryStats.toString();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof KeyDriver && this.compareTo((KeyDriver)o) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.getAccuracy());
    }
}

