/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriverFilter;
import com.ibm.bi.predict.fastpattern.keydrivers.TwoWayKeyDriver;

class TwoWayKeyDriverFilter
extends KeyDriverFilter {
    final double minimumAdjustedR2;
    final double minimumImprovement;

    TwoWayKeyDriverFilter(FastPatternContext context) {
        super(context);
        this.minimumAdjustedR2 = context.getDouble("fpd.config.minimumAdjustedRSquared", 0.1);
        this.minimumImprovement = context.getDouble("fpd.config.improvementThreshold", 0.1);
    }

    @Override
    protected boolean filterCategorical(KeyDriver driver) {
        TwoWayKeyDriver twoway = (TwoWayKeyDriver)driver;
        return this.pValueFilter(twoway) && this.filterByRSquared(twoway.getAccuracy(), twoway.getFactor1().getStats().getAccuracy(), twoway.getFactor2().getStats().getAccuracy());
    }

    @Override
    protected boolean filterContinuous(KeyDriver driver) {
        TwoWayKeyDriver twoway = (TwoWayKeyDriver)driver;
        return this.filterByRSquared(twoway.getAdjustedRSquared(), twoway.getFactor1().getStats().getAdjustedRSquared(), twoway.getFactor2().getStats().getAdjustedRSquared());
    }

    private boolean filterByRSquared(double driverR2, double factor1R2, double factor2R2) {
        return driverR2 > this.minimumAdjustedR2 && driverR2 > this.improvedAdjustedRSquare(factor1R2, factor2R2);
    }

    private double improvedAdjustedRSquare(double factor1R2, double factor2R2) {
        double improvedAdjRFactorOne = this.computeImprovementThresholdAdjR(factor1R2);
        double improvedAdjRFactorTwo = this.computeImprovementThresholdAdjR(factor2R2);
        return Math.max(improvedAdjRFactorOne, improvedAdjRFactorTwo);
    }

    private double computeImprovementThresholdAdjR(double adjR) {
        return adjR + this.minimumImprovement * (1.0 - adjR);
    }
}

