/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.exceptions.InvalidDataException;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.TwoWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.SummaryStats;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.TwoWaySummarizer;
import com.ibm.bi.predict.fastpattern.result.InputField;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TwoWayStatisticsTest {
    protected final DataFrame df;
    private final List<OneWayKeyDriver> oneway;
    private final boolean parallel;
    private final FastPatternContext context;
    private final int K;
    private final int L;
    private final String[] categories;
    private TwoWaySummarizer summarizer;

    public TwoWayStatisticsTest(DataFrame df, List<OneWayKeyDriver> oneway, FastPatternContext context) {
        this(df, oneway, null, context);
    }

    public TwoWayStatisticsTest(DataFrame df, List<OneWayKeyDriver> oneway, List<Category> categoryList, FastPatternContext context) {
        this.df = df;
        this.parallel = context.getBoolean("fpd.config.useParallelProcessing", false);
        this.oneway = oneway;
        this.context = context;
        this.categories = KeyDriver.toCategoryArray(categoryList, context.getLocale("locale"));
        this.K = Math.min((Integer)context.getIntList("fpd.config.driverSearchPairs", Arrays.asList(50, 25)).get(0), oneway.size());
        this.L = Math.min((Integer)context.getIntList("fpd.config.driverSearchPairs", Arrays.asList(50, 25)).get(1), oneway.size());
    }

    public void setSummarizer(TwoWaySummarizer summarizer) {
        this.summarizer = summarizer;
    }

    public List<TwoWayKeyDriver> getKeyDrivers() {
        IntStream stream = IntStream.range(0, this.L);
        stream = this.parallel ? stream.parallel() : stream;
        return stream.boxed().flatMap(i -> IntStream.range(i + 1, this.K).mapToObj(j -> this.getTwoWayForFactors(this.oneway.get((int)i), this.oneway.get(j), this.context.getCategoricalChisquareAdjustThreshold(), this.context.getMinCategoryFrequency()))).sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }

    private TwoWayKeyDriver getTwoWayForFactors(OneWayKeyDriver factor1, OneWayKeyDriver factor2, double threshold, int minCategoryFrequency) {
        int nUniqueFactor1 = this.df.getFieldCategories(factor1.getFactorIndex());
        int nUniqueFactor2 = this.df.getFieldCategories(factor2.getFactorIndex());
        if (!this.checkCategories(nUniqueFactor1) || !this.checkCategories(nUniqueFactor2)) {
            throw new InvalidDataException("Invalid number of field categories");
        }
        if (!Double.isFinite(factor1.getFactorIndex()) || !Double.isFinite(factor2.getFactorIndex())) {
            throw new InvalidDataException("Invalid factor index");
        }
        SummaryStats summaryStats = this.summarizer.getSummaryStats(factor1.getFactorIndex(), factor2.getFactorIndex(), nUniqueFactor1, nUniqueFactor2, this.df, threshold, minCategoryFrequency);
        return this.createTwoWayKeyDriver(factor1, factor2, summaryStats);
    }

    private boolean checkCategories(int categories) {
        return categories >= this.context.getInt("minCategoriesToBeUseful", 2) && categories <= this.context.getInt("maxCategoriesToProcess", 50);
    }

    private TwoWayKeyDriver createTwoWayKeyDriver(OneWayKeyDriver factor1, OneWayKeyDriver factor2, SummaryStats summaryStats) {
        String targetString = this.df.getFieldName(this.df.getTargetIndex());
        String factor1String = this.df.getFieldName(factor1.getFactorIndex());
        String factor2String = this.df.getFieldName(factor2.getFactorIndex());
        String factor1Label = this.df.getFieldLabel(factor1.getFactorIndex());
        String factor2Label = this.df.getFieldLabel(factor2.getFactorIndex());
        List<InputField> inputFields = InputField.createList(new String[]{factor1String, factor2String}, new String[]{factor1Label, factor2Label});
        String id = factor1String + "_" + factor2String + "_" + targetString;
        return new TwoWayKeyDriver(id, summaryStats, inputFields, targetString, this.categories, factor1, factor2, this.context);
    }
}

